/*
 * Decompiled with CFR 0.152.
 */
package org.granite.jmx;

import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.jmx.MBeanServerLocator;
import org.granite.jmx.OpenMBean;
import org.granite.logging.Logger;

public class GraniteMBeanInitializer {
    private static final Logger log = Logger.getLogger(GraniteMBeanInitializer.class);

    public static void registerMBeans(ServletContext context, ServletGraniteConfig gConfig, ServletServicesConfig sConfig) {
        try {
            ObjectName name = new ObjectName("org.granite:type=GraniteConfig,context=" + context.getServletContextName());
            log.info("Registering MBean: %s", name);
            OpenMBean mBean = OpenMBean.createMBean(gConfig);
            MBeanServerLocator.getInstance().register(mBean, name);
        }
        catch (Exception e) {
            log.error(e, "Could not register GraniteConfig MBean for context: %s", context.getServletContextName());
        }
    }

    public static void unregisterMBeans(ServletContext context) {
        try {
            ObjectName name = new ObjectName("org.granite:type=GraniteConfig,context=" + context.getServletContextName());
            log.info("Unregistering MBean: %s", name);
            MBeanServerLocator.getInstance().unregister(name);
        }
        catch (Exception e) {
            log.error(e, "Could not unregister GraniteConfig MBean for context: %s", context.getServletContextName());
        }
    }
}

