/*
 * Decompiled with CFR 0.152.
 */
package org.granite.jmx;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanServerLocator {
    private static MBeanServerLocator instance = null;
    private final MBeanServer server = MBeanServerLocator.findMBeanServer();

    private MBeanServerLocator() {
    }

    private static MBeanServer findMBeanServer() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (MBeanServer found : MBeanServerFactory.findMBeanServer(null)) {
            if (!(found instanceof MBeanServer) || !"jboss".equals(found.getDefaultDomain())) continue;
            server = found;
            break;
        }
        return server;
    }

    public static synchronized MBeanServerLocator getInstance() {
        if (instance == null) {
            instance = new MBeanServerLocator();
        }
        return instance;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public void register(Object mbean, ObjectName name) throws MBeanRegistrationException, InstanceNotFoundException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        this.register(mbean, name, false);
    }

    public void register(Object mbean, ObjectName name, boolean replace) throws MBeanRegistrationException, InstanceNotFoundException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        if (this.server != null) {
            if (replace && this.server.isRegistered(name)) {
                this.server.unregisterMBean(name);
            }
            this.server.registerMBean(mbean, name);
        }
    }

    public boolean isRegistered(ObjectName name) {
        return this.server != null && this.server.isRegistered(name);
    }

    public void unregister(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.server != null) {
            this.server.unregisterMBean(name);
        }
    }
}

