/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import weblogic.servlet.security.ServletAuthentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicSecurityService
extends AbstractSecurityService {
    @Override
    public void configure(Map<String, String> params) {
    }

    @Override
    public void login(Object credentials) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials);
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        HttpServletResponse httpResponse = context.getResponse();
        int result = 1;
        try {
            result = ServletAuthentication.login((String)decoded[0], (String)decoded[1], (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        if (result != 0) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        httpRequest.getSession(true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        if (context.getDestination().isSecured()) {
            graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            httpRequest = graniteContext.getRequest();
            principal = httpRequest.getUserPrincipal();
            if (principal == null) {
                if (httpRequest.getRequestedSessionId() != null && ((httpSession = httpRequest.getSession(false)) == null || httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException("Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException("User not logged in");
            }
            accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!httpRequest.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            t /* !! */  = e;
            ** while (t /* !! */  != null)
        }
lbl-1000:
        // 1 sources

        {
            if (t /* !! */  instanceof SecurityException || "javax.ejb.EJBAccessException".equals(t /* !! */ .getClass().getName())) {
                throw SecurityServiceException.newAccessDeniedException(t /* !! */ .getMessage());
            }
            t /* !! */  = t /* !! */ .getCause();
            continue;
        }
lbl26:
        // 1 sources

        throw e;
    }

    @Override
    public void logout() throws SecurityServiceException {
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        if (httpRequest.getSession(false) != null) {
            httpRequest.getSession().invalidate();
        }
        ServletAuthentication.logout((HttpServletRequest)httpRequest);
    }
}

