/*
 * Decompiled with CFR 0.152.
 */
package org.granite.osgi.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.granite.logging.Logger;
import org.granite.osgi.classloader.ServiceClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestMetadataParser
implements SynchronousBundleListener {
    private static final Logger log = Logger.getLogger(ManifestMetadataParser.class);
    private static final String SEPERATOR = ",";
    private static final String SERVICES = "services";
    private static final String SERVICE = "service";
    private static final String PROP_PACKAGES = "packages";
    private static final String GRANITEDS_SERVICE = "GraniteDS-Service";
    ServiceClassLoader classLoader;
    ServiceTracker eventAdminTracker;
    BundleContext context;
    Set<Class<?>> classes;
    String granitedsMeta;
    static DocumentBuilder documentBuilder;
    private final MetadataProcessor processorThread = new MetadataProcessor();

    public ManifestMetadataParser(BundleContext context) {
        this.context = context;
    }

    private void setGraniteMeta(String granitedsMeta) {
        this.granitedsMeta = granitedsMeta;
    }

    private EventAdmin getEventAdmin() {
        return (EventAdmin)this.eventAdminTracker.getService();
    }

    private void broadcastServicesChanged(String eventTopic) {
        if (this.classes != null && this.classes.size() > 0) {
            Hashtable properties = new Hashtable();
            ((Dictionary)properties).put("serviceClassSet", this.classes);
            EventAdmin eadmin = this.getEventAdmin();
            if (eadmin != null) {
                eadmin.sendEvent(new Event(eventTopic, properties));
            } else if (log.isErrorEnabled()) {
                log.error("EventAdmin is unavailable, cannot broadcast Event!!!", new Object[0]);
            }
        }
    }

    private void parseMetadata(Bundle bundle, String eventTopic) {
        if (log.isInfoEnabled()) {
            log.info("GraniteDS-Service:" + this.granitedsMeta, new Object[0]);
        }
        this.classLoader.setBundle(bundle);
        DocumentBuilder builder = ManifestMetadataParser.getDocumentBuilder();
        try {
            if (builder != null) {
                if (this.granitedsMeta == null || "".equals(this.granitedsMeta)) {
                    return;
                }
                InputStream is = bundle.getEntry(this.granitedsMeta).openStream();
                if (is == null) {
                    return;
                }
                Document doc = builder.parse(is);
                Element servicesNode = (Element)doc.getElementsByTagName(SERVICES).item(0);
                NodeList services = servicesNode.getElementsByTagName(SERVICE);
                int i = 0;
                while (i < services.getLength()) {
                    Element service = (Element)services.item(i);
                    String[] servicePackages = service.getAttribute(PROP_PACKAGES).split(SEPERATOR);
                    if (servicePackages == null) {
                        throw new RuntimeException("Invalid Service at " + i);
                    }
                    this.classes.addAll(this.classLoader.loadClasses(servicePackages));
                    ++i;
                }
                this.broadcastServicesChanged(eventTopic);
            }
        }
        catch (SAXException e) {
            log.error(e, "Could not parse metadata", new Object[0]);
        }
        catch (IOException e) {
            log.error(e, "Could not parse metadata", new Object[0]);
        }
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        try {
            if (documentBuilder == null) {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
        }
        catch (ParserConfigurationException e) {
            log.error(e, "Could not get document builder", new Object[0]);
        }
        documentBuilder.reset();
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.classLoader = new ServiceClassLoader();
        this.eventAdminTracker = new ServiceTracker(this.context, EventAdmin.class.getName(), null);
        this.eventAdminTracker.open();
        new Thread(this.processorThread).start();
        ManifestMetadataParser manifestMetadataParser = this;
        synchronized (manifestMetadataParser) {
            this.context.addBundleListener((BundleListener)this);
        }
        if (this.classes == null) {
            this.classes = new HashSet();
        } else {
            this.classes.clear();
        }
    }

    public void stop() {
        this.eventAdminTracker.close();
        this.processorThread.stop();
        this.context.removeBundleListener((BundleListener)this);
        this.classLoader = null;
        this.classes = null;
    }

    private boolean hasDataService(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        Object gsd = bundle.getHeaders().get(GRANITEDS_SERVICE);
        if (gsd != null) {
            this.setGraniteMeta(gsd.toString());
        }
        return gsd != null || "".equals(gsd);
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (this.context.getBundle() == bundle || !this.hasDataService(bundle)) {
            return;
        }
        switch (event.getType()) {
            case 2: {
                this.processorThread.addBundle(bundle);
                break;
            }
            case 256: {
                this.processorThread.removeBundle(bundle);
                break;
            }
        }
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ void access$1(ManifestMetadataParser manifestMetadataParser, Bundle bundle, String string) {
        manifestMetadataParser.parseMetadata(bundle, string);
    }

    private class MetadataProcessor
    implements Runnable {
        private boolean hasStarted = true;
        private List<Bundle> bundles = new ArrayList<Bundle>();
        private List<Bundle> removedBundles = new ArrayList<Bundle>();

        private MetadataProcessor() {
        }

        private synchronized void addBundle(Bundle bundle) {
            this.bundles.add(bundle);
            this.notifyAll();
        }

        private synchronized void removeBundle(Bundle bundle) {
            this.bundles.remove(bundle);
            this.removedBundles.add(bundle);
            this.notifyAll();
        }

        public synchronized void stop() {
            this.hasStarted = false;
            this.bundles.clear();
            this.notifyAll();
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

