/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.invocation;

import java.util.List;
import java.util.Map;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TideMessage;
import org.granite.tide.invocation.ContextEvent;
import org.granite.tide.invocation.ContextUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationResult
implements IInvocationResult {
    private static final long serialVersionUID = 1L;
    private Object result;
    private int scope;
    private boolean restrict;
    private boolean merge = true;
    private Object[][] updates;
    private List<ContextUpdate> results;
    private List<ContextEvent> events;
    private List<TideMessage> messages;
    private Map<String, List<TideMessage>> keyedMessages;

    public InvocationResult() {
    }

    public InvocationResult(Object result) {
        this.result = result;
    }

    public InvocationResult(Object result, List<ContextUpdate> results) {
        this.result = result;
        this.results = results;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public boolean getRestrict() {
        return this.restrict;
    }

    public void setRestrict(boolean restrict) {
        this.restrict = restrict;
    }

    public boolean getMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public Object[][] getUpdates() {
        return this.updates;
    }

    public void setUpdates(Object[][] updates) {
        this.updates = updates;
    }

    public List<ContextUpdate> getResults() {
        return this.results;
    }

    public void setResults(List<ContextUpdate> results) {
        this.results = results;
    }

    public List<ContextEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ContextEvent> events) {
        this.events = events;
    }

    public List<TideMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<TideMessage> messages) {
        this.messages = messages;
    }

    public Map<String, List<TideMessage>> getKeyedMessages() {
        return this.keyedMessages;
    }

    public void setKeyedMessages(Map<String, List<TideMessage>> keyedMessages) {
        this.keyedMessages = keyedMessages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(" ");
        if (this.scope == 1) {
            sb.append("(SESSION) ");
        } else if (this.scope == 2) {
            sb.append("(CONVERSATION) ");
        }
        if (this.restrict) {
            sb.append("(RESTRICTED) ");
        }
        sb.append("{\n");
        sb.append("\tresult: ").append(this.result != null ? this.result : "(null)");
        if (this.results != null) {
            sb.append("\tresults: [");
            for (ContextUpdate result : this.results) {
                sb.append(result != null ? ((Object)result).toString() : "(null)").append(" ");
            }
            sb.append("]\n");
        }
        if (this.updates != null) {
            sb.append("\tupdates: [");
            Object[][] objectArray = this.updates;
            int n = this.updates.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] update = objectArray[n2];
                sb.append(update[0]).append(":").append(update[1]).append(" ");
                ++n2;
            }
            sb.append("]\n");
        }
        if (this.events != null) {
            sb.append("\tevents: [");
            for (ContextEvent event : this.events) {
                sb.append(event).append(" ");
            }
            sb.append("]\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

