/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import javax.servlet.http.HttpSession;
import org.granite.clustering.GraniteDistributedData;
import org.granite.clustering.GraniteDistributedDataFactory;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Destination;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncChannelRunner;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Channel;
import org.granite.gravity.ChannelTimerTask;
import org.granite.gravity.DefaultGravityMBean;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.GravityPool;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.Subscription;
import org.granite.gravity.TimeChannel;
import org.granite.gravity.adapters.AdapterFactory;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.gravity.security.GravityDestinationSecurizer;
import org.granite.gravity.security.GravityInvocationContext;
import org.granite.jmx.MBeanServerLocator;
import org.granite.jmx.OpenMBean;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.UUIDUtil;

public class DefaultGravity
implements Gravity,
DefaultGravityMBean {
    private static final Logger log = Logger.getLogger(Gravity.class);
    private final Map<String, Object> applicationMap = new HashMap<String, Object>();
    private final ConcurrentHashMap<String, TimeChannel> channels = new ConcurrentHashMap();
    private GravityConfig gravityConfig = null;
    private ServicesConfig servicesConfig = null;
    private GraniteConfig graniteConfig = null;
    private Channel serverChannel = null;
    private AdapterFactory adapterFactory = null;
    private GravityPool gravityPool = null;
    private Timer channelsTimer;
    private boolean started;

    public DefaultGravity(GravityConfig gravityConfig, ServicesConfig servicesConfig, GraniteConfig graniteConfig) {
        if (gravityConfig == null || servicesConfig == null || graniteConfig == null) {
            throw new NullPointerException("All arguments must be non null.");
        }
        this.gravityConfig = gravityConfig;
        this.servicesConfig = servicesConfig;
        this.graniteConfig = graniteConfig;
    }

    public GravityConfig getGravityConfig() {
        return this.gravityConfig;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public GraniteConfig getGraniteConfig() {
        return this.graniteConfig;
    }

    public boolean isStarted() {
        return this.started;
    }

    public ServiceAdapter getServiceAdapter(String messageType, String destinationId) {
        return this.adapterFactory.getServiceAdapter(messageType, destinationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        log.info("Starting Gravity...", new Object[0]);
        DefaultGravity defaultGravity = this;
        synchronized (defaultGravity) {
            if (!this.started) {
                this.adapterFactory = new AdapterFactory(this);
                this.internalStart();
                this.serverChannel = new ServerChannel(this, this.gravityConfig, ServerChannel.class.getName());
                this.started = true;
            }
        }
        log.info("Gravity successfully started.", new Object[0]);
    }

    protected void internalStart() {
        this.gravityPool = new GravityPool(this.gravityConfig);
        this.channelsTimer = new Timer();
        if (this.graniteConfig.isRegisterMBeans()) {
            try {
                ObjectName name = new ObjectName("org.graniteds:type=Gravity,context=" + this.graniteConfig.getMBeanContextName());
                log.info("Registering MBean: %s", name);
                OpenMBean mBean = OpenMBean.createMBean(this);
                MBeanServerLocator.getInstance().register(mBean, name, true);
            }
            catch (Exception e) {
                log.error(e, "Could not register Gravity MBean for context: %s", this.graniteConfig.getMBeanContextName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() throws Exception {
        DefaultGravity defaultGravity = this;
        synchronized (defaultGravity) {
            this.stop();
            this.start();
        }
    }

    public void reconfigure(GravityConfig gravityConfig, GraniteConfig graniteConfig) {
        this.gravityConfig = gravityConfig;
        this.graniteConfig = graniteConfig;
        if (this.gravityPool != null) {
            this.gravityPool.reconfigure(gravityConfig);
        }
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean now) throws Exception {
        log.info("Stopping Gravity (now=%s)...", now);
        DefaultGravity defaultGravity = this;
        synchronized (defaultGravity) {
            if (this.adapterFactory != null) {
                try {
                    this.adapterFactory.stopAll();
                }
                catch (Exception e) {
                    log.error(e, "Error while stopping adapter factory", new Object[0]);
                }
                this.adapterFactory = null;
            }
            if (this.serverChannel != null) {
                try {
                    this.removeChannel(this.serverChannel.getId());
                }
                catch (Exception e) {
                    log.error(e, "Error while removing server channel: %s", this.serverChannel);
                }
                this.serverChannel = null;
            }
            if (this.channelsTimer != null) {
                try {
                    this.channelsTimer.cancel();
                }
                catch (Exception e) {
                    log.error(e, "Error while cancelling channels timer", new Object[0]);
                }
                this.channelsTimer = null;
            }
            if (this.gravityPool != null) {
                try {
                    if (now) {
                        this.gravityPool.shutdownNow();
                    } else {
                        this.gravityPool.shutdown();
                    }
                }
                catch (Exception e) {
                    log.error(e, "Error while stopping thread pool", new Object[0]);
                }
                this.gravityPool = null;
            }
            this.started = false;
        }
        log.info("Gravity sucessfully stopped.", new Object[0]);
    }

    public String getGravityFactoryName() {
        return this.gravityConfig.getGravityFactory();
    }

    public String getChannelFactoryName() {
        if (this.gravityConfig.getChannelFactory() != null) {
            return this.gravityConfig.getChannelFactory().getClass().getName();
        }
        return null;
    }

    public long getChannelIdleTimeoutMillis() {
        return this.gravityConfig.getChannelIdleTimeoutMillis();
    }

    public void setChannelIdleTimeoutMillis(long channelIdleTimeoutMillis) {
        this.gravityConfig.setChannelIdleTimeoutMillis(channelIdleTimeoutMillis);
    }

    public boolean isRetryOnError() {
        return this.gravityConfig.isRetryOnError();
    }

    public void setRetryOnError(boolean retryOnError) {
        this.gravityConfig.setRetryOnError(retryOnError);
    }

    public long getLongPollingTimeoutMillis() {
        return this.gravityConfig.getLongPollingTimeoutMillis();
    }

    public void setLongPollingTimeoutMillis(long longPollingTimeoutMillis) {
        this.gravityConfig.setLongPollingTimeoutMillis(longPollingTimeoutMillis);
    }

    public int getMaxMessagesQueuedPerChannel() {
        return this.gravityConfig.getMaxMessagesQueuedPerChannel();
    }

    public void setMaxMessagesQueuedPerChannel(int maxMessagesQueuedPerChannel) {
        this.gravityConfig.setMaxMessagesQueuedPerChannel(maxMessagesQueuedPerChannel);
    }

    public long getReconnectIntervalMillis() {
        return this.gravityConfig.getReconnectIntervalMillis();
    }

    public int getReconnectMaxAttempts() {
        return this.gravityConfig.getReconnectMaxAttempts();
    }

    public int getCorePoolSize() {
        if (this.gravityPool != null) {
            return this.gravityPool.getCorePoolSize();
        }
        return this.gravityConfig.getCorePoolSize();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.gravityConfig.setCorePoolSize(corePoolSize);
        if (this.gravityPool != null) {
            this.gravityPool.setCorePoolSize(corePoolSize);
        }
    }

    public long getKeepAliveTimeMillis() {
        if (this.gravityPool != null) {
            return this.gravityPool.getKeepAliveTimeMillis();
        }
        return this.gravityConfig.getKeepAliveTimeMillis();
    }

    public void setKeepAliveTimeMillis(long keepAliveTimeMillis) {
        this.gravityConfig.setKeepAliveTimeMillis(keepAliveTimeMillis);
        if (this.gravityPool != null) {
            this.gravityPool.setKeepAliveTimeMillis(keepAliveTimeMillis);
        }
    }

    public int getMaximumPoolSize() {
        if (this.gravityPool != null) {
            return this.gravityPool.getMaximumPoolSize();
        }
        return this.gravityConfig.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.gravityConfig.setMaximumPoolSize(maximumPoolSize);
        if (this.gravityPool != null) {
            this.gravityPool.setMaximumPoolSize(maximumPoolSize);
        }
    }

    public int getQueueCapacity() {
        if (this.gravityPool != null) {
            return this.gravityPool.getQueueCapacity();
        }
        return this.gravityConfig.getQueueCapacity();
    }

    public int getQueueRemainingCapacity() {
        if (this.gravityPool != null) {
            return this.gravityPool.getQueueRemainingCapacity();
        }
        return this.gravityConfig.getQueueCapacity();
    }

    public int getQueueSize() {
        if (this.gravityPool != null) {
            return this.gravityPool.getQueueSize();
        }
        return 0;
    }

    protected Channel createChannel() {
        Channel channel = this.gravityConfig.getChannelFactory().newChannel(UUIDUtil.randomUUID());
        TimeChannel timeChannel = new TimeChannel(channel);
        int i = 0;
        while (this.channels.putIfAbsent(channel.getId(), timeChannel) != null) {
            if (i >= 10) {
                throw new RuntimeException("Could not find random new clientId after 10 iterations");
            }
            channel.destroy();
            channel = this.gravityConfig.getChannelFactory().newChannel(UUIDUtil.randomUUID());
            timeChannel = new TimeChannel(channel);
            ++i;
        }
        String channelId = channel.getId();
        try {
            GraniteDistributedData gdd = GraniteDistributedDataFactory.getInstance();
            if (gdd != null) {
                log.debug("Saving channel id in distributed data: %s", channelId);
                gdd.addChannelId(channelId);
            }
        }
        catch (Exception e) {
            log.error(e, "Could not add channel id in distributed data: %s", channelId);
        }
        this.access(channelId);
        return channel;
    }

    public Channel getChannel(String channelId) {
        if (channelId == null) {
            return null;
        }
        TimeChannel timeChannel = this.channels.get(channelId);
        if (timeChannel == null) {
            try {
                GraniteDistributedData gdd = GraniteDistributedDataFactory.getInstance();
                if (gdd != null && gdd.hasChannelId(channelId)) {
                    log.debug("Found channel id in distributed data: %s", channelId);
                    Channel channel = this.gravityConfig.getChannelFactory().newChannel(channelId);
                    timeChannel = new TimeChannel(channel);
                    if (this.channels.putIfAbsent(channelId, timeChannel) == null) {
                        for (CommandMessage subscription : gdd.getSubscriptions(channelId)) {
                            log.debug("Resubscribing channel: %s - %s", channelId, subscription);
                            this.handleSubscribeMessage(subscription, false);
                        }
                        this.access(channelId);
                    }
                }
            }
            catch (Exception e) {
                log.error(e, "Could not recreate channel/sunscriptions from distributed data: %s", channelId);
            }
        }
        return timeChannel != null ? timeChannel.getChannel() : null;
    }

    public Channel removeChannel(String channelId) {
        if (channelId == null) {
            return null;
        }
        try {
            GraniteDistributedData gdd = GraniteDistributedDataFactory.getInstance();
            if (gdd != null) {
                log.debug("Removing channel id from distributed data: %s", channelId);
                gdd.removeChannelId(channelId);
            }
        }
        catch (Exception e) {
            log.error(e, "Could not remove channel id from distributed data: %s", channelId);
        }
        TimeChannel timeChannel = this.channels.get(channelId);
        Channel channel = null;
        if (timeChannel != null) {
            try {
                if (timeChannel.getTimerTask() != null) {
                    timeChannel.getTimerTask().cancel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            channel = timeChannel.getChannel();
            try {
                for (Subscription subscription : channel.getSubscriptions()) {
                    try {
                        Message message = subscription.getUnsubscribeMessage();
                        this.handleMessage(message, true);
                    }
                    catch (Exception e) {
                        log.error(e, "Error while unsubscribing channel: %s from subscription: %s", channel, subscription);
                    }
                }
            }
            finally {
                try {
                    channel.destroy();
                }
                finally {
                    this.channels.remove(channelId);
                }
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean access(String channelId) {
        TimeChannel timeChannel;
        if (channelId != null && (timeChannel = this.channels.get(channelId)) != null) {
            TimeChannel timeChannel2 = timeChannel;
            synchronized (timeChannel2) {
                TimerTask timerTask = timeChannel.getTimerTask();
                if (timerTask != null) {
                    log.debug("Canceling TimerTask: %s", timerTask);
                    timerTask.cancel();
                    timeChannel.setTimerTask(null);
                }
                timerTask = new ChannelTimerTask(this, channelId);
                timeChannel.setTimerTask(timerTask);
                long timeout = this.gravityConfig.getChannelIdleTimeoutMillis();
                log.debug("Scheduling TimerTask: %s for %s ms.", timerTask, timeout);
                this.channelsTimer.schedule(timerTask, timeout);
                return true;
            }
        }
        return false;
    }

    public void execute(AsyncChannelRunner runner) {
        if (this.gravityPool == null) {
            runner.reset();
            throw new NullPointerException("Gravity not started or pool disabled");
        }
        this.gravityPool.execute(runner);
    }

    public boolean cancel(AsyncChannelRunner runner) {
        if (this.gravityPool == null) {
            runner.reset();
            throw new NullPointerException("Gravity not started or pool disabled");
        }
        return this.gravityPool.remove(runner);
    }

    public Message handleMessage(Message message) {
        return this.handleMessage(message, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message handleMessage(Message message, boolean skipInterceptor) {
        interceptor = null;
        if (!skipInterceptor) {
            interceptor = GraniteContext.getCurrentInstance().getGraniteConfig().getAmf3MessageInterceptor();
        }
        reply = null;
        try {
            if (interceptor != null) {
                interceptor.before(message);
            }
            if (!(message instanceof CommandMessage)) ** GOTO lbl50
            command = (CommandMessage)message;
            switch (command.getOperation()) {
                case 8: 
                case 9: {
                    var7_7 = this.handleSecurityMessage(command);
                    if (interceptor != null) {
                        interceptor.after(message, reply);
                    }
                    return var7_7;
                }
                case 5: {
                    var7_8 = this.handlePingMessage(command);
                    if (interceptor != null) {
                        interceptor.after(message, reply);
                    }
                    return var7_8;
                }
                case 20: {
                    var7_9 = this.handleConnectMessage(command);
                    if (interceptor != null) {
                        interceptor.after(message, reply);
                    }
                    return var7_9;
                }
            }
        }
        catch (Throwable var6_13) {
            if (interceptor != null) {
                interceptor.after(message, reply);
            }
            throw var6_13;
        }
        {
            case 21: {
                var7_10 = this.handleDisconnectMessage(command);
                if (interceptor != null) {
                    interceptor.after(message, reply);
                }
                return var7_10;
            }
            case 0: {
                var7_11 = this.handleSubscribeMessage(command);
                if (interceptor != null) {
                    interceptor.after(message, reply);
                }
                return var7_11;
            }
            case 1: {
                var7_12 = this.handleUnsubscribeMessage(command);
                if (interceptor != null) {
                    interceptor.after(message, reply);
                }
                return var7_12;
            }
        }
        throw new UnsupportedOperationException("Unsupported command operation: " + command);
lbl50:
        // 1 sources

        reply = this.handlePublishMessage((AsyncMessage)message);
        if (interceptor != null) {
            interceptor.after(message, reply);
        }
        if (reply != null && (context = GraniteContext.getCurrentInstance()) instanceof HttpGraniteContext && (session = ((HttpGraniteContext)context).getRequest().getSession(false)) != null) {
            reply.setHeader("org.granite.sessionId", session.getId());
        }
        return reply;
    }

    public GraniteContext initThread() {
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context == null) {
            context = SimpleGraniteContext.createThreadIntance(this.graniteConfig, this.servicesConfig, this.applicationMap);
        }
        return context;
    }

    public void releaseThread() {
        GraniteContext.release();
    }

    public Message publishMessage(AsyncMessage message) {
        return this.publishMessage(this.serverChannel, message);
    }

    public Message publishMessage(Channel fromChannel, AsyncMessage message) {
        this.initThread();
        return this.handlePublishMessage(message, fromChannel != null ? fromChannel : this.serverChannel);
    }

    private Message handlePingMessage(CommandMessage message) {
        Channel channel = this.createChannel();
        AcknowledgeMessage reply = new AcknowledgeMessage(message);
        reply.setClientId(channel.getId());
        HashMap<String, Long> advice = new HashMap<String, Long>();
        advice.put("reconnect-interval-ms", this.gravityConfig.getReconnectIntervalMillis());
        advice.put("reconnect-max-attempts", Long.valueOf(this.gravityConfig.getReconnectMaxAttempts()));
        reply.setBody(advice);
        reply.setDestination(message.getDestination());
        log.debug("handshake.handle: reply=%s", reply);
        return reply;
    }

    private Message handleSecurityMessage(CommandMessage message) {
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        AcknowledgeMessage response = null;
        if (!config.hasSecurityService()) {
            log.warn("Ignored security operation (no security settings in granite-config.xml): %s", message);
        } else {
            SecurityService securityService = config.getSecurityService();
            try {
                if (message.isLoginOperation()) {
                    securityService.login(message.getBody());
                } else {
                    securityService.logout();
                }
            }
            catch (Exception e) {
                if (e instanceof SecurityServiceException) {
                    log.debug(e, "Could not process security operation: %s", message);
                } else {
                    log.error(e, "Could not process security operation: %s", message);
                }
                response = new ErrorMessage(message, e, true);
            }
        }
        if (response == null) {
            response = new AcknowledgeMessage(message, true);
            if (message.isSecurityOperation()) {
                response.setBody("success");
            }
        }
        return response;
    }

    private Message handleConnectMessage(CommandMessage message) {
        Channel client = this.getChannel((String)message.getClientId());
        if (client == null) {
            return this.handleUnknownClientMessage(message);
        }
        return null;
    }

    private Message handleDisconnectMessage(CommandMessage message) {
        Channel client = this.getChannel((String)message.getClientId());
        if (client == null) {
            return this.handleUnknownClientMessage(message);
        }
        this.removeChannel(client.getId());
        AcknowledgeMessage reply = new AcknowledgeMessage(message);
        reply.setDestination(message.getDestination());
        reply.setClientId(client.getId());
        return reply;
    }

    private Message handleSubscribeMessage(CommandMessage message) {
        return this.handleSubscribeMessage(message, true);
    }

    private Message handleSubscribeMessage(final CommandMessage message, final boolean saveMessageInSession) {
        GraniteConfig config;
        final GraniteContext context = GraniteContext.getCurrentInstance();
        final Destination destination = context.getServicesConfig().findDestinationById(message.getMessageRefType(), message.getDestination());
        if (destination == null) {
            return this.getInvalidDestinationError(message);
        }
        GravityInvocationContext invocationContext = new GravityInvocationContext(message, destination){

            public Object invoke() throws Exception {
                Channel channel = DefaultGravity.this.getChannel((String)message.getClientId());
                if (channel == null) {
                    return DefaultGravity.this.handleUnknownClientMessage(message);
                }
                String subscriptionId = (String)message.getHeader("DSDstClientId");
                if (subscriptionId == null) {
                    subscriptionId = UUIDUtil.randomUUID();
                    message.setHeader("DSDstClientId", subscriptionId);
                }
                HttpSession session = null;
                if (context instanceof HttpGraniteContext) {
                    session = ((HttpGraniteContext)context).getSession(false);
                }
                GraniteDistributedData gdd = null;
                if (session != null) {
                    gdd = GraniteDistributedDataFactory.getInstance();
                    if (Boolean.TRUE.toString().equals(destination.getProperties().get("session-selector"))) {
                        String selector = gdd.getDestinationSelector(destination.getId());
                        log.debug("Session selector found in session %s: %s", session.getId(), selector);
                        if (selector != null) {
                            message.setHeader("DSSelector", selector);
                        }
                    }
                }
                ServiceAdapter adapter = DefaultGravity.this.adapterFactory.getServiceAdapter(message);
                AsyncMessage reply = (AsyncMessage)adapter.manage(channel, message);
                DefaultGravity.this.postManage(channel);
                if (saveMessageInSession && !(reply instanceof ErrorMessage)) {
                    try {
                        if (gdd != null) {
                            log.debug("Saving new subscription message for channel: %s - %s", channel.getId(), message);
                            gdd.addSubcription(channel.getId(), message);
                        }
                    }
                    catch (Exception e) {
                        log.error(e, "Could not add subscription in distributed data: %s - %s", channel.getId(), subscriptionId);
                    }
                }
                reply.setDestination(message.getDestination());
                reply.setClientId(channel.getId());
                reply.getHeaders().putAll(message.getHeaders());
                if (gdd != null && message.getDestination() != null) {
                    gdd.setDestinationClientId(message.getDestination(), channel.getId());
                    gdd.setDestinationSubscriptionId(message.getDestination(), subscriptionId);
                }
                return reply;
            }
        };
        if (destination.getSecurizer() instanceof GravityDestinationSecurizer) {
            try {
                ((GravityDestinationSecurizer)destination.getSecurizer()).canSubscribe(invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage((Message)message, e);
            }
        }
        if ((config = context.getGraniteConfig()).hasSecurityService()) {
            try {
                return (Message)config.getSecurityService().authorize(invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage((Message)message, e);
            }
        }
        try {
            return (Message)invocationContext.invoke();
        }
        catch (Exception e) {
            return new ErrorMessage(message, e, true);
        }
    }

    private Message handleUnsubscribeMessage(CommandMessage message) {
        Channel channel = this.getChannel((String)message.getClientId());
        if (channel == null) {
            return this.handleUnknownClientMessage(message);
        }
        AcknowledgeMessage reply = null;
        ServiceAdapter adapter = this.adapterFactory.getServiceAdapter(message);
        reply = (AcknowledgeMessage)adapter.manage(channel, message);
        this.postManage(channel);
        if (!(reply instanceof ErrorMessage)) {
            try {
                GraniteDistributedData gdd = GraniteDistributedDataFactory.getInstance();
                if (gdd != null) {
                    String subscriptionId = (String)message.getHeader("DSDstClientId");
                    log.debug("Removing subscription message from channel info: %s - %s", channel.getId(), subscriptionId);
                    gdd.removeSubcription(channel.getId(), subscriptionId);
                }
            }
            catch (Exception e) {
                log.error(e, "Could not remove subscription from distributed data: %s - %s", channel.getId(), message.getHeader("DSDstClientId"));
            }
        }
        reply.setDestination(message.getDestination());
        reply.setClientId(channel.getId());
        reply.getHeaders().putAll(message.getHeaders());
        return reply;
    }

    protected void postManage(Channel channel) {
    }

    private Message handlePublishMessage(AsyncMessage message) {
        return this.handlePublishMessage(message, null);
    }

    private Message handlePublishMessage(final AsyncMessage message, final Channel channel) {
        GraniteConfig config;
        GraniteContext context = GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(message.getClass().getName(), message.getDestination());
        if (destination == null) {
            return this.getInvalidDestinationError(message);
        }
        GravityInvocationContext invocationContext = new GravityInvocationContext(message, destination){

            public Object invoke() throws Exception {
                Channel fromChannel = channel;
                if (fromChannel == null) {
                    fromChannel = DefaultGravity.this.getChannel((String)message.getClientId());
                }
                if (fromChannel == null) {
                    return DefaultGravity.this.handleUnknownClientMessage(message);
                }
                ServiceAdapter adapter = DefaultGravity.this.adapterFactory.getServiceAdapter(message);
                AsyncMessage reply = (AsyncMessage)adapter.invoke(fromChannel, message);
                reply.setDestination(message.getDestination());
                reply.setClientId(fromChannel.getId());
                return reply;
            }
        };
        if (destination.getSecurizer() instanceof GravityDestinationSecurizer) {
            try {
                ((GravityDestinationSecurizer)destination.getSecurizer()).canPublish(invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage(message, e, true);
            }
        }
        if ((config = context.getGraniteConfig()).hasSecurityService() && context instanceof HttpGraniteContext) {
            try {
                return (Message)config.getSecurityService().authorize(invocationContext);
            }
            catch (Exception e) {
                return new ErrorMessage(message, e, true);
            }
        }
        try {
            return (Message)invocationContext.invoke();
        }
        catch (Exception e) {
            return new ErrorMessage(message, e, true);
        }
    }

    private Message handleUnknownClientMessage(Message message) {
        ErrorMessage reply = new ErrorMessage(message, true);
        reply.setFaultCode("Server.Call.UnknownClient");
        reply.setFaultString("Unknown client");
        return reply;
    }

    private ErrorMessage getInvalidDestinationError(Message message) {
        String messageType = message.getClass().getName();
        if (message instanceof CommandMessage) {
            messageType = String.valueOf(messageType) + '[' + ((CommandMessage)message).getMessageRefType() + ']';
        }
        ErrorMessage reply = new ErrorMessage(message, true);
        reply.setFaultCode("Server.Messaging.InvalidDestination");
        reply.setFaultString("No configured destination for id: " + message.getDestination() + " and message type: " + messageType);
        return reply;
    }

    private static class ServerChannel
    extends AbstractChannel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Gravity gravity;

        public ServerChannel(Gravity gravity, GravityConfig gravityConfig, String channelId) {
            super(null, gravityConfig, channelId);
            this.gravity = gravity;
        }

        public Gravity getGravity() {
            return this.gravity;
        }

        public void receive(AsyncMessage message) throws MessageReceivingException {
        }

        protected boolean hasAsyncHttpContext() {
            return false;
        }

        protected AsyncHttpContext acquireAsyncHttpContext() {
            return null;
        }

        protected void releaseAsyncHttpContext(AsyncHttpContext context) {
        }
    }
}

