/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.io.Serializable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.gravity.adapters.JMSClient;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.data.AbstractDataDispatcher;
import org.granite.tide.data.DataTopicParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSDataDispatcher
extends AbstractDataDispatcher {
    private static final Logger log = Logger.getLogger(JMSDataDispatcher.class);
    private boolean transacted = false;
    private TopicConnectionFactory connectionFactory = null;
    private Topic topic;
    private JMSClient jmsClient = null;

    public JMSDataDispatcher(String topicName, boolean transacted, Class<? extends DataTopicParams> dataTopicParamsClass) {
        super(topicName, dataTopicParamsClass);
        this.transacted = transacted;
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        if (graniteContext instanceof HttpGraniteContext) {
            HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
            if (session == null) {
                log.debug("Gravity not found or HTTP session not found, data dispatch disabled", new Object[0]);
                return;
            }
            this.sessionId = session.getId();
            this.jmsClient = (JMSClient)((HttpGraniteContext)graniteContext).getSessionMap().get("org.granite.gravity.jmsClient." + topicName);
        } else {
            this.sessionId = "__GDS_SERVER_DISPATCHER__";
            try {
                InitialContext ic = new InitialContext();
                this.connectionFactory = (TopicConnectionFactory)ic.lookup("java:comp/env/tide/ConnectionFactory");
                this.topic = (Topic)ic.lookup("java:comp/env/tide/topic/" + topicName);
            }
            catch (NamingException e) {
                log.warn(e, "Could not retrieve ConnectionFactory and Topic in JNDI for topic %s", topicName);
                return;
            }
        }
        this.enabled = true;
    }

    @Override
    protected void changeDataSelector(String dataSelector) {
        if (this.jmsClient != null) {
            try {
                this.jmsClient.subscribe(dataSelector, this.topicName, "tideDataTopic");
                log.debug("JMS Topic %s data selector changed: %s", this.topicName, dataSelector);
            }
            catch (Exception e) {
                log.error(e, "Could not change JMS Topic %s data selector: %s", this.topicName);
            }
        }
    }

    @Override
    public void publishUpdate(Map<String, String> params, Object body) {
        if (this.jmsClient != null) {
            try {
                this.jmsClient.send(params, body, 0L);
            }
            catch (Exception e) {
                log.error("Could not dispatch data update on topic %s using internal JMS client, message %s", this.topicName, body.toString());
            }
        } else if (this.enabled) {
            try {
                Connection jmsConnection = this.connectionFactory.createConnection();
                Session jmsSession = jmsConnection.createSession(this.transacted, 1);
                MessageProducer jmsProducer = jmsSession.createProducer((Destination)this.topic);
                ObjectMessage jmsMessage = jmsSession.createObjectMessage((Serializable)body);
                for (Map.Entry<String, String> hh : params.entrySet()) {
                    jmsMessage.setStringProperty(hh.getKey(), hh.getValue());
                }
                jmsProducer.send((Message)jmsMessage);
                log.debug("Data message dispatched on JMS topic %s", this.topicName);
            }
            catch (JMSException e) {
                log.error("Could not dispatch data update on topic %s, message %s", this.topicName, body.toString());
            }
        }
    }
}

