/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.security.SecurityServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorMessage
extends AcknowledgeMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger("org.granite.logging.ExceptionStackTrace");
    private String faultCode = "Server.Call.Failed";
    private String faultDetail;
    private String faultString;
    private Object rootCause;
    private Map<String, Object> extendedData;
    private transient boolean loginError = false;

    public ErrorMessage() {
    }

    public ErrorMessage(Throwable t) {
        this.init(t);
    }

    public ErrorMessage(Message request) {
        this(request, false);
    }

    public ErrorMessage(Message request, Throwable t) {
        this(request, t, false);
    }

    public ErrorMessage(Message request, boolean keepClientId) {
        super(request, keepClientId);
    }

    public ErrorMessage(Message request, Throwable t, boolean keepClientId) {
        super(request, keepClientId);
        if (request instanceof CommandMessage) {
            this.loginError = ((CommandMessage)request).isLoginOperation() && t instanceof SecurityServiceException;
        }
        this.init(t);
    }

    private void init(Throwable t) {
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            this.faultCode = se.getCode();
            this.faultString = se.getMessage();
            this.faultDetail = t instanceof SecurityServiceException ? se.getDetail() : String.valueOf(se.getDetail()) + this.getStackTrace(t);
            this.extendedData = se.getExtendedData();
        } else if (t != null) {
            this.faultString = t.getMessage();
            this.faultDetail = t.getMessage();
        }
        if (!(t instanceof SecurityServiceException)) {
            Throwable root = t;
            while (root != null) {
                this.rootCause = root;
                root = root.getCause();
            }
        }
        if (this.rootCause != null && !log.isDebugEnabled()) {
            this.rootCause = ((Throwable)this.rootCause).getMessage();
        }
    }

    private String getStackTrace(Throwable t) {
        if (!log.isDebugEnabled()) {
            return "";
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString().replace("\r\n", "\n").replace('\r', '\n');
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultDetail() {
        return this.faultDetail;
    }

    public void setFaultDetail(String faultDetail) {
        this.faultDetail = faultDetail;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultString(String faultString) {
        this.faultString = faultString;
    }

    public Map<String, Object> getExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(Map<String, Object> extendedData) {
        this.extendedData = extendedData;
    }

    public Object getRootCause() {
        return this.rootCause;
    }

    public void setRootCause(Object rootCause) {
        this.rootCause = rootCause;
    }

    public boolean loginError() {
        return this.loginError;
    }

    public ErrorMessage copy(Message request) {
        ErrorMessage copy = new ErrorMessage(request, null);
        copy.faultCode = this.faultCode;
        copy.faultDetail = this.faultDetail;
        copy.faultString = this.faultString;
        copy.loginError = this.loginError;
        copy.rootCause = this.rootCause;
        copy.extendedData = new HashMap<String, Object>(this.extendedData);
        return copy;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getClass().getName()).append(" {");
        sb.append('\n').append(indent).append("  faultCode = ").append(this.faultCode);
        sb.append('\n').append(indent).append("  faultDetail = ").append(this.faultDetail);
        sb.append('\n').append(indent).append("  faultString = ").append(this.faultString);
        sb.append('\n').append(indent).append("  rootCause = ").append(this.rootCause);
        sb.append('\n').append(indent).append("  extendedData = ").append(this.extendedData);
        super.toString(sb, indent, null);
        sb.append('\n').append(indent).append('}');
        return sb.toString();
    }
}

