/*
 * Decompiled with CFR 0.152.
 */
package org.granite.clustering;

import flex.messaging.messages.CommandMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.granite.clustering.GraniteDistributedData;
import org.granite.context.GraniteContext;
import org.granite.messaging.webapp.HttpGraniteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionGraniteDistributedData
implements GraniteDistributedData {
    private static final String KEY_PREFIX = "__GDD__";
    private static final String CREDENTIALS_KEY = "__GDD__CREDENTIALS";
    private static final String CREDENTIALS_CHARSET_KEY = "__GDD__CREDENTIALS_CHARSET";
    private static final String CHANNELID_KEY_PREFIX = "__GDD__CHANNELID.";
    private static final String SUBSCRIPTION_KEY_PREFIX = "__GDD__SUBSCRIPTION.";
    private static final String DESTINATION_CLIENTID_KEY_PREFIX = "org.granite.gravity.channel.clientId.";
    private static final String DESTINATION_SUBSCRIPTIONID_KEY_PREFIX = "org.granite.gravity.channel.subscriptionId.";
    private static final String DESTINATION_SELECTOR_KEY_PREFIX = "__GDD__org.granite.gravity.selector.";
    private final HttpSession session;

    private static HttpSession getSession() {
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context instanceof HttpGraniteContext) {
            return ((HttpGraniteContext)context).getSession(false);
        }
        return null;
    }

    public SessionGraniteDistributedData() {
        this(SessionGraniteDistributedData.getSession());
    }

    public SessionGraniteDistributedData(HttpSession session) {
        if (session == null) {
            throw new NullPointerException("HTTP session cannot be null");
        }
        this.session = session;
    }

    @Override
    public Object getCredentials() {
        return this.session.getAttribute(CREDENTIALS_KEY);
    }

    @Override
    public boolean hasCredentials() {
        return this.getCredentials() != null;
    }

    @Override
    public void setCredentials(Object credentials) {
        if (credentials != null) {
            this.session.setAttribute(CREDENTIALS_KEY, credentials);
        } else {
            this.removeCredentials();
        }
    }

    @Override
    public void removeCredentials() {
        this.session.removeAttribute(CREDENTIALS_KEY);
    }

    @Override
    public String getCredentialsCharset() {
        return (String)this.session.getAttribute(CREDENTIALS_CHARSET_KEY);
    }

    @Override
    public boolean hasCredentialsCharset() {
        return this.getCredentialsCharset() != null;
    }

    @Override
    public void setCredentialsCharset(String credentialsCharset) {
        if (credentialsCharset != null) {
            this.session.setAttribute(CREDENTIALS_CHARSET_KEY, (Object)credentialsCharset);
        } else {
            this.removeCredentialsCharset();
        }
    }

    @Override
    public void removeCredentialsCharset() {
        this.session.removeAttribute(CREDENTIALS_CHARSET_KEY);
    }

    @Override
    public void addChannelId(String channelId) {
        if (channelId == null) {
            throw new NullPointerException("channelId cannot be null");
        }
        this.session.setAttribute(CHANNELID_KEY_PREFIX + channelId, (Object)Boolean.TRUE);
    }

    @Override
    public boolean hasChannelId(String channelId) {
        if (channelId == null) {
            return false;
        }
        return this.session.getAttribute(CHANNELID_KEY_PREFIX + channelId) != null;
    }

    @Override
    public void removeChannelId(String channelId) {
        if (channelId == null) {
            return;
        }
        this.session.removeAttribute(CHANNELID_KEY_PREFIX + channelId);
        this.clearSubscriptions(channelId);
    }

    @Override
    public Set<String> getChannelIds() {
        HashSet<String> channelIds = new HashSet<String>();
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(CHANNELID_KEY_PREFIX)) continue;
            channelIds.add(key.substring(CHANNELID_KEY_PREFIX.length()));
        }
        return channelIds;
    }

    @Override
    public void clearChannelIds() {
        Set<String> channelIds = this.getChannelIds();
        for (String channelId : channelIds) {
            this.removeChannelId(channelId);
        }
    }

    @Override
    public void addSubcription(String channelId, CommandMessage message) {
        if (channelId == null || message == null) {
            throw new IllegalArgumentException("channelId and message cannot be null");
        }
        if (!this.hasChannelId(channelId)) {
            throw new IllegalArgumentException("Unknown channelId: " + channelId);
        }
        if (channelId.indexOf(46) != -1) {
            throw new IllegalArgumentException("Invalid channelId (should not contain '.' characters): " + channelId);
        }
        String subscriptionId = (String)message.getHeader("DSDstClientId");
        if (subscriptionId == null) {
            throw new IllegalArgumentException("Subscription id cannot be null: " + message);
        }
        this.session.setAttribute(SUBSCRIPTION_KEY_PREFIX + channelId + '.' + subscriptionId, (Object)message);
    }

    @Override
    public boolean hasSubcription(String channelId, String subscriptionId) {
        if (channelId == null || subscriptionId == null) {
            return false;
        }
        return this.session.getAttribute(SUBSCRIPTION_KEY_PREFIX + channelId + '.' + subscriptionId) != null;
    }

    @Override
    public void removeSubcription(String channelId, String subscriptionId) {
        if (channelId == null || subscriptionId == null) {
            return;
        }
        this.session.removeAttribute(SUBSCRIPTION_KEY_PREFIX + channelId + '.' + subscriptionId);
    }

    @Override
    public List<CommandMessage> getSubscriptions(String channelId) {
        if (channelId == null) {
            return Collections.emptyList();
        }
        String channelSubscriptionKeyPrefix = SUBSCRIPTION_KEY_PREFIX + channelId + '.';
        ArrayList<CommandMessage> subscriptions = new ArrayList<CommandMessage>();
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(channelSubscriptionKeyPrefix)) continue;
            CommandMessage subscription = (CommandMessage)this.session.getAttribute(key);
            subscriptions.add(subscription);
        }
        return subscriptions;
    }

    @Override
    public void clearSubscriptions(String channelId) {
        if (channelId == null) {
            return;
        }
        String channelSubscriptionKeyPrefix = SUBSCRIPTION_KEY_PREFIX + channelId + '.';
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(channelSubscriptionKeyPrefix)) continue;
            this.session.removeAttribute(key);
        }
    }

    @Override
    public String getDestinationClientId(String destination) {
        return (String)this.session.getAttribute(DESTINATION_CLIENTID_KEY_PREFIX + destination);
    }

    @Override
    public void setDestinationClientId(String destination, String clientId) {
        this.session.setAttribute(DESTINATION_CLIENTID_KEY_PREFIX + destination, (Object)clientId);
    }

    @Override
    public String getDestinationSubscriptionId(String destination) {
        return (String)this.session.getAttribute(DESTINATION_SUBSCRIPTIONID_KEY_PREFIX + destination);
    }

    @Override
    public void setDestinationSubscriptionId(String destination, String subscriptionId) {
        this.session.setAttribute(DESTINATION_SUBSCRIPTIONID_KEY_PREFIX + destination, (Object)subscriptionId);
    }

    @Override
    public String getDestinationSelector(String destination) {
        return (String)this.session.getAttribute(DESTINATION_SELECTOR_KEY_PREFIX + destination);
    }

    @Override
    public void setDestinationSelector(String destination, String selector) {
        this.session.setAttribute(DESTINATION_SELECTOR_KEY_PREFIX + destination, (Object)selector);
    }
}

