/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.granite.config.AbstractFrameworkGraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRemoteDestination {
    private static final Logger log = Logger.getLogger(AbstractRemoteDestination.class);
    private String id = null;
    private String source = null;
    private List<String> roles = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    protected void init(AbstractFrameworkGraniteConfig graniteConfig) {
        ServicesConfig servicesConfig = graniteConfig.getServicesConfig();
        this.initServices(servicesConfig);
    }

    public void initServices(ServicesConfig servicesConfig) {
        Channel channel = servicesConfig.findChannelById("graniteamf");
        if (channel == null) {
            channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
            servicesConfig.addChannel(channel);
        }
        List<Service> services = servicesConfig.findServicesByMessageType("flex.messaging.messages.RemotingMessage");
        Service service = null;
        if (services == null || services.isEmpty()) {
            service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
            servicesConfig.addService(service);
        } else {
            service = services.get(0);
        }
        service.getDestinations().put(this.source, this.buildDestination());
        log.info("Registered remote destination %s", this.source);
    }

    protected Destination buildDestination() {
        ArrayList<String> channelIds = new ArrayList<String>();
        channelIds.add("graniteamf");
        Destination destination = new Destination(this.source, channelIds, new XMap(), this.roles, null, null);
        return destination;
    }
}

