/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.granite.config.ConfigProvider;
import org.granite.config.GraniteConfig;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.ShutdownListener;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.config.servlet3.FlexFilter;
import org.granite.jmx.GraniteMBeanInitializer;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.externalizer.BigDecimalExternalizer;
import org.granite.messaging.amf.io.util.externalizer.BigIntegerExternalizer;
import org.granite.messaging.amf.io.util.externalizer.LongExternalizer;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.SimpleServiceFactory;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;
import org.granite.util.ClassUtil;
import org.granite.util.ServletParams;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraniteConfigListener
implements ServletContextListener {
    private static final String GRANITE_CONFIG_SHUTDOWN_KEY = String.valueOf(GraniteConfig.class.getName()) + "_SHUTDOWN";
    public static final String GRANITE_CONFIG_ATTRIBUTE = "org.granite.config.flexFilter";
    public static final String GRANITE_MBEANS_ATTRIBUTE = "registerGraniteMBeans";
    private static final Logger log = Logger.getLogger(GraniteConfigListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext context = sce.getServletContext();
            log.info("Initializing GraniteDS...", new Object[0]);
            Class flexFilterClass = (Class)context.getAttribute(GRANITE_CONFIG_ATTRIBUTE);
            if (flexFilterClass != null) {
                context.setAttribute(ServletGraniteConfig.GRANITE_CONFIG_DEFAULT_KEY, (Object)"org/granite/config/servlet3/granite-config-servlet3.xml");
            }
            GraniteConfig gConfig = ServletGraniteConfig.loadConfig(context);
            ServletServicesConfig.loadConfig(context);
            if (flexFilterClass != null) {
                this.configureServices(context, flexFilterClass);
            }
            if (gConfig.isRegisterMBeans()) {
                GraniteMBeanInitializer.registerMBeans(context, ServletGraniteConfig.getServletConfig(context), ServletServicesConfig.getServletConfig(context));
            }
            log.info("GraniteDS initialized", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize Granite environment", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        log.info("Stopping GraniteDS...", new Object[0]);
        List listeners = (List)sce.getServletContext().getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners != null) {
            try {
                for (ShutdownListener listener : listeners) {
                    listener.stop();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not destroy Granite environment", e);
            }
        }
        if (ServletParams.get(context, GRANITE_MBEANS_ATTRIBUTE, Boolean.TYPE, Boolean.valueOf(false)).booleanValue()) {
            GraniteMBeanInitializer.unregisterMBeans(context);
        }
        log.info("GraniteDS stopped", new Object[0]);
    }

    public static synchronized void registerShutdownListener(ServletContext context, ShutdownListener listener) {
        ArrayList<ShutdownListener> listeners = (ArrayList<ShutdownListener>)context.getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners == null) {
            listeners = new ArrayList<ShutdownListener>();
            context.setAttribute(GRANITE_CONFIG_SHUTDOWN_KEY, listeners);
        }
        listeners.add(listener);
    }

    /*
     * WARNING - void declaration
     */
    private void configureServices(ServletContext context, Class<?> flexFilterClass) throws ServletException {
        Service service;
        Factory factory;
        GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(context);
        ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(context);
        FlexFilter flexFilter = flexFilterClass.getAnnotation(FlexFilter.class);
        ConfigProvider configProvider = null;
        boolean useTide = flexFilter.tide();
        String type = flexFilter.type();
        Class<? extends ServiceFactory> factoryClass = null;
        HashSet tideInterfaces = new HashSet(Arrays.asList(flexFilter.tideInterfaces()));
        HashSet<Class<? extends Annotation>> tideAnnotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(flexFilter.tideAnnotations()));
        if (!flexFilter.configProviderClass().equals(ConfigProvider.class)) {
            try {
                configProvider = ClassUtil.newInstance(flexFilter.configProviderClass(), new Class[]{ServletContext.class}, new Object[]{context});
                if (configProvider.useTide() != null) {
                    useTide = configProvider.useTide();
                }
                if (configProvider.getType() != null) {
                    type = configProvider.getType();
                }
                factoryClass = configProvider.getFactoryClass();
                if (configProvider.getTideInterfaces() != null) {
                    tideInterfaces.addAll(Arrays.asList(configProvider.getTideInterfaces()));
                }
                if (configProvider.getTideAnnotations() != null) {
                    tideAnnotations.addAll(Arrays.asList(configProvider.getTideAnnotations()));
                }
            }
            catch (Exception exception) {
                log.error(exception, "Could not set config provider of type %s", flexFilter.configProviderClass().getName());
            }
        }
        if (!flexFilter.factoryClass().equals(ServiceFactory.class)) {
            factoryClass = flexFilter.factoryClass();
        }
        if (factoryClass == null) {
            factoryClass = SimpleServiceFactory.class;
            useTide = false;
        }
        for (Class clazz : tideInterfaces) {
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentInstanceOfMatcher(clazz.getName(), false));
                log.debug("Enabled components implementing %s for Tide remoting", clazz);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component interface %s", clazz);
            }
        }
        for (Class clazz : tideAnnotations) {
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(clazz.getName(), false));
                log.debug("Enabled components annotated with %s for Tide remoting", clazz);
            }
            catch (Exception e) {
                log.error(e, "Could not add tide-component annotation %s", clazz);
            }
        }
        Object[] objectArray = flexFilter.tideNames();
        int e = objectArray.length;
        int n = 0;
        while (n < e) {
            String string = objectArray[n];
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentNameMatcher(string, false));
                log.debug("Enabled components with name %s for Tide remoting", string);
            }
            catch (Exception e2) {
                log.error(e2, "Could not add tide-component name %s", string);
            }
            ++n;
        }
        objectArray = flexFilter.tideTypes();
        e = objectArray.length;
        n = 0;
        while (n < e) {
            String string = objectArray[n];
            try {
                graniteConfig.getTideComponentMatchers().add(new TideComponentTypeMatcher(string, false));
                log.debug("Enabled components with type %s for Tide remoting", string);
            }
            catch (Exception e3) {
                log.error(e3, "Could not add tide-component type %s", string);
            }
            ++n;
        }
        objectArray = flexFilter.exceptionConverters();
        e = objectArray.length;
        n = 0;
        while (n < e) {
            Object object = objectArray[n];
            graniteConfig.registerExceptionConverter((Class<? extends ExceptionConverter>)object, true);
            log.debug("Registered exception converter %s", object);
            ++n;
        }
        if (configProvider != null) {
            for (ExceptionConverter exceptionConverter : configProvider.findInstances(ExceptionConverter.class)) {
                graniteConfig.registerExceptionConverter(exceptionConverter, true);
                log.debug("Registered exception converter %s", exceptionConverter.getClass());
            }
        }
        if (flexFilter.useBigDecimal()) {
            graniteConfig.setExternalizersByType(BigDecimal.class.getName(), BigDecimalExternalizer.class.getName());
        }
        if (flexFilter.useBigInteger()) {
            graniteConfig.setExternalizersByType(BigInteger.class.getName(), BigIntegerExternalizer.class.getName());
        }
        if (flexFilter.useLong()) {
            graniteConfig.setExternalizersByType(Long.class.getName(), LongExternalizer.class.getName());
        }
        if (!flexFilter.securityServiceClass().equals(SecurityService.class)) {
            try {
                graniteConfig.setSecurityService(ClassUtil.newInstance(flexFilter.securityServiceClass(), SecurityService.class));
            }
            catch (Exception exception) {
                throw new ServletException("Could not setup security service", (Throwable)exception);
            }
        } else if (graniteConfig.getSecurityService() == null && configProvider != null) {
            SecurityService securityService = configProvider.findInstance(SecurityService.class);
            graniteConfig.setSecurityService(securityService);
        }
        if (graniteConfig.getSecurityService() == null) {
            Object var12_28 = null;
            try {
                ClassUtil.forName("org.mortbay.jetty.Request");
                String string = "org.granite.messaging.service.security.Jetty6SecurityService";
            }
            catch (ClassNotFoundException e1) {
                try {
                    ClassUtil.forName("org.eclipse.jetty.server.Request");
                    String string = "org.granite.messaging.service.security.Jetty7SecurityService";
                }
                catch (ClassNotFoundException e1b) {
                    void var12_34;
                    try {
                        ClassUtil.forName("weblogic.servlet.security.ServletAuthentication");
                        String string = "org.granite.messaging.service.security.WebLogicSecurityService";
                    }
                    catch (ClassNotFoundException e2) {
                        try {
                            ClassUtil.forName("com.sun.appserv.server.LifecycleEvent");
                            String string = "org.granite.messaging.service.security.GlassFishV3SecurityService";
                        }
                        catch (ClassNotFoundException e3) {
                            String string = "org.granite.messaging.service.security.Tomcat7SecurityService";
                        }
                    }
                    try {
                        graniteConfig.setSecurityService((SecurityService)ClassUtil.newInstance((String)var12_34));
                    }
                    catch (Exception e5) {
                        throw new ServletException("Could not setup security service " + (String)var12_34, (Throwable)e5);
                    }
                }
            }
        }
        if (!flexFilter.amf3MessageInterceptor().equals(AMF3MessageInterceptor.class)) {
            try {
                graniteConfig.setAmf3MessageInterceptor(ClassUtil.newInstance(flexFilter.amf3MessageInterceptor(), AMF3MessageInterceptor.class));
            }
            catch (Exception exception) {
                throw new ServletException("Could not setup amf3 message interceptor", (Throwable)exception);
            }
        } else if (graniteConfig.getAmf3MessageInterceptor() == null && configProvider != null) {
            AMF3MessageInterceptor aMF3MessageInterceptor = configProvider.findInstance(AMF3MessageInterceptor.class);
            graniteConfig.setAmf3MessageInterceptor(aMF3MessageInterceptor);
        }
        Channel channel = servicesConfig.findChannelById("graniteamf");
        if (channel == null) {
            Channel channel2 = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
            servicesConfig.addChannel(channel2);
        }
        XMap factoryProperties = new XMap();
        String lookup = null;
        if (useTide) {
            lookup = "java:global/{context.root}/{capitalized.component.name}Bean";
            if (GraniteConfigListener.isJBoss6()) {
                lookup = "{capitalized.component.name}Bean/local";
            }
            if (!"".equals(flexFilter.ejbLookup())) {
                lookup = flexFilter.ejbLookup();
            }
        } else {
            lookup = "java:global/{context.root}/{capitalized.destination.id}Bean";
            if (GraniteConfigListener.isJBoss6()) {
                lookup = "{capitalized.destination.id}Bean/local";
            }
            if (!"".equals(flexFilter.ejbLookup())) {
                lookup = flexFilter.ejbLookup();
            }
        }
        if (lookup.indexOf("{context.root}") >= 0) {
            try {
                Method m = context.getClass().getMethod("getContextPath", new Class[0]);
                String contextPath = (String)m.invoke((Object)context, new Object[0]);
                lookup = lookup.replace("{context.root}", contextPath.substring(1));
            }
            catch (Exception e7) {
                log.error(e7, "Could not get context path, please define lookup manually in @FlexFilter", new Object[0]);
            }
        }
        factoryProperties.put("lookup", lookup);
        if (useTide) {
            factory = servicesConfig.findFactoryById("tide-" + type + "-factory");
            if (factory == null) {
                factory = new Factory("tide-" + type + "-factory", factoryClass.getName(), factoryProperties);
                servicesConfig.addFactory(factory);
            }
            if ((service = servicesConfig.findServiceById("granite-service")) == null) {
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
                ArrayList<String> channelIds = new ArrayList<String>();
                channelIds.add("graniteamf");
                List<String> tideRoles = flexFilter.tideRoles().length == 0 ? null : Arrays.asList(flexFilter.tideRoles());
                Destination destination = new Destination(type, channelIds, new XMap(), tideRoles, null, null);
                destination.getProperties().put("factory", "tide-" + type + "-factory");
                if (!"".equals(flexFilter.entityManagerFactoryJndiName())) {
                    destination.getProperties().put("entity-manager-factory-jndi-name", flexFilter.entityManagerFactoryJndiName());
                } else if (!"".equals(flexFilter.entityManagerJndiName())) {
                    destination.getProperties().put("entity-manager-jndi-name", flexFilter.entityManagerJndiName());
                }
                if (!"".equals(flexFilter.validatorClassName())) {
                    destination.getProperties().put("validator-class-name", flexFilter.validatorClassName());
                }
                service.getDestinations().put(type, destination);
                servicesConfig.addService(service);
            }
            if (factoryClass.getName().equals("org.granite.tide.ejb.EjbServiceFactory")) {
                servicesConfig.scan(null);
            }
            log.info("Registered Tide " + factoryClass + " service factory and " + type + " destination", new Object[0]);
        } else {
            factory = new Factory(String.valueOf(type) + "-factory", factoryClass.getName(), factoryProperties);
            servicesConfig.addFactory(factory);
            service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
            servicesConfig.addService(service);
            servicesConfig.scan(null);
            log.info("Registered " + factoryClass + " service factory", new Object[0]);
        }
    }

    private static boolean isJBoss6() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/org/jboss/version.properties");
            if (is != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

