/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import flex.messaging.messages.RemotingMessage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.config.api.Configuration;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.logging.Logger;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.scan.ScannerFactory;
import org.granite.util.ClassUtil;
import org.granite.util.XMap;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesConfig
implements ScannedItemHandler {
    private static final Logger log = Logger.getLogger(ServicesConfig.class);
    private static final String SERVICES_CONFIG_PROPERTIES = "META-INF/services-config.properties";
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Map<String, Factory> factories = new HashMap<String, Factory>();

    private void scanConfig(String serviceConfigProperties, List<ScannedItemHandler> handlers) {
        Scanner scanner = ScannerFactory.createScanner(this, serviceConfigProperties != null ? serviceConfigProperties : SERVICES_CONFIG_PROPERTIES);
        scanner.addHandlers(handlers);
        try {
            scanner.scan();
        }
        catch (Exception e) {
            log.error(e, "Could not scan classpath for configuration", new Object[0]);
        }
    }

    @Override
    public boolean handleMarkerItem(ScannedItem item) {
        return false;
    }

    @Override
    public void handleScannedItem(ScannedItem item) {
        if ("class".equals(item.getExtension()) && item.getName().indexOf(36) == -1) {
            try {
                this.handleClass(item.loadAsClass());
            }
            catch (Throwable t) {
                log.error(t, "Could not load class: %s", item);
            }
        }
    }

    public void handleClass(Class<?> clazz) {
        RemoteDestination anno = clazz.getAnnotation(RemoteDestination.class);
        if (anno != null && !"".equals(anno.id())) {
            XMap props = new XMap("properties");
            Service service = null;
            if (anno.service().length() > 0) {
                log.info("Configuring service from RemoteDestination annotation: service=%s (class=%s, anno=%s)", anno.service(), clazz, anno);
                service = this.services.get(anno.service());
            } else if (this.services.size() > 0) {
                log.info("Looking for service(s) with RemotingMessage type (class=%s, anno=%s)", clazz, anno);
                int count = 0;
                for (Service s : this.services.values()) {
                    if (!RemotingMessage.class.getName().equals(s.getMessageTypes())) continue;
                    log.info("Found service with RemotingMessage type: service=%s (class=%s, anno=%s)", s, clazz, anno);
                    service = s;
                    ++count;
                }
                if (count == 1 && service != null) {
                    log.info("Service " + service.getId() + " selected for destination in class: " + clazz.getName(), new Object[0]);
                } else {
                    log.error("Found %d matching services (should be exactly 1, class=%s, anno=%s)", count, clazz, anno);
                    service = null;
                }
            }
            if (service == null) {
                throw new RuntimeException("No service found for destination in class: " + clazz.getName());
            }
            List<String> channelIds = null;
            if (anno.channels().length > 0) {
                channelIds = Arrays.asList(anno.channels());
            } else if (anno.channel().length() > 0) {
                channelIds = Collections.singletonList(anno.channel());
            } else if (this.channels.size() == 1) {
                channelIds = new ArrayList<String>(this.channels.keySet());
                log.info("Channel " + channelIds.get(0) + " selected for destination in class: " + clazz.getName(), new Object[0]);
            } else {
                log.warn("No (or ambiguous) channel definition found for destination in class: " + clazz.getName(), new Object[0]);
                channelIds = Collections.emptyList();
            }
            String factoryId = null;
            if (anno.factory().length() > 0) {
                factoryId = anno.factory();
            } else if (this.factories.isEmpty()) {
                props.put("scope", anno.scope());
                props.put("source", clazz.getName());
                log.info("Default POJO factory selected for destination in class: " + clazz.getName() + " with scope: " + anno.scope(), new Object[0]);
            } else if (this.factories.size() == 1) {
                factoryId = this.factories.keySet().iterator().next();
                log.info("Factory " + factoryId + " selected for destination in class: " + clazz.getName(), new Object[0]);
            } else {
                throw new RuntimeException("No (or ambiguous) factory definition found for destination in class: " + clazz.getName());
            }
            if (factoryId != null) {
                props.put("factory", factoryId);
            }
            if (!anno.source().equals("")) {
                props.put("source", anno.source());
            }
            ArrayList<String> roles = null;
            if (anno.securityRoles().length > 0) {
                roles = new ArrayList<String>(anno.securityRoles().length);
                String[] stringArray = anno.securityRoles();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String role = stringArray[n2];
                    roles.add(role);
                    ++n2;
                }
            }
            Destination destination = new Destination(anno.id(), channelIds, props, roles, null, clazz);
            service.getDestinations().put(destination.getId(), destination);
        }
    }

    public ServicesConfig(InputStream customConfigIs, Configuration configuration, boolean scan) throws IOException, SAXException {
        if (customConfigIs != null) {
            this.loadConfig(customConfigIs);
        }
        if (scan) {
            this.scan(configuration);
        }
    }

    public void scan(Configuration configuration) {
        ArrayList<ScannedItemHandler> handlers = new ArrayList<ScannedItemHandler>();
        for (Factory factory : this.factories.values()) {
            try {
                Class<?> clazz = ClassUtil.forName(factory.getClassName());
                Method method = clazz.getMethod("getScannedItemHandler", new Class[0]);
                if ((8 & method.getModifiers()) != 0 && method.getParameterTypes().length == 0) {
                    ScannedItemHandler handler = (ScannedItemHandler)method.invoke(null, new Object[0]);
                    handlers.add(handler);
                    continue;
                }
                log.warn("Factory class %s contains an unexpected signature for method: %s", factory.getClassName(), method);
            }
            catch (NoSuchMethodException clazz) {
            }
            catch (ClassNotFoundException e) {
                log.error(e, "Could not load factory class: %s", factory.getClassName());
            }
            catch (Exception e) {
                log.error(e, "Error while calling %s.getScannedItemHandler() method", factory.getClassName());
            }
        }
        this.scanConfig(configuration != null ? configuration.getFlexServicesConfigProperties() : null, handlers);
    }

    private void loadConfig(InputStream configIs) throws IOException, SAXException {
        XMap doc = new XMap(configIs);
        this.forElement(doc);
    }

    public Service findServiceById(String id) {
        return this.services.get(id);
    }

    public List<Service> findServicesByMessageType(String messageType) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service service : this.services.values()) {
            if (!messageType.equals(service.getMessageTypes())) continue;
            services.add(service);
        }
        return services;
    }

    public void addService(Service service) {
        this.services.put(service.getId(), service);
    }

    public Channel findChannelById(String id) {
        return this.channels.get(id);
    }

    public void addChannel(Channel channel) {
        this.channels.put(channel.getId(), channel);
    }

    public Factory findFactoryById(String id) {
        return this.factories.get(id);
    }

    public void addFactory(Factory factory) {
        this.factories.put(factory.getId(), factory);
    }

    public Destination findDestinationById(String messageType, String id) {
        for (Service service : this.services.values()) {
            Destination destination;
            if (messageType != null && !messageType.equals(service.getMessageTypes()) || (destination = service.findDestinationById(id)) == null) continue;
            return destination;
        }
        return null;
    }

    public List<Destination> findDestinationsByMessageType(String messageType) {
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        for (Service service : this.services.values()) {
            if (!messageType.equals(service.getMessageTypes())) continue;
            destinations.addAll(service.getDestinations().values());
        }
        return destinations;
    }

    private void forElement(XMap element) {
        XMap channels;
        XMap services = element.getOne("services");
        if (services != null) {
            for (XMap service : services.getAll("service")) {
                Service serv = Service.forElement(service);
                this.services.put(serv.getId(), serv);
            }
        }
        if ((channels = element.getOne("channels")) != null) {
            for (XMap channel : channels.getAll("channel-definition")) {
                Channel chan = Channel.forElement(channel);
                this.channels.put(chan.getId(), chan);
            }
        } else {
            log.info("No channel definition found, using defaults", new Object[0]);
            EndPoint defaultEndpoint = new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint");
            Channel defaultChannel = new Channel("my-graniteamf", "mx.messaging.channels.AMFChannel", defaultEndpoint, XMap.EMPTY_XMAP);
            this.channels.put(defaultChannel.getId(), defaultChannel);
        }
        XMap factories = element.getOne("factories");
        if (factories != null) {
            for (XMap factory : factories.getAll("factory")) {
                Factory fact = Factory.forElement(factory);
                this.factories.put(fact.getId(), fact);
            }
        }
    }

    public void handleRemoveService(Class<?> clazz) {
        RemoteDestination anno = clazz.getAnnotation(RemoteDestination.class);
        if (anno != null) {
            Service service = null;
            if (anno.service().length() > 0) {
                service = this.services.get(anno.service());
            } else if (this.services.size() > 0) {
                for (Service s : this.services.values()) {
                    if (!RemotingMessage.class.getName().equals(s.getMessageTypes())) continue;
                    service = s;
                    log.info("Service " + service.getId() + " selected for destination in class: " + clazz.getName(), new Object[0]);
                    break;
                }
            }
            if (service != null) {
                Destination dest = service.getDestinations().remove(anno.id());
                if (dest != null) {
                    dest.remove();
                    log.info("RemoteDestination:" + dest.getId() + " has been removed", new Object[0]);
                }
            } else {
                log.info("Service NOT Found!!", new Object[0]);
            }
        }
    }
}

