/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF3Constants;
import org.granite.messaging.amf.io.AMF3DeserializerSecurizer;
import org.granite.messaging.amf.io.AMF3SerializationException;
import org.granite.messaging.amf.io.util.ActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.DefaultActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.instantiator.AbstractInstantiator;
import org.granite.util.ClassUtil;
import org.granite.util.XMLUtil;
import org.w3c.dom.Document;

public class AMF3Deserializer
extends DataInputStream
implements ObjectInput,
AMF3Constants {
    protected static final Logger log = Logger.getLogger(AMF3Deserializer.class);
    protected static final Logger logMore = Logger.getLogger(String.valueOf(AMF3Deserializer.class.getName()) + "_MORE");
    protected final List<String> storedStrings = new ArrayList<String>();
    protected final List<Object> storedObjects = new ArrayList<Object>();
    protected final List<ActionScriptClassDescriptor> storedClassDescriptors = new ArrayList<ActionScriptClassDescriptor>();
    protected final GraniteContext context = GraniteContext.getCurrentInstance();
    protected final AMF3DeserializerSecurizer securizer = this.context.getGraniteConfig().getAmf3DeserializerSecurizer();
    protected final XMLUtil xmlUtil = new XMLUtil();
    protected final boolean debug = log.isDebugEnabled();
    protected final boolean debugMore = logMore.isDebugEnabled();

    public AMF3Deserializer(InputStream in) {
        super(in);
        if (this.debugMore) {
            logMore.debug("new AMF3Deserializer(in=%s)", in);
        }
    }

    public Object readObject() throws IOException {
        if (this.debugMore) {
            logMore.debug("readObject()...", new Object[0]);
        }
        try {
            int type = this.readAMF3Integer();
            return this.readObject(type);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AMF3SerializationException(e);
        }
    }

    protected Object readObject(int type) throws IOException {
        if (this.debugMore) {
            logMore.debug("readObject(type=0x%02X)", type);
        }
        switch (type) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 3: {
                return Boolean.TRUE;
            }
            case 4: {
                return this.readAMF3Integer();
            }
            case 5: {
                return this.readAMF3Double();
            }
            case 6: {
                return this.readAMF3String();
            }
            case 7: {
                return this.readAMF3Xml();
            }
            case 8: {
                return this.readAMF3Date();
            }
            case 9: {
                return this.readAMF3Array();
            }
            case 10: {
                return this.readAMF3Object();
            }
            case 11: {
                return this.readAMF3XmlString();
            }
            case 12: {
                return this.readAMF3ByteArray();
            }
            case 13: {
                return this.readAMF3VectorInt();
            }
            case 14: {
                return this.readAMF3VectorUInt();
            }
            case 15: {
                return this.readAMF3VectorNumber();
            }
            case 16: {
                return this.readAMF3VectorObject();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected int readAMF3Integer() throws IOException {
        int result = 0;
        int n = 0;
        int b = this.readUnsignedByte();
        while ((b & 0x80) != 0 && n < 3) {
            result <<= 7;
            result |= b & 0x7F;
            b = this.readUnsignedByte();
            ++n;
        }
        if (n < 3) {
            result <<= 7;
            result |= b;
        } else {
            result <<= 8;
            if (((result |= b) & 0x10000000) != 0) {
                result |= 0xE0000000;
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3Integer() -> %d", result);
        }
        return result;
    }

    protected Double readAMF3Double() throws IOException {
        Double result;
        double d = this.readDouble();
        Double d2 = result = Double.isNaN(d) ? null : Double.valueOf(d);
        if (this.debugMore) {
            logMore.debug("readAMF3Double() -> %f", result);
        }
        return result;
    }

    protected String readAMF3String() throws IOException {
        int type;
        String result = null;
        if (this.debugMore) {
            logMore.debug("readAMF3String()...", new Object[0]);
        }
        if (((type = this.readAMF3Integer()) & 1) == 0) {
            result = this.getFromStoredStrings(type >> 1);
        } else {
            int length = type >> 1;
            if (this.debugMore) {
                logMore.debug("readAMF3String() - length=%d", length);
            }
            if (length > 0) {
                byte[] utfBytes = new byte[length];
                char[] utfChars = new char[length];
                this.readFully(utfBytes);
                int iBytes = 0;
                int iChars = 0;
                while (iBytes < length) {
                    int c;
                    if ((c = utfBytes[iBytes++] & 0xFF) <= 127) {
                        utfChars[iChars++] = (char)c;
                        continue;
                    }
                    switch (c >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = utfBytes[iBytes++];
                            if ((c2 & 0xC0) != 128) {
                                throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 2));
                            }
                            utfChars[iChars++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            break;
                        }
                        case 14: {
                            byte c2 = utfBytes[iBytes++];
                            byte c3 = utfBytes[iBytes++];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 3));
                            }
                            utfChars[iChars++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            break;
                        }
                        default: {
                            throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 1));
                        }
                    }
                }
                result = new String(utfChars, 0, iChars);
                if (this.debugMore) {
                    logMore.debug("readAMF3String() - result=%s", result);
                }
                this.addToStoredStrings(result);
            } else {
                result = "";
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3String() -> %s", result);
        }
        return result;
    }

    protected Date readAMF3Date() throws IOException {
        Date result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = (Date)this.getFromStoredObjects(type >> 1);
        } else {
            result = new Date((long)this.readDouble());
            this.addToStoredObjects(result);
        }
        if (this.debugMore) {
            logMore.debug("readAMF3Date() -> %s", result);
        }
        return result;
    }

    protected Object readAMF3Array() throws IOException {
        Object result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int size = type >> 1;
            String key = this.readAMF3String();
            if (key.length() == 0) {
                Object[] objects = new Object[size];
                this.addToStoredObjects(objects);
                int i = 0;
                while (i < size) {
                    objects[i] = this.readObject();
                    ++i;
                }
                result = objects;
            } else {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                this.addToStoredObjects(map);
                while (key.length() > 0) {
                    map.put(key, this.readObject());
                    key = this.readAMF3String();
                }
                int i = 0;
                while (i < size) {
                    map.put(i, this.readObject());
                    ++i;
                }
                result = map;
            }
        }
        if (this.debugMore) {
            logMore.debug("readAMF3Array() -> %s", result);
        }
        return result;
    }

    protected Object readAMF3VectorInt() throws IOException {
        ArrayList<Integer> result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            ArrayList<Integer> vector = new ArrayList<Integer>(length);
            this.addToStoredObjects(result);
            this.readAMF3Integer();
            int i = 0;
            while (i < length) {
                vector.add(this.readInt());
                ++i;
            }
            result = vector;
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorInt() -> %s", result);
        }
        return result;
    }

    protected Object readAMF3VectorUInt() throws IOException {
        ArrayList<Long> result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            ArrayList<Long> vector = new ArrayList<Long>(length);
            this.addToStoredObjects(result);
            this.readAMF3Integer();
            int i = 0;
            while (i < length) {
                vector.add((long)this.readInt() & 0xFFFFFFFFL);
                ++i;
            }
            result = vector;
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorUInt() -> %s", result);
        }
        return result;
    }

    protected Object readAMF3VectorNumber() throws IOException {
        ArrayList<Double> result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            ArrayList<Double> vector = new ArrayList<Double>(length);
            this.addToStoredObjects(result);
            this.readAMF3Integer();
            int i = 0;
            while (i < length) {
                vector.add(this.readDouble());
                ++i;
            }
            result = vector;
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorDouble() -> %s", result);
        }
        return result;
    }

    protected Object readAMF3VectorObject() throws IOException {
        ArrayList<Object> result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int length = type >> 1;
            ArrayList<Object> vector = new ArrayList<Object>(length);
            this.addToStoredObjects(result);
            this.readAMF3Integer();
            this.readAMF3Integer();
            int i = 0;
            while (i < length) {
                vector.add(this.readObject());
                ++i;
            }
            result = vector;
        }
        if (this.debugMore) {
            logMore.debug("readAMF3VectorObject() -> %s", result);
        }
        return result;
    }

    protected Object readAMF3Object() throws IOException {
        if (this.debug) {
            log.debug("readAMF3Object()...", new Object[0]);
        }
        Object result = null;
        int type = this.readAMF3Integer();
        if (this.debug) {
            log.debug("readAMF3Object() - type=0x%02X", type);
        }
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            boolean inlineClassDef;
            boolean bl = inlineClassDef = (type >> 1 & 1) != 0;
            if (this.debug) {
                log.debug("readAMF3Object() - inlineClassDef=%b", inlineClassDef);
            }
            ActionScriptClassDescriptor desc = null;
            if (inlineClassDef) {
                int propertiesCount = type >> 4;
                if (this.debug) {
                    log.debug("readAMF3Object() - propertiesCount=%d", propertiesCount);
                }
                byte encoding = (byte)(type >> 2 & 3);
                if (this.debug) {
                    log.debug("readAMF3Object() - encoding=%d", encoding);
                }
                String className = this.readAMF3String();
                if (this.debug) {
                    log.debug("readAMF3Object() - className=%s", className);
                }
                if (this.securizer != null && !this.securizer.allowInstantiation(className)) {
                    throw new SecurityException("Illegal attempt to instantiate class: " + className + ", securizer: " + this.securizer.getClass());
                }
                Class<? extends ActionScriptClassDescriptor> descriptorType = null;
                if (!"".equals(className)) {
                    descriptorType = this.context.getGraniteConfig().getActionScriptDescriptor(className);
                }
                if (this.debug) {
                    log.debug("readAMF3Object() - descriptorType=%s", descriptorType);
                }
                if (descriptorType != null) {
                    Class[] argsDef = new Class[]{String.class, Byte.TYPE};
                    Object[] argsVal = new Object[]{className, encoding};
                    try {
                        desc = ClassUtil.newInstance(descriptorType, argsDef, argsVal);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not instantiate AS descriptor: " + descriptorType, e);
                    }
                }
                if (desc == null) {
                    desc = new DefaultActionScriptClassDescriptor(className, encoding);
                }
                this.addToStoredClassDescriptors(desc);
                if (this.debug) {
                    log.debug("readAMF3Object() - defining %d properties...", propertiesCount);
                }
                int i = 0;
                while (i < propertiesCount) {
                    String name = this.readAMF3String();
                    if (this.debug) {
                        log.debug("readAMF3Object() - defining property name=%s", name);
                    }
                    desc.defineProperty(name);
                    ++i;
                }
            } else {
                desc = this.getFromStoredClassDescriptors(type >> 2);
            }
            if (this.debug) {
                log.debug("readAMF3Object() - actionScriptClassDescriptor=%s", desc);
            }
            byte objectEncoding = desc.getEncoding();
            Externalizer externalizer = desc.getExternalizer();
            if (externalizer != null) {
                try {
                    result = externalizer.newInstance(desc.getType(), this);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate type: " + desc.getType(), e);
                }
            } else {
                result = desc.newJavaInstance();
            }
            int index = this.addToStoredObjects(result);
            if (result == null) {
                if (this.debug) {
                    log.debug("readAMF3Object() - Added null object to stored objects for actionScriptClassDescriptor=%s", desc);
                }
                return null;
            }
            if ((objectEncoding & 1) != 0) {
                if (externalizer != null) {
                    if (this.debug) {
                        log.debug("readAMF3Object() - using externalizer=%s", externalizer);
                    }
                    try {
                        externalizer.readExternal(result, this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not read externalized object: " + result, e);
                    }
                } else {
                    if (this.debug) {
                        log.debug("readAMF3Object() - legacy Externalizable=%s", result.getClass());
                    }
                    if (!(result instanceof Externalizable)) {
                        throw new RuntimeException("The ActionScript3 class bound to " + result.getClass().getName() + " (ie: [RemoteClass(alias=\"" + result.getClass().getName() + "\")])" + " implements flash.utils.IExternalizable but this Java class neither" + " implements java.io.Externalizable nor is in the scope of a configured" + " externalizer (please fix your granite-config.xml)");
                    }
                    try {
                        ((Externalizable)result).readExternal(this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not read externalizable object: " + result, e);
                    }
                }
            } else {
                Object value;
                byte vType;
                if (desc.getPropertiesCount() > 0) {
                    if (this.debug) {
                        log.debug("readAMF3Object() - reading defined properties...", new Object[0]);
                    }
                    int i = 0;
                    while (i < desc.getPropertiesCount()) {
                        vType = this.readByte();
                        value = this.readObject(vType);
                        if (this.debug) {
                            log.debug("readAMF3Object() - setting defined property: %s=%s", desc.getPropertyName(i), value);
                        }
                        desc.setPropertyValue(i, result, value);
                        ++i;
                    }
                }
                if (objectEncoding == 2) {
                    String name;
                    if (this.debug) {
                        log.debug("readAMF3Object() - reading dynamic properties...", new Object[0]);
                    }
                    while ((name = this.readAMF3String()).length() != 0) {
                        vType = this.readByte();
                        value = this.readObject(vType);
                        if (this.debug) {
                            log.debug("readAMF3Object() - setting dynamic property: %s=%s", name, value);
                        }
                        desc.setPropertyValue(name, result, value);
                    }
                }
            }
            if (result instanceof AbstractInstantiator) {
                if (this.debug) {
                    log.debug("readAMF3Object() - resolving instantiator...", new Object[0]);
                }
                try {
                    result = ((AbstractInstantiator)result).resolve();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate object: " + result, e);
                }
                this.setStoredObject(index, result);
            }
        }
        if (this.debug) {
            log.debug("readAMF3Object() -> %s", result);
        }
        return result;
    }

    protected Document readAMF3Xml() throws IOException {
        String xml = this.readAMF3XmlString();
        Document result = this.xmlUtil.buildDocument(xml);
        if (this.debugMore) {
            logMore.debug("readAMF3Xml() -> %s", result);
        }
        return result;
    }

    protected String readAMF3XmlString() throws IOException {
        String result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredStrings(type >> 1);
        } else {
            byte[] bytes = this.readBytes(type >> 1);
            result = new String(bytes, "UTF-8");
            this.addToStoredStrings(result);
        }
        if (this.debugMore) {
            logMore.debug("readAMF3XmlString() -> %s", result);
        }
        return result;
    }

    protected byte[] readAMF3ByteArray() throws IOException {
        byte[] result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = (byte[])this.getFromStoredObjects(type >> 1);
        } else {
            result = this.readBytes(type >> 1);
            this.addToStoredObjects(result);
        }
        if (this.debugMore) {
            logMore.debug("readAMF3ByteArray() -> %s", new Object[]{result});
        }
        return result;
    }

    protected void addToStoredStrings(String s) {
        if (this.debug) {
            log.debug("addToStoredStrings(s=%s) at index=%d", s, this.storedStrings.size());
        }
        this.storedStrings.add(s);
    }

    protected String getFromStoredStrings(int index) {
        if (this.debug) {
            log.debug("getFromStoredStrings(index=%d)", index);
        }
        String s = this.storedStrings.get(index);
        if (this.debug) {
            log.debug("getFromStoredStrings() -> %s", s);
        }
        return s;
    }

    protected int addToStoredObjects(Object o) {
        int index = this.storedObjects.size();
        if (this.debug) {
            log.debug("addToStoredObjects(o=%s) at index=%d", o, index);
        }
        this.storedObjects.add(o);
        return index;
    }

    protected void setStoredObject(int index, Object o) {
        if (this.debug) {
            log.debug("setStoredObject(index=%d, o=%s)", index, o);
        }
        this.storedObjects.set(index, o);
    }

    protected Object getFromStoredObjects(int index) {
        if (this.debug) {
            log.debug("getFromStoredObjects(index=%d)", index);
        }
        Object o = this.storedObjects.get(index);
        if (this.debug) {
            log.debug("getFromStoredObjects() -> %s", o);
        }
        return o;
    }

    protected void addToStoredClassDescriptors(ActionScriptClassDescriptor desc) {
        if (this.debug) {
            log.debug("addToStoredClassDescriptors(desc=%s) at index=%d", desc, this.storedClassDescriptors.size());
        }
        this.storedClassDescriptors.add(desc);
    }

    protected ActionScriptClassDescriptor getFromStoredClassDescriptors(int index) {
        if (this.debug) {
            log.debug("getFromStoredClassDescriptors(index=%d)", index);
        }
        ActionScriptClassDescriptor desc = this.storedClassDescriptors.get(index);
        if (this.debug) {
            log.debug("getFromStoredClassDescriptors() -> %s", desc);
        }
        return desc;
    }

    protected byte[] readBytes(int count) throws IOException {
        byte[] bytes = new byte[count];
        int b = -1;
        int i = 0;
        while (i < count) {
            b = this.in.read();
            if (b == -1) {
                throw new EOFException();
            }
            bytes[i] = (byte)b;
            ++i;
        }
        return bytes;
    }
}

