/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.Property;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodProperty
extends Property {
    private final Method setter;
    private final Method getter;
    private final Type type;

    public MethodProperty(Converters converters, String name, Method setter, Method getter) {
        super(converters, name);
        this.setter = setter;
        this.getter = getter;
        this.type = getter != null ? getter.getGenericReturnType() : setter.getParameterTypes()[0];
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass, boolean recursive) {
        if (this.getter != null) {
            if (this.getter.isAnnotationPresent(annotationClass)) {
                return true;
            }
            if (recursive && ClassUtil.isAnnotationPresent(this.getter, annotationClass)) {
                return true;
            }
        }
        if (this.setter != null) {
            if (this.setter.isAnnotationPresent(annotationClass)) {
                return true;
            }
            if (recursive && ClassUtil.isAnnotationPresent(this.setter, annotationClass)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, boolean recursive) {
        ClassUtil.DeclaredAnnotation<T> declaredAnnotation;
        T annotation = null;
        if (this.getter != null && (annotation = (T)this.getter.getAnnotation(annotationClass)) == null && recursive && (declaredAnnotation = ClassUtil.getAnnotation(this.getter, annotationClass)) != null) {
            annotation = declaredAnnotation.annotation;
        }
        if (annotation == null && this.setter != null && (annotation = (T)this.setter.getAnnotation(annotationClass)) == null && recursive && (declaredAnnotation = ClassUtil.getAnnotation(this.setter, annotationClass)) != null) {
            annotation = declaredAnnotation.annotation;
        }
        return annotation;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setProperty(Object instance, Object value, boolean convert) {
        try {
            Object[] params = new Object[]{convert ? this.convert(value) : value};
            this.setter.invoke(instance, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getProperty(Object instance) {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

