/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util.externalizer;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.granite.collections.BasicMap;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.FieldProperty;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.DefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.externalizer.NoDefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.SunDefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.granite.messaging.amf.io.util.externalizer.annotation.IgnoredProperty;
import org.granite.messaging.amf.io.util.instantiator.AbstractInstantiator;
import org.granite.util.ClassUtil;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExternalizer
implements Externalizer {
    private static final Logger log = Logger.getLogger(DefaultExternalizer.class);
    protected static final byte[] BYTES_0 = new byte[0];
    private final ReentrantLock lock = new ReentrantLock();
    protected final ConcurrentHashMap<Class<?>, List<Property>> orderedFields = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Class<?>, List<Property>> orderedSetterFields = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Constructor<?>> constructors = new ConcurrentHashMap();
    protected boolean dynamicClass = false;

    @Override
    public void configure(XMap properties) {
        if (properties != null) {
            String dynamicclass = properties.get("dynamic-class");
            if (Boolean.TRUE.toString().equalsIgnoreCase(dynamicclass)) {
                this.dynamicClass = true;
            }
        }
    }

    @Override
    public Object newInstance(String type, ObjectInput in) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Constructor<?> constructor;
        Constructor<?> constructor2 = constructor = !this.dynamicClass ? this.constructors.get(type) : null;
        if (constructor == null) {
            Constructor<?> previousConstructor;
            Class<?> clazz = ClassUtil.forName(type);
            constructor = this.findDefaultConstructor(clazz);
            if (!this.dynamicClass && (previousConstructor = this.constructors.putIfAbsent(type, constructor)) != null) {
                constructor = previousConstructor;
            }
        }
        return constructor.newInstance(new Object[0]);
    }

    @Override
    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        if (o instanceof AbstractInstantiator) {
            AbstractInstantiator instantiator = (AbstractInstantiator)o;
            List<String> fields = instantiator.getOrderedFieldNames();
            log.debug("Reading bean with instantiator %s with fields %s", instantiator.getClass().getName(), fields);
            for (String fieldName : fields) {
                instantiator.put(fieldName, in.readObject());
            }
        } else {
            List<Property> fields = this.findOrderedFields(o.getClass());
            log.debug("Reading bean %s with fields %s", o.getClass().getName(), fields);
            for (Property field : fields) {
                Object value = in.readObject();
                if (field instanceof MethodProperty && field.isAnnotationPresent(ExternalizedProperty.class, true)) continue;
                field.setProperty(o, value);
            }
        }
    }

    @Override
    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        GraniteContext context = GraniteContext.getCurrentInstance();
        String instantiatorType = context.getGraniteConfig().getInstantiator(o.getClass().getName());
        if (instantiatorType != null) {
            try {
                AbstractInstantiator instantiator = (AbstractInstantiator)ClassUtil.newInstance(instantiatorType);
                List<String> fields = instantiator.getOrderedFieldNames();
                log.debug("Writing bean with instantiator %s with fields %s", instantiator.getClass().getName(), fields);
                for (String fieldName : fields) {
                    Field field = o.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    out.writeObject(field.get(o));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error with instantiatorType: " + instantiatorType, e);
            }
        } else {
            List<Property> fields = this.findOrderedFields(o.getClass());
            log.debug("Writing bean %s with fields %s", o.getClass().getName(), fields);
            for (Property field : fields) {
                BasicMap<?, ?> value = field.getProperty(o);
                if (value instanceof Map) {
                    value = BasicMap.newInstance((Map)value);
                }
                if (this.isValueIgnored(value)) {
                    out.writeObject(null);
                    continue;
                }
                out.writeObject(value);
            }
        }
    }

    protected boolean isValueIgnored(Object value) {
        return false;
    }

    @Override
    public List<Property> findOrderedFields(Class<?> clazz) {
        return this.findOrderedFields(clazz, false);
    }

    public List<Property> findOrderedFields(Class<?> clazz, boolean returnSettersWhenAvailable) {
        List<Property> fields;
        List<Property> list = !this.dynamicClass ? (returnSettersWhenAvailable ? this.orderedSetterFields.get(clazz) : this.orderedFields.get(clazz)) : (fields = null);
        if (fields == null) {
            List<Property> previousFields;
            if (this.dynamicClass) {
                Introspector.flushFromCaches(clazz);
            }
            PropertyDescriptor[] propertyDescriptors = ClassUtil.getProperties(clazz);
            Converters converters = GraniteContext.getCurrentInstance().getGraniteConfig().getConverters();
            fields = new ArrayList<Property>();
            HashSet<String> allFieldNames = new HashSet<String>();
            Class<?> c = clazz;
            while (c != null) {
                ArrayList<Property> newFields = new ArrayList<Property>();
                Object[] objectArray = c.getDeclaredFields();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = objectArray[n2];
                    if (!(allFieldNames.contains(field.getName()) || Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || this.isPropertyIgnored(field) || field.isAnnotationPresent(IgnoredProperty.class))) {
                        boolean found = false;
                        if (returnSettersWhenAvailable && propertyDescriptors != null) {
                            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
                            int n3 = propertyDescriptors.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                PropertyDescriptor pd = propertyDescriptorArray[n4];
                                if (pd.getName().equals(field.getName()) && pd.getWriteMethod() != null) {
                                    newFields.add(new MethodProperty(converters, field.getName(), pd.getWriteMethod(), pd.getReadMethod()));
                                    found = true;
                                    break;
                                }
                                ++n4;
                            }
                        }
                        if (!found) {
                            newFields.add(new FieldProperty(converters, field));
                        }
                    }
                    allFieldNames.add(field.getName());
                    ++n2;
                }
                if (propertyDescriptors != null) {
                    objectArray = propertyDescriptors;
                    n = propertyDescriptors.length;
                    n2 = 0;
                    while (n2 < n) {
                        ClassUtil.DeclaredAnnotation<ExternalizedProperty> annotation;
                        Object property = objectArray[n2];
                        Method getter = ((PropertyDescriptor)property).getReadMethod();
                        if (getter != null && !allFieldNames.contains(((FeatureDescriptor)property).getName()) && (annotation = ClassUtil.getAnnotation(getter, ExternalizedProperty.class)) != null && (annotation.declaringClass == c || annotation.declaringClass.isInterface())) {
                            newFields.add(new MethodProperty(converters, ((FeatureDescriptor)property).getName(), null, getter));
                            allFieldNames.add(((FeatureDescriptor)property).getName());
                        }
                        ++n2;
                    }
                }
                Collections.sort(newFields, new Comparator<Property>(){

                    @Override
                    public int compare(Property o1, Property o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                fields.addAll(0, newFields);
                c = c.getSuperclass();
            }
            if (!this.dynamicClass && (previousFields = (returnSettersWhenAvailable ? this.orderedSetterFields : this.orderedFields).putIfAbsent(clazz, fields)) != null) {
                fields = previousFields;
            }
        }
        return fields;
    }

    protected boolean isPropertyIgnored(Field field) {
        return false;
    }

    protected <T> Constructor<T> findDefaultConstructor(Class<T> clazz) {
        Constructor<T> constructor = null;
        GraniteContext context = GraniteContext.getCurrentInstance();
        String instantiator = context.getGraniteConfig().getInstantiator(clazz.getName());
        if (instantiator != null) {
            try {
                Class<T> instantiatorClass = ClassUtil.forName(instantiator, clazz);
                constructor = instantiatorClass.getConstructor(new Class[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load instantiator class: " + instantiator + " for: " + clazz.getName(), e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not find default constructor in instantiator class: " + instantiator, e);
            }
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (constructor == null) {
            String key = DefaultConstructorFactory.class.getName();
            DefaultConstructorFactory factory = this.getDefaultConstructorFactory(context, key);
            constructor = factory.findDefaultConstructor(clazz);
        }
        return constructor;
    }

    private DefaultConstructorFactory getDefaultConstructorFactory(GraniteContext context, String key) {
        this.lock.lock();
        try {
            DefaultConstructorFactory factory = (DefaultConstructorFactory)context.getApplicationMap().get(key);
            if (factory == null) {
                try {
                    factory = new SunDefaultConstructorFactory();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (factory == null) {
                    factory = new NoDefaultConstructorFactory();
                }
                context.getApplicationMap().put(key, factory);
            }
            DefaultConstructorFactory defaultConstructorFactory = factory;
            return defaultConstructorFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int accept(Class<?> clazz) {
        return clazz.isAnnotationPresent(ExternalizedBean.class) ? 0 : -1;
    }
}

