/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.process;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.RemotingMessage;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.UUIDUtil;

public abstract class AMF3MessageProcessor {
    private static final Logger log = Logger.getLogger(AMF3MessageProcessor.class);

    public static Message process(Message request) {
        HttpSession session;
        Message response;
        AMF3MessageInterceptor interceptor;
        GraniteContext context;
        block8: {
            context = GraniteContext.getCurrentInstance();
            interceptor = context.getGraniteConfig().getAmf3MessageInterceptor();
            response = null;
            try {
                if (interceptor != null) {
                    interceptor.before(request);
                }
                if (request instanceof RemotingMessage) {
                    response = AMF3MessageProcessor.processRemotingMessage((RemotingMessage)request);
                    break block8;
                }
                if (request instanceof CommandMessage) {
                    response = AMF3MessageProcessor.processCommandMessage((CommandMessage)request);
                    break block8;
                }
                throw new IllegalArgumentException("Unknown request message type: " + request);
            }
            catch (Throwable throwable) {
                if (interceptor != null) {
                    interceptor.after(request, response);
                }
                throw throwable;
            }
        }
        if (interceptor != null) {
            interceptor.after(request, response);
        }
        if (context instanceof HttpGraniteContext && (session = ((HttpGraniteContext)context).getRequest().getSession(false)) != null) {
            response.setHeader("org.granite.sessionId", session.getId());
        }
        return response;
    }

    public static Message processCommandMessage(CommandMessage request) {
        log.debug(">> Processing AMF3 request:\n%s", request);
        AcknowledgeMessage response = null;
        if (request.isSecurityOperation()) {
            GraniteContext context = GraniteContext.getCurrentInstance();
            GraniteConfig config = context.getGraniteConfig();
            if (!config.hasSecurityService()) {
                log.warn("Ignored security operation (no security settings in granite-config.xml): %s", request);
            } else {
                SecurityService securityService = config.getSecurityService();
                try {
                    if (request.isLoginOperation()) {
                        securityService.login(request.getBody(), (String)request.getHeader("DSCredentialsCharset"));
                    } else if (request.isLogoutOperation()) {
                        securityService.logout();
                    } else {
                        log.warn("Unknown security operation: %s", request);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SecurityServiceException) {
                        securityService.handleSecurityException((SecurityServiceException)e);
                        log.debug(e, "Could not process security operation: %s", request);
                    } else {
                        log.error(e, "Could not process security operation: %s", request);
                    }
                    response = new ErrorMessage((Message)request, e);
                }
            }
        }
        if (response == null) {
            response = new AcknowledgeMessage(request);
            if (request.isSecurityOperation()) {
                response.setBody("success");
            }
        }
        if ("nil".equals(request.getHeader("DSId"))) {
            response.getHeaders().put("DSId", UUIDUtil.randomUUID());
        }
        log.debug("<< Returning AMF3 response:\n%s", response);
        return response;
    }

    public static Message processRemotingMessage(RemotingMessage request) {
        log.debug(">> Processing AMF3 request:\n%s", request);
        AcknowledgeMessage response = null;
        try {
            ServiceFactory factory = ServiceFactory.getFactoryInstance(request);
            ServiceInvoker<?> service = factory.getServiceInstance(request);
            Object result = service.invoke(request);
            response = new AcknowledgeMessage(request);
            response.setBody(result);
        }
        catch (ServiceException e) {
            log.debug(e, "Could not process remoting message: %s", request);
            response = new ErrorMessage((Message)request, e);
        }
        log.debug("<< Returning AMF3 response:\n%s", response);
        return response;
    }
}

