/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.service.MethodMatcher;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.service.annotations.IgnoredMethod;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.granite.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethodMatcher
implements MethodMatcher {
    private static final Logger log = Logger.getLogger(DefaultMethodMatcher.class);

    @Override
    public ServiceInvocationContext findServiceMethod(Message message, Destination destination, Object service, String methodName, Object[] params) throws NoSuchMethodException {
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        Converters converters = config.getConverters();
        Class<?> serviceClass = service.getClass();
        Type serviceClassGenericType = this.getGenericType(serviceClass);
        MatchingMethod match = null;
        if (params == null || params.length == 0) {
            match = new MatchingMethod(serviceClass.getMethod(methodName, null), null);
        } else {
            ArrayList<MatchingMethod> matchingMethods = new ArrayList<MatchingMethod>();
            ArrayList<Method> methods = new ArrayList<Method>();
            Class<?>[] classArray = serviceClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> serviceInterface = classArray[n2];
                methods.addAll(Arrays.asList(serviceInterface.getMethods()));
                ++n2;
            }
            methods.addAll(Arrays.asList(serviceClass.getMethods()));
            for (Method method : methods) {
                Converter[] convertersArray;
                Type[] paramTypes;
                if (!methodName.equals(method.getName()) || (paramTypes = method.getGenericParameterTypes()).length != params.length || method.isAnnotationPresent(IgnoredMethod.class)) continue;
                if (serviceClassGenericType != null) {
                    this.findAndChange(paramTypes, serviceClassGenericType);
                }
                if ((convertersArray = this.getConvertersArray(converters, params, paramTypes)) == null) continue;
                matchingMethods.add(new MatchingMethod(method, convertersArray));
            }
            if (matchingMethods.size() == 1) {
                match = (MatchingMethod)matchingMethods.get(0);
            } else if (matchingMethods.size() > 1) {
                match = this.resolveMatchingMethod(matchingMethods, serviceClass);
            }
        }
        if (match == null) {
            throw new NoSuchMethodException(String.valueOf(serviceClass.getName()) + '.' + methodName + StringUtil.toString(params));
        }
        params = this.convert(match.convertersArray, params, match.serviceMethod.getGenericParameterTypes());
        return new ServiceInvocationContext(message, destination, service, match.serviceMethod, params);
    }

    protected Converter[] getConvertersArray(Converters converters, Object[] values, Type[] targetTypes) {
        Converter[] convertersArray = new Converter[values.length];
        int i = 0;
        while (i < values.length) {
            convertersArray[i] = converters.getConverter(values[i], targetTypes[i]);
            if (convertersArray[i] == null) {
                return null;
            }
            ++i;
        }
        return convertersArray;
    }

    protected Object[] convert(Converter[] convertersArray, Object[] values, Type[] targetTypes) {
        if (values.length > 0) {
            int i = 0;
            while (i < convertersArray.length) {
                values[i] = convertersArray[i].convert(values[i], targetTypes[i]);
                ++i;
            }
        }
        return values;
    }

    protected MatchingMethod resolveMatchingMethod(List<MatchingMethod> methods, Class<?> serviceClass) {
        for (MatchingMethod m : methods) {
            if (!m.serviceMethod.getDeclaringClass().isAnnotationPresent(RemoteDestination.class)) continue;
            return m;
        }
        ArrayList<MatchingMethod> serviceClassMethods = new ArrayList<MatchingMethod>();
        for (MatchingMethod m : methods) {
            if (!m.serviceMethod.getDeclaringClass().equals(serviceClass)) continue;
            serviceClassMethods.add(m);
        }
        if (serviceClassMethods.size() == 1) {
            return (MatchingMethod)serviceClassMethods.get(0);
        }
        log.warn("Ambiguous method match for " + methods.get((int)0).serviceMethod.getName() + ", selecting first found " + methods.get((int)0).serviceMethod, new Object[0]);
        return methods.get(0);
    }

    protected boolean findAndChange(Type[] paramTypes, Type superType) {
        int idx = -1;
        boolean find = false;
        int j = 0;
        while (j < paramTypes.length) {
            Type type = paramTypes[j];
            if (type instanceof TypeVariable) {
                if (!find) {
                    idx = j;
                    find = true;
                } else {
                    throw new RuntimeException("There's two variable types.");
                }
            }
            ++j;
        }
        if (find) {
            paramTypes[idx] = superType;
        }
        return find;
    }

    protected Type getGenericType(Class<?> clazz) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)clazz.getGenericSuperclass();
            Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length == 1) {
                return actualTypeArguments[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static class MatchingMethod {
        public final Method serviceMethod;
        public final Converter[] convertersArray;

        public MatchingMethod(Method serviceMethod, Converter[] convertersArray) {
            this.serviceMethod = serviceMethod;
            this.convertersArray = convertersArray;
        }

        public String toString() {
            return "MatchingMethod {serviceMethod=" + this.serviceMethod + ", convertersArray=" + (this.convertersArray != null ? Arrays.toString(this.convertersArray) : "[]") + "}";
        }
    }
}

