/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.EjbServiceInvoker;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceFactory
extends ServiceFactory {
    private static final Logger log = Logger.getLogger(EjbServiceFactory.class);
    private Properties environment = null;
    private transient InitialContext initialContext = null;
    private String lookup = null;

    public synchronized Object lookup(String name) throws NamingException {
        if (this.initialContext == null) {
            this.initialContext = this.environment == null || this.environment.isEmpty() ? new InitialContext() : new InitialContext(this.environment);
        }
        return this.initialContext.lookup(name);
    }

    public String getLookup() {
        return this.lookup;
    }

    @Override
    public void configure(XMap properties) throws ServiceException {
        super.configure(properties);
        try {
            this.environment = new Properties();
            for (XMap property : properties.getAll("initial-context-environment/property")) {
                String name = property.get("name");
                String value = property.get("value");
                if ("Context.PROVIDER_URL".equals(name)) {
                    this.environment.put("java.naming.provider.url", value);
                    continue;
                }
                if ("Context.INITIAL_CONTEXT_FACTORY".equals(name)) {
                    this.environment.put("java.naming.factory.initial", value);
                    continue;
                }
                if ("Context.URL_PKG_PREFIXES".equals(name)) {
                    this.environment.put("java.naming.factory.url.pkgs", value);
                    continue;
                }
                if ("Context.SECURITY_PRINCIPAL".equals(name)) {
                    this.environment.put("java.naming.security.principal", value);
                    continue;
                }
                if ("Context.SECURITY_CREDENTIALS".equals(name)) {
                    this.environment.put("java.naming.security.credentials", value);
                    continue;
                }
                log.warn("Unknown InitialContext property: %s (ignored)", name);
            }
            this.initialContext = new InitialContext(this.environment.size() > 0 ? this.environment : null);
        }
        catch (Exception e) {
            throw new ServiceException("Could not create InitialContext", e);
        }
        this.lookup = properties.get("lookup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        GraniteContext context = GraniteContext.getCurrentInstance();
        String destinationId = request.getDestination();
        String key = this.getUniqueKey(destinationId);
        EjbServiceInvoker invoker = null;
        String string = key;
        synchronized (string) {
            Map<String, Object> sessionMap;
            invoker = (EjbServiceInvoker)context.getApplicationMap().get(key);
            if (invoker == null && (sessionMap = context.getSessionMap(false)) != null) {
                invoker = (EjbServiceInvoker)sessionMap.get(key);
            }
        }
        if (invoker == null) {
            Destination destination = context.getServicesConfig().findDestinationById(request.getClass().getName(), destinationId);
            invoker = new EjbServiceInvoker(destination, this);
            Map<String, Object> cache = invoker.getMetadata().isStateful() ? context.getSessionMap(true) : context.getApplicationMap();
            String string2 = key;
            synchronized (string2) {
                EjbServiceInvoker previousInvoker = (EjbServiceInvoker)cache.get(key);
                if (previousInvoker != null) {
                    invoker = previousInvoker;
                } else {
                    cache.put(key, invoker);
                }
            }
        }
        return invoker;
    }

    protected String getUniqueKey(String destinationId) {
        return new StringBuilder(EjbServiceInvoker.class.getName().length() + 1 + destinationId.length()).append(EjbServiceInvoker.class.getName()).append('.').append(destinationId).toString().intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String destinationId) {
        String key;
        GraniteContext context = GraniteContext.getCurrentInstance();
        String string = key = this.getUniqueKey(destinationId);
        synchronized (string) {
            context.getApplicationMap().remove(key);
            Map<String, Object> sessionMap = context.getSessionMap(false);
            if (sessionMap != null) {
                context.getSessionMap().remove(key);
            }
        }
    }

    @Override
    public String toString() {
        return this.toString("\n  lookup: " + this.lookup);
    }
}

