/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import org.granite.messaging.service.ServiceException;
import org.granite.util.ClassUtil;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceMetadata {
    private boolean stateful = false;
    private final Map<Method, Boolean> removeMethods = new HashMap<Method, Boolean>();

    public EjbServiceMetadata() {
    }

    public EjbServiceMetadata(Class<?> scannedClass, Class<?> invokeeClass) {
        this.stateful = scannedClass.isAnnotationPresent(Stateful.class);
        if (this.stateful) {
            Method[] methodArray = scannedClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Remove remove = method.getAnnotation(Remove.class);
                if (remove != null) {
                    try {
                        method = invokeeClass.getMethod(method.getName(), method.getParameterTypes());
                        this.removeMethods.put(method, remove.retainIfException());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    }

    public EjbServiceMetadata(XMap properties, Class<?> invokeeClass) {
        this.stateful = properties.containsKey("ejb-stateful");
        if (this.stateful) {
            for (XMap removeMethod : properties.getAll("ejb-stateful/remove-method")) {
                String signature = removeMethod.get("signature");
                if (signature == null) {
                    throw new ServiceException("Missing signature in remove-method declaration: " + properties);
                }
                Boolean retainIfException = Boolean.valueOf(removeMethod.get("retain-if-exception"));
                try {
                    this.removeMethods.put(ClassUtil.getMethod(invokeeClass, signature), retainIfException);
                }
                catch (NoSuchMethodException e) {
                    throw new ServiceException("Could not find method: " + invokeeClass.getName() + "." + signature);
                }
            }
        }
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isRemoveMethod(Method method) {
        return this.removeMethods.containsKey(method);
    }

    public boolean getRetainIfException(Method method) {
        return this.removeMethods.get(method);
    }
}

