/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.DefaultClassGetter;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.IUID;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.data.DataMergeContext;
import org.granite.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TideServiceContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TideServiceContext.class);
    protected static final Object[] EMPTY_ARGS = new Object[0];
    public static final String COMPONENT_ATTR = "__TIDE_COMPONENT__";
    public static final String COMPONENT_CLASS_ATTR = "__TIDE_COMPONENT_CLASS__";
    private String sessionId = null;

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void initCall() {
    }

    public Object adjustInvokee(Object instance, String componentName, Set<Class<?>> componentClasses) {
        return instance;
    }

    public Object[] beforeMethodSearch(Object instance, String methodName, Object[] args) {
        return new Object[]{args[2], args[3]};
    }

    public abstract Object findComponent(String var1, Class<?> var2);

    public abstract Set<Class<?>> findComponentClasses(String var1, Class<?> var2);

    public abstract void prepareCall(ServiceInvocationContext var1, IInvocationCall var2, String var3, Class<?> var4);

    public abstract IInvocationResult postCall(ServiceInvocationContext var1, Object var2, String var3, Class<?> var4);

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
    }

    protected abstract AsyncPublisher getAsyncPublisher();

    public void sendEvent(String componentName, Class<?> componentClass) {
        AsyncPublisher publisher = this.getAsyncPublisher();
        if (publisher != null) {
            IInvocationResult eventResult = this.postCall(null, null, componentName, componentClass);
            publisher.publishMessage(this.sessionId, eventResult);
        }
    }

    protected abstract TidePersistenceManager getTidePersistenceManager(boolean var1);

    public Object mergeExternal(Object obj, Object previous) {
        TidePersistenceManager pm = this.getTidePersistenceManager(false);
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        return this.mergeExternal(pm, classGetter, obj, previous, null, null);
    }

    protected Object mergeExternal(TidePersistenceManager pm, ClassGetter classGetter, Object obj, Object previous, Object owner, String propertyName) {
        if (obj == null) {
            return null;
        }
        if (pm == null) {
            return obj;
        }
        if (!classGetter.isInitialized(owner, propertyName, obj)) {
            if (previous != null) {
                return previous;
            }
            return obj;
        }
        Map<Object, Object> cache = DataMergeContext.getCache();
        Object key = DataMergeContext.CacheKey.key(obj, owner, propertyName);
        Object prev = cache.get(key);
        Object next = obj;
        if (prev != null) {
            next = prev;
        } else if (obj instanceof Collection) {
            next = this.mergeCollection(pm, classGetter, (Collection)obj, previous, owner, propertyName);
        } else if (obj.getClass().isArray()) {
            next = this.mergeArray(pm, classGetter, obj, previous, owner, propertyName);
        } else if (obj instanceof Map) {
            next = this.mergeMap(pm, classGetter, (Map)obj, previous, owner, propertyName);
        } else if (classGetter.isEntity(obj) || obj.getClass().isAnnotationPresent(ExternalizedBean.class)) {
            next = this.mergeEntity(pm, classGetter, obj, previous, owner, propertyName);
        }
        return next;
    }

    protected boolean equals(Object obj1, Object obj2) {
        if (obj1 instanceof IUID && obj2 instanceof IUID) {
            return ((IUID)obj1).getUid() != null && ((IUID)obj1).getUid().equals(((IUID)obj2).getUid());
        }
        return obj1.equals(obj2);
    }

    private Object mergeEntity(TidePersistenceManager pm, ClassGetter classGetter, Object obj, Object previous, Object owner, String propertyName) {
        Object p;
        Object dest = obj;
        boolean isEntity = classGetter.isEntity(obj);
        boolean sameEntity = false;
        if (isEntity && (p = DataMergeContext.getLoadedEntity(obj)) != null) {
            previous = p;
        }
        boolean bl = sameEntity = previous != null && this.equals(previous, obj);
        if (sameEntity) {
            dest = previous;
        }
        DataMergeContext.getCache().put(DataMergeContext.CacheKey.key(obj, null, null), dest);
        List<Object[]> fieldValues = isEntity ? classGetter.getFieldValues(obj, dest) : DefaultClassGetter.defaultGetFieldValues(obj, dest);
        try {
            for (Object[] fieldValue : fieldValues) {
                Field field = (Field)fieldValue[0];
                Object objv = fieldValue[1];
                Object destv = fieldValue[2];
                objv = this.mergeExternal(pm, classGetter, objv, destv, obj, field.getName());
                field.set(dest, objv);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not merge entity ", e);
        }
        return dest;
    }

    private Object mergeCollection(TidePersistenceManager pm, ClassGetter classGetter, Collection<Object> coll, Object previous, Object owner, String propertyName) {
        Collection prevColl;
        if (log.isDebugEnabled()) {
            log.debug("Context mergeCollection: " + coll + (previous != null ? " previous " + previous.getClass().getName() : ""), new Object[0]);
        }
        Map<Object, Object> cache = DataMergeContext.getCache();
        Object key = DataMergeContext.CacheKey.key(coll, owner, propertyName);
        if (previous != null && previous instanceof Collection) {
            cache.put(key, previous);
        } else {
            cache.put(key, coll);
        }
        Collection collection = prevColl = previous instanceof Collection ? (Collection)previous : null;
        if (coll == prevColl) {
            for (Object obj : coll) {
                this.mergeExternal(pm, classGetter, obj, obj, null, null);
            }
        } else {
            ArrayList<Object> addedToColl = new ArrayList<Object>();
            Iterator<Object> icoll = coll.iterator();
            int i = 0;
            while (i < coll.size()) {
                boolean found;
                Object obj = icoll.next();
                if (prevColl instanceof List) {
                    found = false;
                    List prevList = (List)prevColl;
                    int j = 0;
                    while (j < prevList.size()) {
                        Object prev = prevList.get(j);
                        if (prev != null && this.equals(prev, obj)) {
                            obj = this.mergeExternal(pm, classGetter, obj, prev, null, null);
                            if (i < prevList.size()) {
                                if (j != i) {
                                    prevList.set(j, prevList.get(i));
                                }
                                if (obj != prevList.get(i)) {
                                    prevList.set(i, obj);
                                }
                            } else if (obj != prevList.get(j)) {
                                prevList.set(j, obj);
                            }
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        obj = this.mergeExternal(obj, null);
                        prevColl.add(obj);
                    }
                } else if (prevColl != null) {
                    found = false;
                    Iterator iprevcoll = prevColl.iterator();
                    ArrayList<Object> added = new ArrayList<Object>();
                    int j = 0;
                    while (j < prevColl.size()) {
                        Object prev = iprevcoll.next();
                        if (prev != null && this.equals(prev, obj)) {
                            if ((obj = this.mergeExternal(pm, classGetter, obj, prev, null, null)) != prev) {
                                if (prevColl instanceof List) {
                                    ((List)prevColl).set(j, obj);
                                } else {
                                    iprevcoll.remove();
                                    added.add(obj);
                                }
                            }
                            found = true;
                        }
                        ++j;
                    }
                    prevColl.addAll(added);
                    if (!found) {
                        obj = this.mergeExternal(pm, classGetter, obj, null, null, null);
                        prevColl.add(obj);
                    }
                } else {
                    obj = this.mergeExternal(obj, null);
                    if (icoll instanceof ListIterator) {
                        ((ListIterator)icoll).set(obj);
                    } else {
                        addedToColl.add(obj);
                    }
                }
                ++i;
            }
            if (!addedToColl.isEmpty()) {
                coll.removeAll(addedToColl);
                coll.addAll(addedToColl);
            }
            if (prevColl != null) {
                Iterator iprevcoll = prevColl.iterator();
                int i2 = 0;
                while (i2 < prevColl.size()) {
                    Object obj = iprevcoll.next();
                    boolean found = false;
                    for (Object next : coll) {
                        if (next == null || !this.equals(next, obj)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        iprevcoll.remove();
                        --i2;
                    }
                    ++i2;
                }
                return previous;
            }
        }
        return coll;
    }

    private Object mergeArray(TidePersistenceManager pm, ClassGetter classGetter, Object array, Object previous, Object owner, String propertyName) {
        if (log.isDebugEnabled()) {
            log.debug("Context mergeArray: " + array + (previous != null ? " previous " + previous.getClass().getName() : ""), new Object[0]);
        }
        Object key = DataMergeContext.CacheKey.key(array, owner, propertyName);
        int length = Array.getLength(array);
        Object prevArray = ArrayUtil.newArray(ArrayUtil.getComponentType(array.getClass()), length);
        DataMergeContext.getCache().put(key, prevArray);
        int i = 0;
        while (i < length) {
            Object obj = Array.get(array, i);
            Array.set(prevArray, i, this.mergeExternal(pm, classGetter, obj, null, null, null));
            ++i;
        }
        return prevArray;
    }

    private Object mergeMap(TidePersistenceManager pm, ClassGetter classGetter, Map<Object, Object> map, Object previous, Object owner, String propertyName) {
        Map prevMap;
        if (log.isDebugEnabled()) {
            log.debug("Context mergeMap: " + map + (previous != null ? " previous " + previous.getClass().getName() : ""), new Object[0]);
        }
        Map<Object, Object> cache = DataMergeContext.getCache();
        Object cacheKey = DataMergeContext.CacheKey.key(map, owner, propertyName);
        if (previous != null && previous instanceof Map) {
            cache.put(cacheKey, previous);
        } else {
            cache.put(cacheKey, map);
        }
        Map map2 = prevMap = previous instanceof Map ? (Map)previous : null;
        if (map == prevMap) {
            for (Map.Entry<Object, Object> me : map.entrySet()) {
                this.mergeExternal(pm, classGetter, me.getKey(), null, null, null);
                this.mergeExternal(pm, classGetter, me.getValue(), null, null, null);
            }
        } else {
            if (prevMap != null) {
                if (map != prevMap) {
                    prevMap.clear();
                    for (Map.Entry<Object, Object> me : map.entrySet()) {
                        Object key = this.mergeExternal(pm, classGetter, me.getKey(), null, null, null);
                        Object value = this.mergeExternal(pm, classGetter, me.getValue(), null, null, null);
                        prevMap.put(key, value);
                    }
                }
                return prevMap;
            }
            HashSet<Object[]> addedToMap = new HashSet<Object[]>();
            Iterator<Map.Entry<Object, Object>> ime = map.entrySet().iterator();
            while (ime.hasNext()) {
                Map.Entry<Object, Object> me = ime.next();
                ime.remove();
                Object key = this.mergeExternal(pm, classGetter, me.getKey(), null, null, null);
                Object value = this.mergeExternal(pm, classGetter, me.getValue(), null, null, null);
                addedToMap.add(new Object[]{key, value});
            }
            for (Object[] me : addedToMap) {
                map.put(me[0], me[1]);
            }
        }
        return map;
    }

    public Object lazyInitialize(Object entity, String[] propertyNames) {
        TidePersistenceManager pm = this.getTidePersistenceManager(true);
        if (pm == null) {
            log.warn("No persistence manager found: lazy initialization ignored for " + entity, new Object[0]);
            return entity;
        }
        return pm.attachEntity(entity, propertyNames);
    }
}

