/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.granite.clustering.GraniteDistributedData;
import org.granite.clustering.GraniteDistributedDataFactory;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.data.DataDispatcher;
import org.granite.tide.data.DataObserveParams;
import org.granite.tide.data.DataPublishParams;
import org.granite.tide.data.DataTopicParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataDispatcher
implements DataDispatcher {
    private static final String TIDE_DATA_SELECTORS_KEY_PREFIX = "org.granite.tide.dataSelectors.";
    private static final Logger log = Logger.getLogger(AbstractDataDispatcher.class);
    protected boolean enabled;
    protected String topicName = null;
    protected DataTopicParams paramsProvider = null;
    protected String sessionId = null;
    protected String clientId = null;
    protected String subscriptionId = null;

    public AbstractDataDispatcher(String topicName, Class<? extends DataTopicParams> dataTopicParamsClass) {
        this.topicName = topicName;
        try {
            this.paramsProvider = dataTopicParamsClass.newInstance();
        }
        catch (Exception e) {
            log.error("Could not instantiate class " + dataTopicParamsClass, e);
        }
    }

    @Override
    public void observe() {
        GraniteContext graniteContext;
        DataObserveParams params = null;
        if (this.paramsProvider != null) {
            params = new DataObserveParams();
            this.paramsProvider.observes(params);
        }
        if (!((graniteContext = GraniteContext.getCurrentInstance()) instanceof HttpGraniteContext)) {
            return;
        }
        GraniteDistributedData gdd = GraniteDistributedDataFactory.getInstance();
        HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
        ArrayList<DataObserveParams> selectors = (ArrayList<DataObserveParams>)session.getAttribute(TIDE_DATA_SELECTORS_KEY_PREFIX + this.topicName);
        if (selectors == null) {
            selectors = new ArrayList<DataObserveParams>();
            session.setAttribute(TIDE_DATA_SELECTORS_KEY_PREFIX + this.topicName, selectors);
        }
        boolean dataSelectorChanged = false;
        String dataSelector = gdd.getDestinationSelector(this.topicName);
        if (params != null) {
            String newDataSelector = params.updateDataSelector(dataSelector, selectors);
            boolean bl = dataSelectorChanged = !newDataSelector.equals(dataSelector);
            if (dataSelectorChanged) {
                gdd.setDestinationSelector(this.topicName, newDataSelector);
                dataSelector = newDataSelector;
            }
        }
        if (!this.enabled) {
            return;
        }
        if (dataSelectorChanged) {
            this.changeDataSelector(dataSelector);
        }
    }

    protected abstract void changeDataSelector(String var1);

    @Override
    public void publish(Object[][] dataUpdates) {
        if (!this.enabled) {
            return;
        }
        try {
            HashMap<Map<String, String>, ArrayList<Object[]>> updates = new HashMap<Map<String, String>, ArrayList<Object[]>>();
            if (this.paramsProvider != null) {
                Object[][] objectArray = dataUpdates;
                int n = dataUpdates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] dataUpdate = objectArray[n2];
                    DataPublishParams params = new DataPublishParams();
                    this.paramsProvider.publishes(params, dataUpdate[1]);
                    Map<String, String> headers = params.getHeaders();
                    ArrayList<Object[]> list = (ArrayList<Object[]>)updates.get(headers);
                    if (list == null) {
                        list = new ArrayList<Object[]>();
                        updates.put(headers, list);
                    }
                    list.add(dataUpdate);
                    ++n2;
                }
            }
            for (Map.Entry me : updates.entrySet()) {
                HashMap<String, String> headers = new HashMap<String, String>((Map)me.getKey());
                headers.put("DSSubtopic", "tideDataTopic");
                headers.put("GDSSessionID", this.sessionId);
                headers.put("type", "DATA");
                this.publishUpdate(headers, ((List)me.getValue()).toArray());
            }
        }
        catch (Exception e) {
            log.error(e, "Could not publish data update on topic %s", this.topicName);
        }
    }

    protected abstract void publishUpdate(Map<String, String> var1, Object var2);
}

