/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;
import org.granite.tide.data.DataDispatcher;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataTopicParams;
import org.granite.tide.data.DataUpdatePostprocessor;
import org.granite.tide.data.DefaultDataDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContext {
    private static final Logger log = Logger.getLogger(DataContext.class);
    private static ThreadLocal<DataContext> dataContext = new ThreadLocal();
    private static DataContext NULL_DATA_CONTEXT = new NullDataContext();
    private DataDispatcher dataDispatcher = null;
    private DataEnabled.PublishMode publishMode = null;
    private Object[][] updates = null;
    private DataUpdatePostprocessor dataUpdatePostprocessor = null;
    private final Set<Object[]> dataUpdates = new TreeSet<Object[]>(new Comparator<Object[]>(){

        @Override
        public int compare(Object[] o1, Object[] o2) {
            if (!((Integer)o1[2]).equals(o2[2])) {
                return (Integer)o1[2] - (Integer)o2[2];
            }
            if (!o1[1].equals(o2[1])) {
                return o1[1].hashCode() - o2[1].hashCode();
            }
            return ((EntityUpdateType)((Object)o1[0])).ordinal() - ((EntityUpdateType)((Object)o2[0])).ordinal();
        }
    });
    private boolean published = false;

    public static void init() {
        if (dataContext.get() == null) {
            dataContext.set(NULL_DATA_CONTEXT);
        }
    }

    public static void init(String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        DataContext dc = new DataContext(null, topic, dataTopicParamsClass, publishMode);
        dataContext.set(dc);
    }

    public static void init(Gravity gravity, String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        DataContext dc = new DataContext(gravity, topic, dataTopicParamsClass, publishMode);
        dataContext.set(dc);
    }

    public static void init(DataDispatcher dataDispatcher, DataEnabled.PublishMode publishMode) {
        DataContext dc = new DataContext(dataDispatcher, publishMode);
        dataContext.set(dc);
    }

    private DataContext(Gravity gravity, String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        log.debug("Init Gravity data context for topic %s and mode %s", new Object[]{topic, publishMode});
        this.dataDispatcher = new DefaultDataDispatcher(gravity, topic, dataTopicParamsClass);
        this.publishMode = publishMode;
    }

    private DataContext(DataDispatcher dataDispatcher, DataEnabled.PublishMode publishMode) {
        log.debug("Init data context with custom dispatcher %s and mode %s", new Object[]{dataDispatcher, publishMode});
        this.dataDispatcher = dataDispatcher;
        this.publishMode = publishMode;
    }

    public static DataContext get() {
        return dataContext.get();
    }

    public static void remove() {
        log.debug("Remove data context", new Object[0]);
        dataContext.remove();
    }

    public static boolean isNull() {
        return dataContext.get() == NULL_DATA_CONTEXT;
    }

    public Set<Object[]> getDataUpdates() {
        return this.dataUpdates;
    }

    public Object[][] getUpdates() {
        if (this.updates != null) {
            return this.updates;
        }
        if (this.dataUpdates == null || this.dataUpdates.isEmpty()) {
            return null;
        }
        this.updates = new Object[this.dataUpdates.size()][];
        int i = 0;
        for (Object[] u : this.dataUpdates) {
            this.updates[i++] = new Object[]{((EntityUpdateType)((Object)u[0])).name(), this.dataUpdatePostprocessor != null ? this.dataUpdatePostprocessor.process(u[1]) : u[1]};
        }
        return this.updates;
    }

    public void setDataUpdatePostprocessor(DataUpdatePostprocessor dataUpdatePostprocessor) {
        this.dataUpdatePostprocessor = dataUpdatePostprocessor;
    }

    public static void addUpdate(EntityUpdateType type, Object entity) {
        DataContext.addUpdate(type, entity, 0);
    }

    public static void addUpdate(EntityUpdateType type, Object entity, int priority) {
        DataContext dc = DataContext.get();
        if (dc != null && dc.dataDispatcher != null) {
            for (Object[] update : dc.dataUpdates) {
                if (!update[0].equals((Object)type) || !update[1].equals(entity)) continue;
                if ((Integer)update[2] < priority) {
                    update[2] = priority;
                }
                return;
            }
            dc.dataUpdates.add(new Object[]{type, entity, priority});
            dc.updates = null;
        }
    }

    public static void observe() {
        DataContext dc = DataContext.get();
        if (dc != null && dc.dataDispatcher != null) {
            log.debug("Observe data updates", new Object[0]);
            dc.dataDispatcher.observe();
        }
    }

    public static void publish() {
        DataContext.publish(DataEnabled.PublishMode.MANUAL);
    }

    public static void publish(DataEnabled.PublishMode publishMode) {
        DataContext dc = DataContext.get();
        if (!(dc == null || dc.dataDispatcher == null || dc.dataUpdates.isEmpty() || dc.published || publishMode != DataEnabled.PublishMode.MANUAL && !dc.publishMode.equals((Object)publishMode))) {
            log.debug("Publish %s data updates with mode %s", new Object[]{dc.dataUpdates.size(), dc.publishMode});
            dc.dataDispatcher.publish(dc.getUpdates());
            dc.published = true;
        }
    }

    /* synthetic */ DataContext(DataDispatcher dataDispatcher, DataEnabled.PublishMode publishMode, DataContext dataContext) {
        this(dataDispatcher, publishMode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityUpdateType {
        PERSIST,
        UPDATE,
        REMOVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullDataContext
    extends DataContext {
        public NullDataContext() {
            super(null, null, null);
        }

        @Override
        public Set<Object[]> getDataUpdates() {
            return Collections.emptySet();
        }
    }
}

