/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObserveParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Set<String>> params = new HashMap<String, Set<String>>();
    private String selector = null;

    public boolean isEmpty() {
        return this.selector == null && this.params.isEmpty();
    }

    public boolean addValue(String paramName, String value) {
        if (paramName == null || value == null || paramName.trim().length() == 0 || value.trim().length() == 0) {
            throw new NullPointerException("paramName and value cannot be null or empty");
        }
        if (this.selector != null) {
            throw new IllegalArgumentException("Cannot mix manual and automatic selectors");
        }
        Set<String> values = this.params.get(paramName);
        if (values == null) {
            values = new HashSet<String>();
            this.params.put(paramName, values);
        }
        return values.add(value);
    }

    public void setSelector(String selector) {
        if (selector == null || selector.trim().length() == 0) {
            throw new NullPointerException("selector cannot be null or empty");
        }
        if (!this.params.isEmpty()) {
            throw new IllegalArgumentException("Cannot mix manual and automatic selectors");
        }
        this.selector = selector;
    }

    public void append(StringBuilder sb) {
        if (this.selector != null) {
            sb.append("(").append(this.selector).append(")");
            return;
        }
        boolean f = true;
        for (Map.Entry<String, Set<String>> me : this.params.entrySet()) {
            if (f) {
                f = false;
            } else {
                sb.append(" AND ");
            }
            Set<String> values = me.getValue();
            if (values.size() == 1) {
                sb.append(me.getKey()).append(" = '").append(values.iterator().next()).append("'");
                continue;
            }
            sb.append(me.getKey()).append(" IN (");
            boolean ff = true;
            for (String value : values) {
                if (ff) {
                    ff = false;
                } else {
                    sb.append(", ");
                }
                sb.append("'").append(value).append("'");
            }
            sb.append(")");
        }
    }

    private static boolean containsParams(List<DataObserveParams> selectors, DataObserveParams params) {
        for (DataObserveParams selector : selectors) {
            if (!selector.containsParams(params)) continue;
            return true;
        }
        return false;
    }

    private boolean containsParams(DataObserveParams params) {
        if (this.selector != null && !this.selector.equals(params.selector)) {
            return false;
        }
        for (Map.Entry<String, Set<String>> me : params.params.entrySet()) {
            Set<String> values = this.params.get(me.getKey());
            if (values != null && values.containsAll((Collection)me.getValue())) continue;
            return false;
        }
        return params.params.keySet().containsAll(this.params.keySet());
    }

    public String updateDataSelector(String dataSelector, List<DataObserveParams> selectors) {
        if (!DataObserveParams.containsParams(selectors, this)) {
            if (!this.isEmpty()) {
                ArrayList<DataObserveParams> sels = new ArrayList<DataObserveParams>(selectors);
                selectors.clear();
                for (DataObserveParams s : sels) {
                    if (this.containsParams(s)) continue;
                    selectors.add(s);
                }
                selectors.add(this);
            }
            return this.buildSelectorString(selectors);
        }
        if (dataSelector == null) {
            return "type = 'UNINITIALIZED'";
        }
        return dataSelector;
    }

    private String buildSelectorString(List<DataObserveParams> selectors) {
        StringBuilder sb = new StringBuilder("type = 'DATA'");
        if (!selectors.isEmpty()) {
            sb.append(" AND (");
            boolean first = true;
            for (DataObserveParams selector : selectors) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" OR ");
                }
                sb.append("(");
                selector.append(sb);
                sb.append(")");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb);
        return sb.toString();
    }
}

