/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.granite.clustering.GraniteDistributedData;
import org.granite.clustering.GraniteDistributedDataFactory;
import org.granite.context.GraniteContext;
import org.granite.gravity.Channel;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.data.AbstractDataDispatcher;
import org.granite.tide.data.DataTopicParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDataDispatcher
extends AbstractDataDispatcher {
    private static final Logger log = Logger.getLogger(DefaultDataDispatcher.class);
    private Gravity gravity = null;
    private String clientId = null;
    private String subscriptionId = null;

    public DefaultDataDispatcher(Gravity gravity, String topicName, Class<? extends DataTopicParams> dataTopicParamsClass) {
        super(topicName, dataTopicParamsClass);
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        if (gravity == null && graniteContext == null) {
            return;
        }
        if (graniteContext instanceof HttpGraniteContext) {
            this.gravity = GravityManager.getGravity(((HttpGraniteContext)graniteContext).getServletContext());
            HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
            if (this.gravity == null || session == null) {
                log.debug("Gravity not found or HTTP session not found, data dispatch disabled", new Object[0]);
                return;
            }
            this.sessionId = session.getId();
            GraniteDistributedData gdd = GraniteDistributedDataFactory.getInstance();
            this.clientId = gdd.getDestinationClientId(topicName);
            if (this.clientId == null) {
                log.debug("Gravity channel clientId not defined, data dispatch disabled", new Object[0]);
                return;
            }
            this.subscriptionId = gdd.getDestinationSubscriptionId(topicName);
            if (this.subscriptionId == null) {
                log.debug("Gravity channel subscriptionId not defined, data dispatch disabled", new Object[0]);
                return;
            }
        } else {
            if (gravity == null) {
                log.debug("Gravity not defined, data dispatch disabled", new Object[0]);
                return;
            }
            this.gravity = gravity;
            this.sessionId = "__GDS_SERVER_DISPATCHER__";
        }
        this.enabled = true;
    }

    @Override
    protected void changeDataSelector(String dataSelector) {
        HttpSession session = ((HttpGraniteContext)GraniteContext.getCurrentInstance()).getSession(false);
        if (session != null) {
            GraniteDistributedData gdd = GraniteDistributedDataFactory.getInstance();
            String clientId = gdd.getDestinationClientId(this.topicName);
            String subscriptionId = gdd.getDestinationSubscriptionId(this.topicName);
            if (clientId != null) {
                CommandMessage message = new CommandMessage();
                message.setClientId(clientId);
                message.setHeader("DSDstClientId", subscriptionId);
                message.setHeader("DSSubtopic", "tideDataTopic");
                message.setDestination(this.topicName);
                message.setOperation(0);
                message.setHeader("DSSelector", dataSelector);
                this.gravity.handleMessage(message, true);
                log.debug("Topic %s data selector changed: %s", this.topicName, dataSelector);
            }
        }
    }

    @Override
    public void publishUpdate(Map<String, String> params, Object body) {
        Channel channel = this.gravity.getChannel(this.clientId);
        AsyncMessage message = new AsyncMessage();
        message.setClientId(this.clientId);
        message.setDestination(this.topicName);
        for (Map.Entry<String, String> hh : params.entrySet()) {
            message.setHeader(hh.getKey(), hh.getValue());
        }
        message.setBody(body);
        Message resultMessage = this.gravity.publishMessage(channel, message);
        if (resultMessage instanceof ErrorMessage) {
            log.error("Could not dispatch data update on topic %s, message %s", this.topicName, resultMessage.toString());
        } else {
            log.debug("Data message dispatched on topic %s", this.topicName);
        }
    }
}

