/*
 * Decompiled with CFR 0.152.
 */
package org.granite.datanucleus;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jdo.annotations.EmbeddedOnly;
import javax.jdo.annotations.Extension;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.persistence.Version;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.annotations.Include;
import org.granite.messaging.persistence.AbstractExternalizablePersistentCollection;
import org.granite.messaging.persistence.ExternalizablePersistentList;
import org.granite.messaging.persistence.ExternalizablePersistentMap;
import org.granite.messaging.persistence.ExternalizablePersistentSet;
import org.granite.util.Reflections;
import org.granite.util.StringUtil;
import org.granite.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNucleusExternalizer
extends DefaultExternalizer {
    private static final Logger log = Logger.getLogger(DataNucleusExternalizer.class);
    private static final Integer NULL_ID = 0;
    private static boolean jpaEnabled;
    private static Class<? extends Annotation> entityAnnotation;
    private static Class<? extends Annotation> mappedSuperClassAnnotation;
    private static Class<? extends Annotation> embeddableAnnotation;
    private static Class<? extends Annotation> idClassAnnotation;

    public Object newInstance(String type, ObjectInput in) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class clazz = TypeUtil.forName((String)type);
        if (!this.isRegularEntity(clazz)) {
            return super.newInstance(type, in);
        }
        boolean initialized = (Boolean)in.readObject();
        String detachedState = (String)in.readObject();
        if (initialized && detachedState == null) {
            return super.newInstance(type, in);
        }
        if (!initialized) {
            Object id = in.readObject();
            if (id != null && jpaEnabled) {
                boolean error;
                boolean bl = error = !clazz.isAnnotationPresent(idClassAnnotation);
                if (!error) {
                    Annotation idClass = clazz.getAnnotation(idClassAnnotation);
                    try {
                        Method m = idClass.getClass().getMethod("value", new Class[0]);
                        error = !id.getClass().equals(m.invoke((Object)idClass, new Object[0]));
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Could not get idClass annotation value", new Object[0]);
                        error = true;
                    }
                }
                if (error) {
                    throw new RuntimeException("Id for DataNucleus pseudo-proxy should be null (" + type + ")");
                }
            }
            return null;
        }
        Object entity = clazz.newInstance();
        if (detachedState.length() > 0) {
            byte[] data = StringUtil.hexStringToBytes((String)detachedState);
            this.deserializeDetachedState((Detachable)entity, data);
        }
        return entity;
    }

    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        if (!this.isRegularEntity(o.getClass()) && !this.isEmbeddable(o.getClass())) {
            log.debug("Delegating non regular entity reading to DefaultExternalizer...", new Object[0]);
            super.readExternal(o, in);
        } else {
            GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
            Converters converters = config.getConverters();
            ClassGetter classGetter = config.getClassGetter();
            Class oClass = classGetter.getClass(o);
            ParameterizedType[] declaringTypes = TypeUtil.getDeclaringTypes((Class)oClass);
            Object[] detachedState = DataNucleusExternalizer.getDetachedState((Detachable)o);
            List<Property> fields = this.findOrderedFields(oClass, detachedState != null);
            log.debug("Reading entity %s with fields %s", new Object[]{oClass.getName(), fields});
            for (Property field : fields) {
                if (field.getName().equals("jdoDetachedState")) continue;
                Object value = in.readObject();
                if (field instanceof MethodProperty && field.isAnnotationPresent(Include.class, true)) continue;
                if (value instanceof AbstractExternalizablePersistentCollection) {
                    value = this.newCollection((AbstractExternalizablePersistentCollection)value, field);
                } else {
                    Type targetType = TypeUtil.resolveTypeVariable((Type)field.getType(), (Class)field.getDeclaringClass(), (ParameterizedType[])declaringTypes);
                    value = converters.convert(value, targetType);
                }
                field.setProperty(o, value, false);
            }
        }
    }

    protected Object newCollection(AbstractExternalizablePersistentCollection value, Property field) {
        Type target = field.getType();
        boolean initialized = value.isInitialized();
        Object[] content = value.getContent();
        boolean sorted = SortedSet.class.isAssignableFrom(TypeUtil.classOfType((Type)target)) || SortedMap.class.isAssignableFrom(TypeUtil.classOfType((Type)target));
        Object coll = null;
        if (value instanceof ExternalizablePersistentSet) {
            if (initialized) {
                if (content != null) {
                    coll = ((ExternalizablePersistentSet)value).getContentAsSet(target);
                }
            } else {
                coll = sorted ? new TreeSet() : new HashSet();
            }
        } else if (value instanceof ExternalizablePersistentList) {
            if (initialized) {
                if (content != null) {
                    coll = ((ExternalizablePersistentList)value).getContentAsList(target);
                }
            } else {
                coll = new ArrayList();
            }
        } else if (value instanceof ExternalizablePersistentMap) {
            if (initialized) {
                if (content != null) {
                    coll = ((ExternalizablePersistentMap)value).getContentAsMap(target);
                }
            } else {
                coll = sorted ? new TreeMap() : new HashMap();
            }
        } else {
            throw new RuntimeException("Illegal externalizable persitent class: " + value);
        }
        return coll;
    }

    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        Class oClass = classGetter.getClass(o);
        if (!this.isRegularEntity(o.getClass()) && !this.isEmbeddable(o.getClass())) {
            log.debug("Delegating non regular entity writing to DefaultExternalizer...", new Object[0]);
            super.writeExternal(o, out);
        } else {
            Detachable pco = (Detachable)o;
            DataNucleusExternalizer.preSerialize((PersistenceCapable)pco);
            Object[] detachedState = DataNucleusExternalizer.getDetachedState(pco);
            if (this.isRegularEntity(o.getClass())) {
                if (detachedState != null && detachedState[0] == NULL_ID) {
                    out.writeObject(Boolean.FALSE);
                    out.writeObject(null);
                    out.writeObject(null);
                    return;
                }
                out.writeObject(Boolean.TRUE);
                if (detachedState != null) {
                    Object version = DataNucleusExternalizer.getVersion(pco);
                    if (version != null) {
                        detachedState[1] = version;
                    }
                    byte[] binDetachedState = this.serializeDetachedState(detachedState);
                    char[] hexDetachedState = StringUtil.bytesToHexChars((byte[])binDetachedState);
                    out.writeObject(new String(hexDetachedState));
                } else {
                    out.writeObject(null);
                }
            }
            List fields = this.findOrderedFields(oClass);
            Map<String, Boolean> loadedState = DataNucleusExternalizer.getLoadedState(detachedState, oClass);
            log.debug("Writing entity %s with fields %s", new Object[]{o.getClass().getName(), fields});
            for (Property field : fields) {
                if (field.getName().equals("jdoDetachedState")) continue;
                Object value = field.getProperty(o);
                if (this.isValueIgnored(value)) {
                    out.writeObject(null);
                    continue;
                }
                if (loadedState.containsKey(field.getName()) && !loadedState.get(field.getName()).booleanValue()) {
                    Class fieldClass = TypeUtil.classOfType((Type)field.getType());
                    if (Detachable.class.isAssignableFrom(fieldClass)) {
                        try {
                            value = fieldClass.newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not create DataNucleus pseudo-proxy for: " + field, e);
                        }
                        DataNucleusExternalizer.setDetachedState((Detachable)value, new Object[]{NULL_ID, null, null, null});
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        value = Set.class.isAssignableFrom(fieldClass) ? new ExternalizablePersistentSet((Set)null, false, false) : new ExternalizablePersistentList((List)null, false, false);
                    } else if (Map.class.isAssignableFrom(fieldClass)) {
                        value = new ExternalizablePersistentMap((Map)null, false, false);
                    }
                } else if (value instanceof Set) {
                    value = new ExternalizablePersistentSet(((Set)value).toArray(), true, false);
                } else if (value instanceof List) {
                    value = new ExternalizablePersistentList(((List)value).toArray(), true, false);
                } else if (value instanceof Map) {
                    value = new ExternalizablePersistentMap((Map)null, true, false);
                    ((ExternalizablePersistentMap)value).setContentFromMap((Map)value);
                }
                out.writeObject(value);
            }
        }
    }

    public int accept(Class<?> clazz) {
        return clazz.isAnnotationPresent(entityAnnotation) || clazz.isAnnotationPresent(mappedSuperClassAnnotation) || clazz.isAnnotationPresent(embeddableAnnotation) || clazz.isAnnotationPresent(javax.jdo.annotations.PersistenceCapable.class) ? 1 : -1;
    }

    protected boolean isRegularEntity(Class<?> clazz) {
        if (jpaEnabled) {
            return (PersistenceCapable.class.isAssignableFrom(clazz) && Detachable.class.isAssignableFrom(clazz) && !clazz.isAnnotationPresent(EmbeddedOnly.class) || clazz.isAnnotationPresent(entityAnnotation) || clazz.isAnnotationPresent(mappedSuperClassAnnotation)) && !clazz.isAnnotationPresent(embeddableAnnotation);
        }
        return PersistenceCapable.class.isAssignableFrom(clazz) && Detachable.class.isAssignableFrom(clazz) && !clazz.isAnnotationPresent(EmbeddedOnly.class);
    }

    protected boolean isEmbeddable(Class<?> clazz) {
        if (jpaEnabled) {
            return (PersistenceCapable.class.isAssignableFrom(clazz) && Detachable.class.isAssignableFrom(clazz) && clazz.isAnnotationPresent(EmbeddedOnly.class) || clazz.isAnnotationPresent(embeddableAnnotation)) && !clazz.isAnnotationPresent(entityAnnotation) && !clazz.isAnnotationPresent(mappedSuperClassAnnotation);
        }
        return PersistenceCapable.class.isAssignableFrom(clazz) && Detachable.class.isAssignableFrom(clazz) && clazz.isAnnotationPresent(EmbeddedOnly.class);
    }

    public List<Property> findOrderedFields(Class<?> clazz, boolean returnSettersWhenAvailable) {
        List orderedFields = super.findOrderedFields(clazz, returnSettersWhenAvailable);
        if (clazz.isAnnotationPresent(EmbeddedOnly.class) || jpaEnabled && clazz.isAnnotationPresent(embeddableAnnotation)) {
            Iterator ifield = orderedFields.iterator();
            while (ifield.hasNext()) {
                Property field = (Property)ifield.next();
                if (!field.getName().equals("jdoDetachedState")) continue;
                ifield.remove();
            }
        }
        return orderedFields;
    }

    private static void preSerialize(PersistenceCapable o) {
        try {
            Class<?> baseClass = o.getClass();
            while (baseClass.getSuperclass() != Object.class && baseClass.getSuperclass() != null && PersistenceCapable.class.isAssignableFrom(baseClass.getSuperclass())) {
                baseClass = baseClass.getSuperclass();
            }
            Field f = baseClass.getDeclaredField("jdoStateManager");
            f.setAccessible(true);
            StateManager sm = (StateManager)f.get(o);
            if (sm != null) {
                DataNucleusExternalizer.setDetachedState((Detachable)o, null);
                sm.preSerialize(o);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access jdoDetachedState for detached object", e);
        }
    }

    private static Object[] getDetachedState(Detachable o) {
        try {
            Class<?> baseClass = o.getClass();
            while (baseClass.getSuperclass() != Object.class && baseClass.getSuperclass() != null && PersistenceCapable.class.isAssignableFrom(baseClass.getSuperclass())) {
                baseClass = baseClass.getSuperclass();
            }
            Field f = baseClass.getDeclaredField("jdoDetachedState");
            f.setAccessible(true);
            return (Object[])f.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access jdoDetachedState for detached object", e);
        }
    }

    private static void setDetachedState(Detachable o, Object[] detachedState) {
        try {
            Class<?> baseClass = o.getClass();
            while (baseClass.getSuperclass() != Object.class && baseClass.getSuperclass() != null && PersistenceCapable.class.isAssignableFrom(baseClass.getSuperclass())) {
                baseClass = baseClass.getSuperclass();
            }
            Field f = baseClass.getDeclaredField("jdoDetachedState");
            f.setAccessible(true);
            f.set(o, detachedState);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access jdoDetachedState for detached object", e);
        }
    }

    static Map<String, Boolean> getLoadedState(Detachable pc, Class<?> clazz) {
        return DataNucleusExternalizer.getLoadedState(DataNucleusExternalizer.getDetachedState(pc), clazz);
    }

    static Map<String, Boolean> getLoadedState(Object[] detachedState, Class<?> clazz) {
        try {
            BitSet loaded = detachedState != null ? (BitSet)detachedState[2] : null;
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Class<?> c = clazz; c != null && PersistenceCapable.class.isAssignableFrom(c); c = c.getSuperclass()) {
                Field pcFieldNames = c.getDeclaredField("jdoFieldNames");
                pcFieldNames.setAccessible(true);
                fieldNames.addAll(0, Arrays.asList((String[])pcFieldNames.get(null)));
            }
            HashMap<String, Boolean> loadedState = new HashMap<String, Boolean>();
            for (int i = 0; i < fieldNames.size(); ++i) {
                loadedState.put((String)fieldNames.get(i), loaded != null && loaded.size() > i ? loaded.get(i) : true);
            }
            return loadedState;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get loaded state for: " + detachedState);
        }
    }

    protected byte[] serializeDetachedState(Object[] detachedState) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(detachedState);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize detached state for: " + detachedState);
        }
    }

    protected void deserializeDetachedState(Detachable pc, byte[] data) {
        try {
            ByteArrayInputStream baos = new ByteArrayInputStream(data);
            ObjectInputStream oos = new ObjectInputStream(baos);
            Object[] state = (Object[])oos.readObject();
            DataNucleusExternalizer.setDetachedState(pc, state);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize detached state for: " + data);
        }
    }

    protected static Object getVersion(Object entity) {
        Class<?> entityClass = entity.getClass();
        if (jpaEnabled && entityClass.isAnnotationPresent(entityAnnotation)) {
            Class<?> clazz;
            for (clazz = entityClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    if (!accessibleObject.isAnnotationPresent(Version.class)) continue;
                    return Reflections.invokeAndWrap((Method)accessibleObject, (Object)entity, (Object[])new Object[0]);
                }
            }
            for (clazz = entityClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                    if (!accessibleObject.isAnnotationPresent(Version.class)) continue;
                    if (!accessibleObject.isAccessible()) {
                        ((Field)accessibleObject).setAccessible(true);
                    }
                    return Reflections.getAndWrap((Field)accessibleObject, (Object)entity);
                }
            }
            return null;
        }
        if (!jpaEnabled && entity instanceof PersistenceCapable && entityClass.isAnnotationPresent(javax.jdo.annotations.Version.class)) {
            javax.jdo.annotations.Version version = entityClass.getAnnotation(javax.jdo.annotations.Version.class);
            for (Extension extension : version.extensions()) {
                if (!extension.vendorName().equals("datanucleus") || !extension.key().equals("field-name")) continue;
                String versionFieldName = extension.value();
                try {
                    Method versionGetter = entityClass.getMethod("get" + versionFieldName.substring(0, 1).toUpperCase() + versionFieldName.substring(1), new Class[0]);
                    return Reflections.invokeAndWrap((Method)versionGetter, (Object)entity, (Object[])new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    for (Class<?> clazz = entityClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                        for (Field field : clazz.getDeclaredFields()) {
                            if (!field.getName().equals(versionFieldName)) continue;
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            return Reflections.getAndWrap((Field)field, (Object)entity);
                        }
                    }
                }
            }
        }
        return null;
    }

    static {
        try {
            ClassLoader cl = DataNucleusExternalizer.class.getClassLoader();
            entityAnnotation = cl.loadClass("javax.persistence.Entity");
            mappedSuperClassAnnotation = cl.loadClass("javax.persistence.MappedSuperclass");
            embeddableAnnotation = cl.loadClass("javax.persistence.Embeddable");
            idClassAnnotation = cl.loadClass("javax.persistence.IdClass");
            jpaEnabled = true;
        }
        catch (Exception e) {
            entityAnnotation = null;
            mappedSuperClassAnnotation = null;
            embeddableAnnotation = null;
            idClassAnnotation = null;
            jpaEnabled = false;
        }
    }
}

