/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.util.ClassUtil;
import org.granite.util.URIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaAbstractType
implements JavaType {
    protected final JavaTypeFactory provider;
    protected final Class<?> type;
    protected final URL url;
    protected final As3Type as3Type;
    private long lastModified = Long.MIN_VALUE;

    protected JavaAbstractType(JavaTypeFactory provider, Class<?> type, URL url) {
        if (provider == null || type == null) {
            throw new IllegalArgumentException("Parameter provider and type cannot be null");
        }
        this.provider = provider;
        this.type = type;
        this.url = url;
        this.as3Type = provider.getAs3Type(type);
    }

    protected JavaTypeFactory getProvider() {
        return this.provider;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        if (this.type.isMemberClass()) {
            return String.valueOf(this.type.getEnclosingClass().getSimpleName()) + '$' + this.type.getSimpleName();
        }
        return this.type.getSimpleName();
    }

    @Override
    public Package getPackage() {
        return this.type.getPackage();
    }

    @Override
    public String getPackageName() {
        return this.type.getPackage() != null ? this.type.getPackage().getName() : "";
    }

    public String getQualifiedName() {
        if (this.type.getPackage() == null) {
            return this.getName();
        }
        return this.getPackageName() + '.' + this.getName();
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long getLastModified() {
        if (this.lastModified == Long.MIN_VALUE) {
            try {
                this.lastModified = URIUtil.lastModified(this.url);
            }
            catch (IOException e) {
                this.lastModified = -1L;
            }
        }
        return this.lastModified;
    }

    @Override
    public As3Type getAs3Type() {
        return this.as3Type;
    }

    protected <T extends Collection<?>> T removeNull(T coll) {
        coll.remove(null);
        return coll;
    }

    protected PropertyDescriptor[] getPropertyDescriptors(Class<?> type) {
        PropertyDescriptor[] propertyDescriptors = ClassUtil.getProperties(type);
        return propertyDescriptors != null ? propertyDescriptors : new PropertyDescriptor[]{};
    }

    protected List<JavaProperty> getSortedUnmodifiableList(Collection<JavaProperty> coll) {
        List<Object> list = coll instanceof List ? (List<Object>)coll : new ArrayList<JavaProperty>(coll);
        Collections.sort(list);
        return Collections.unmodifiableList(list);
    }
}

