/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.granite.generator.Configuration;
import org.granite.generator.Input;
import org.granite.generator.Output;
import org.granite.generator.Transformer;
import org.granite.generator.exception.GenerationException;
import org.granite.generator.exception.TransformerNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends ArrayList<Transformer<?, ?, ?>> {
    private static final long serialVersionUID = 1L;
    public static final String VERSION = "1.2.0";
    private Configuration config = null;

    public Generator() {
    }

    public Generator(Configuration config) {
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Output<?>[] generate(Input<?> input) throws IOException, GenerationException {
        this.updateTransformers();
        Transformer transformer = null;
        for (Transformer t : this) {
            if (!t.accept(input)) continue;
            transformer = t;
            break;
        }
        if (transformer == null) {
            throw new TransformerNotFoundException(input);
        }
        return transformer.generate(input);
    }

    protected void updateTransformers() {
        for (Transformer transformer : this) {
            transformer.setConfig(this.config);
        }
    }

    protected boolean checkAdd(Transformer<?, ?, ?> transformer) {
        if (transformer == null) {
            throw new NullPointerException("A transformer cannot be null");
        }
        return !this.contains(transformer);
    }

    @Override
    public void add(int index, Transformer<?, ?, ?> transformer) {
        if (this.checkAdd(transformer)) {
            super.add(index, transformer);
        }
    }

    @Override
    public boolean add(Transformer<?, ?, ?> transformer) {
        if (this.checkAdd(transformer)) {
            return super.add(transformer);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Transformer<?, ?, ?>> transformers) {
        boolean changed = false;
        for (Transformer<?, ?, ?> transformer : transformers) {
            if (!this.checkAdd(transformer)) continue;
            super.add(transformer);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Transformer<?, ?, ?>> transformers) {
        boolean changed = false;
        for (Transformer<?, ?, ?> transformer : transformers) {
            if (!this.checkAdd(transformer)) continue;
            super.add(index++, transformer);
            changed = true;
        }
        return changed;
    }

    @Override
    public Transformer<?, ?, ?> set(int index, Transformer<?, ?, ?> transformer) {
        if (this.checkAdd(transformer)) {
            return super.set(index, transformer);
        }
        return null;
    }
}

