/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.granite.generator.Generator;
import org.granite.generator.TemplateUri;
import org.granite.generator.Transformer;
import org.granite.generator.ant.AntListener;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.DefaultAs3TypeFactory;
import org.granite.generator.as3.JavaAs3GroovyConfiguration;
import org.granite.generator.as3.JavaAs3GroovyTransformer;
import org.granite.generator.as3.JavaAs3Input;
import org.granite.generator.as3.PackageTranslator;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.gsp.GroovyTemplateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntJavaAs3Task
extends Task
implements JavaAs3GroovyConfiguration {
    private String outputdir = ".";
    private String baseoutputdir = null;
    private String uid = "uid";
    private String entitytemplate = null;
    private String entitybasetemplate = null;
    private String beantemplate = null;
    private String beanbasetemplate = null;
    private String interfacetemplate = null;
    private String enumtemplate = null;
    private String as3typefactory = null;
    private boolean tide = false;
    private String transformer = null;
    private Path classpath = null;
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private List<PackageTranslator> translators = new ArrayList<PackageTranslator>();
    private File outputDirFile = null;
    private File baseOutputDirFile = null;
    private As3TypeFactory as3TypeFactoryImpl = null;
    private Transformer<?, ?, ?> transformerImpl = null;
    private GroovyTemplateFactory groovyTemplateFactory = null;
    private TemplateUri[] entityTemplateUris = null;
    private TemplateUri[] interfaceTemplateUris = null;
    private TemplateUri[] beanTemplateUris = null;
    private TemplateUri[] enumTemplateUris = null;
    private Map<Class<?>, File> filesetClasses = null;

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }

    public void setBaseoutputdir(String baseoutputdir) {
        this.baseoutputdir = baseoutputdir;
    }

    public void setAs3typefactory(String as3typefactory) {
        this.as3typefactory = as3typefactory;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setEntitytemplate(String entitytemplate) {
        this.entitytemplate = entitytemplate;
    }

    public void setEntitybasetemplate(String entitybasetemplate) {
        this.entitybasetemplate = entitybasetemplate;
    }

    public void setBeantemplate(String beantemplate) {
        this.beantemplate = beantemplate;
    }

    public void setBeanbasetemplate(String beanbasetemplate) {
        this.beanbasetemplate = beanbasetemplate;
    }

    public void setInterfacetemplate(String interfacetemplate) {
        this.interfacetemplate = interfacetemplate;
    }

    public void setEnumtemplate(String enumtemplate) {
        this.enumtemplate = enumtemplate;
    }

    public void setTide(boolean tide) {
        this.tide = tide;
    }

    public void setTransformer(String transformer) {
        this.transformer = transformer;
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addTranslator(PackageTranslator translator) {
        this.translators.add(translator);
    }

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        this.log("Using output dir: " + this.outputdir, 2);
        this.log("Using classpath: " + this.classpath, 2);
        loader = new AntClassLoader(AntJavaAs3Task.class.getClassLoader(), this.getProject(), this.classpath, true);
        try {
            loader.setThreadContextLoader();
            this.log("Loading all Java classes referenced by inner fileset(s) {", 2);
            this.filesetClasses = new HashMap<Class<?>, File>();
            for (FileSet fileSet : this.fileSets) {
                scanner = fileSet.getDirectoryScanner(this.getProject());
                scanner.setCaseSensitive(true);
                scanner.scan();
                sb = new StringBuilder("    ");
                var10_14 = names = scanner.getIncludedFiles();
                var9_11 = names.length;
                var8_9 = 0;
                while (var8_9 < var9_11) {
                    name = var10_14[var8_9];
                    if (name.endsWith(".class")) {
                        this.log(name, 3);
                        try {
                            jFile = new File(scanner.getBasedir(), name);
                            if (!jFile.exists()) {
                                throw new FileNotFoundException(jFile.toString());
                            }
                            jClassName = name.substring(0, name.length() - 6).replace(File.separatorChar, '.');
                            jClass = loader.loadClass(jClassName);
                            if (jClass.isMemberClass() && !jClass.isEnum()) ** GOTO lbl38
                            sb.setLength(4);
                            sb.append(jClass.toString());
                            this.log(sb.toString(), 2);
                            this.filesetClasses.put(jClass, jFile);
                        }
                        catch (Exception e) {
                            this.log(AntJavaAs3Task.getStackTrace(e));
                            throw new BuildException("Could not load Java class file: " + name, (Throwable)e);
                        }
                    } else {
                        this.log("Skipping non class file: " + name, 1);
                    }
lbl38:
                    // 3 sources

                    ++var8_9;
                }
            }
            this.log("}", 2);
            this.log("Setting up the generator...", 2);
            if (this.as3typefactory == null) {
                this.as3TypeFactoryImpl = new DefaultAs3TypeFactory();
            } else {
                this.log("Instantiating custom As3TypeFactory class: " + this.as3typefactory, 2);
                this.as3TypeFactoryImpl = (As3TypeFactory)this.newInstance((ClassLoader)loader, this.as3typefactory);
            }
            listener = new AntListener(this);
            if (this.transformer == null) {
                this.transformerImpl = new JavaAs3GroovyTransformer();
            } else {
                this.log("Instantiating custom Transformer class: " + this.transformer, 2);
                this.transformerImpl = (Transformer)this.newInstance((ClassLoader)loader, this.transformer);
            }
            this.transformerImpl.setListener(listener);
            baseTemplateUri = null;
            templateUri = "class:org/granite/generator/template/enum.gsp";
            if (this.enumtemplate != null) {
                this.log("Using custom enum template: " + this.enumtemplate, 2);
                templateUri = this.enumtemplate;
            }
            this.enumTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            templateUri = "class:org/granite/generator/template/interface.gsp";
            if (this.interfacetemplate != null) {
                this.log("Using custom interface template: " + this.interfacetemplate, 2);
                templateUri = this.interfacetemplate;
            }
            this.interfaceTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            baseTemplateUri = "class:org/granite/generator/template/entityBase.gsp";
            templateUri = "class:org/granite/generator/template/entity.gsp";
            if (this.entitytemplate != null) {
                this.log("Using custom entity template: " + this.entitytemplate, 2);
                templateUri = this.entitytemplate;
            }
            if (this.entitybasetemplate != null) {
                this.log("Using custom entity base template: " + this.entitybasetemplate, 2);
                baseTemplateUri = this.entitybasetemplate;
            } else if (this.tide) {
                this.log("Using tide entity base template.", 2);
                baseTemplateUri = "class:org/granite/generator/template/tideEntityBase.gsp";
            }
            this.entityTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            baseTemplateUri = "class:org/granite/generator/template/beanBase.gsp";
            templateUri = "class:org/granite/generator/template/bean.gsp";
            if (this.beantemplate != null) {
                this.log("Using custom bean template: " + this.beantemplate, 2);
                templateUri = this.beantemplate;
            }
            if (this.beanbasetemplate != null) {
                this.log("Using custom bean base template: " + this.beanbasetemplate, 2);
                baseTemplateUri = this.beanbasetemplate;
            }
            this.beanTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            generator = new Generator(this);
            generator.add(this.transformerImpl);
            this.log("Calling the generator for each Java class {", 2);
            count = 0;
            for (Map.Entry<Class<?>, File> classFile : this.filesetClasses.entrySet()) {
                try {
                    input = new JavaAs3Input(classFile.getKey(), classFile.getValue());
                    var13_20 = generator.generate(input);
                    var12_19 = var13_20.length;
                    var11_17 = 0;
                    while (var11_17 < var12_19) {
                        output = var13_20[var11_17];
                        if (output.isOutdated()) {
                            ++count;
                        }
                        ++var11_17;
                    }
                }
                catch (Exception e) {
                    this.log(AntJavaAs3Task.getStackTrace(e));
                    throw new BuildException("Could not generate AS3 beans for: " + classFile.getKey(), (Throwable)e);
                }
            }
            this.log("}", 2);
            this.log("Files affected: " + count + (count == 0 ? " (nothing to do)." : "."));
        }
        finally {
            loader.resetThreadContextLoader();
        }
    }

    @Override
    public As3TypeFactory getAs3TypeFactory() {
        return this.as3TypeFactoryImpl;
    }

    @Override
    public File getBaseOutputDir(JavaAs3Input input) {
        if (this.baseOutputDirFile == null) {
            this.baseOutputDirFile = new File(this.baseoutputdir != null ? this.baseoutputdir : this.outputdir);
        }
        return this.baseOutputDirFile;
    }

    @Override
    public File getOutputDir(JavaAs3Input input) {
        if (this.outputDirFile == null) {
            this.outputDirFile = new File(this.outputdir);
        }
        return this.outputDirFile;
    }

    @Override
    public TemplateUri[] getTemplateUris(JavaType.Kind kind, Class<?> clazz) {
        switch (kind) {
            case ENTITY: {
                return this.entityTemplateUris;
            }
            case INTERFACE: {
                return this.interfaceTemplateUris;
            }
            case ENUM: {
                return this.enumTemplateUris;
            }
            case BEAN: {
                return this.beanTemplateUris;
            }
        }
        throw new IllegalArgumentException("Unknown template kind: " + (Object)((Object)kind) + " / " + clazz);
    }

    @Override
    public List<PackageTranslator> getTranslators() {
        return this.translators;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public boolean isGenerated(Class<?> clazz) {
        return this.filesetClasses.containsKey(clazz);
    }

    @Override
    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public GroovyTemplateFactory getGroovyTemplateFactory() {
        if (this.groovyTemplateFactory == null) {
            this.groovyTemplateFactory = new GroovyTemplateFactory();
        }
        return this.groovyTemplateFactory;
    }

    private <T> T newInstance(ClassLoader loader, String className) {
        try {
            return (T)loader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            this.log(AntJavaAs3Task.getStackTrace(e));
            throw new BuildException("Could not instantiate custom class: " + className, (Throwable)e);
        }
    }

    private static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private TemplateUri[] createTemplateUris(String baseUri, String uri) {
        TemplateUri[] templateUris = new TemplateUri[baseUri == null ? 1 : 2];
        int i = 0;
        if (baseUri != null) {
            templateUris[i++] = new TemplateUri(baseUri, true);
        }
        templateUris[i] = new TemplateUri(uri, false);
        return templateUris;
    }
}

