/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.reflect.Method;
import org.granite.generator.as3.reflect.JavaMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod
extends JavaMember<Method> {
    private final boolean override;
    private final MethodType type;

    public JavaMethod(Method method, MethodType type) {
        super(method);
        boolean override = false;
        Class<?> superclass = method.getDeclaringClass().getSuperclass();
        while (superclass != null) {
            try {
                Method superMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                if (superMethod.getReturnType() == method.getReturnType()) {
                    override = true;
                    break;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            superclass = superclass.getSuperclass();
        }
        this.override = override;
        this.type = type;
    }

    public boolean isOverride() {
        return this.override;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        GETTER,
        SETTER,
        OTHER;

    }
}

