/*
  GRANITE DATA SERVICES
  Copyright (C) 2007-2008 ADEQUATE SYSTEMS SARL

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 3 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 	Entity reflection for converting validation annotations to Flex
 */
public class JavaValidatableEntityBean extends JavaEntityBean {

	private Map<JavaProperty, List<JavaConstraint>> constraints = new HashMap<JavaProperty, List<JavaConstraint>>();

	
    public JavaValidatableEntityBean(JavaTypeFactory provider, Class<?> type, URL url, String metaAnnotationName) {
        super(provider, type, url);
        
        // Collect validation annotations
        for (JavaProperty property : properties.values()) {
        	List<JavaConstraint> list = new ArrayList<JavaConstraint>();
        	
        	Annotation[] annos = property.getDeclaredAnnotations();
        	for (Annotation anno : annos) {
        		Annotation[] constraintAnnotations = null;
        		
        		for (Annotation a : anno.annotationType().getDeclaredAnnotations()) {
        			if (a.annotationType().getName().equals(metaAnnotationName)) {
        				constraintAnnotations = new Annotation[] { anno };
        				break;
        			}
        		}
        		if (constraintAnnotations == null && anno.annotationType().isMemberClass()) {
            		for (Annotation a : anno.annotationType().getEnclosingClass().getDeclaredAnnotations()) {
            			if (a.annotationType().getName().equals(metaAnnotationName)) {
            				try {
            					constraintAnnotations = (Annotation[])anno.annotationType().getMethod("value").invoke(anno);
            				}
            				catch (Exception e) {
            					// Ignore: probably not a constraint list
            				}
            				break;
            			}
            		}
        		}
        		if (constraintAnnotations == null)
        			continue;
        		
        		for (Annotation canno : constraintAnnotations) {
	        		List<String[]> c = new ArrayList<String[]>();
	        		for (Method m : canno.annotationType().getMethods()) {
	        			if (m.getDeclaringClass() == Object.class || m.getDeclaringClass() == Annotation.class)
	        				continue;
	        			if (m.getParameterTypes() != null && m.getParameterTypes().length > 0)
	        				continue;
	        			try {
		        			Object value = m.invoke(canno);
		        			if (value == null || value.equals("") || (value.getClass().isArray() && Array.getLength(value) == 0))
		        				continue;
		        			if (value.getClass().isArray()) {
		        				for (int i = 0; i < Array.getLength(value); i++) {
		        					Object v = Array.get(value, i);
		        					if (v instanceof Class<?>)
		        						c.add(new String[] { m.getName(), ((Class<?>)v).getName() });
		        					else if (v != null)
		        						c.add(new String[] { m.getName(), v.toString() });
		        				}
		        			}
		        			else if (value instanceof Class<?>)
        						c.add(new String[] { m.getName(), ((Class<?>)value).getName() });
		        			else
        						c.add(new String[] { m.getName(), value.toString() });
	        			}
	        			catch (Exception e) {
	        			}
	        		}
	        		list.add(new JavaConstraint(canno.annotationType().getSimpleName(), c));
        		}
        	}
        	if (!list.isEmpty())
        		constraints.put(property, list);
        }
    }
    
    public Map<JavaProperty, List<JavaConstraint>> getConstraints() {
    	return constraints;
    }
}
