/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.granite.generator.as3.reflect.JavaAbstractType;
import org.granite.generator.as3.reflect.JavaImport;
import org.granite.generator.as3.reflect.JavaInterface;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.service.annotations.IgnoredMethod;
import org.granite.messaging.service.annotations.RemoteDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaRemoteDestination
extends JavaAbstractType {
    protected final Set<JavaImport> imports = new HashSet<JavaImport>();
    protected final JavaType superclass;
    protected final List<JavaMethod> methods;
    protected final String destinationName;
    protected final String channelName;

    public JavaRemoteDestination(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        this.superclass = provider.getJavaTypeSuperclass(type);
        this.methods = Collections.unmodifiableList(this.initMethods());
        if (this.superclass != null) {
            this.addToImports(provider.getJavaImport(this.superclass.getType()));
        }
        this.destinationName = type.getAnnotation(RemoteDestination.class).id();
        this.channelName = type.getAnnotation(RemoteDestination.class).channel();
    }

    public Set<JavaImport> getImports() {
        return this.imports;
    }

    protected void addToImports(JavaImport javaImport) {
        if (javaImport != null) {
            this.imports.add(javaImport);
        }
    }

    public boolean hasSuperclass() {
        return this.superclass != null;
    }

    public JavaType getSuperclass() {
        return this.superclass;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.type.isAnnotationPresent(annotation);
    }

    protected List<JavaMethod> initMethods() {
        ArrayList<JavaMethod> methodMap = new ArrayList<JavaMethod>();
        Method[] methods = null;
        methods = this.type.isInterface() ? this.type.getMethods() : this.type.getDeclaredMethods();
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(IgnoredMethod.class)) continue;
            for (Class<?> clazz : method.getParameterTypes()) {
                if (clazz.isMemberClass() && !clazz.isEnum()) {
                    throw new UnsupportedOperationException("Inner classes are not supported (except enums): " + clazz);
                }
                this.addToImports(this.provider.getJavaImport(clazz));
            }
            methodMap.add(new JavaMethod(method, JavaMethod.MethodType.OTHER, this.provider));
        }
        return methodMap;
    }

    public JavaInterface convertToJavaInterface() {
        return new JavaInterface(this.getProvider(), this.getType(), this.getUrl());
    }
}

