/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaAbstractType;
import org.granite.generator.as3.reflect.JavaFieldProperty;
import org.granite.generator.as3.reflect.JavaImport;
import org.granite.generator.as3.reflect.JavaInterface;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaMethodProperty;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.granite.messaging.amf.io.util.externalizer.annotation.IgnoredProperty;
import org.granite.tide.annotations.TideEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBean
extends JavaAbstractType {
    protected final Set<JavaImport> imports = new HashSet<JavaImport>();
    protected final JavaType superclass;
    protected final As3Type as3Superclass;
    protected final List<JavaInterface> interfaces;
    protected final List<JavaProperty> interfacesProperties;
    protected final SortedMap<String, JavaProperty> properties;
    protected final JavaProperty uid;

    public JavaBean(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        this.superclass = provider.getJavaTypeSuperclass(type);
        this.as3Superclass = this.superclass == null && type.isAnnotationPresent(TideEvent.class) ? new As3Type("org.granite.tide.events", "AbstractTideEvent") : null;
        this.interfaces = Collections.unmodifiableList(provider.getJavaTypeInterfaces(type));
        this.properties = Collections.unmodifiableSortedMap(this.initProperties());
        HashMap<String, JavaProperty> allProperties = new HashMap<String, JavaProperty>(this.properties);
        JavaType supertype = this.superclass;
        while (supertype instanceof JavaBean) {
            allProperties.putAll(((JavaBean)supertype).properties);
            supertype = ((JavaBean)supertype).superclass;
        }
        HashMap<String, JavaProperty> iPropertyMap = new HashMap<String, JavaProperty>();
        for (JavaInterface interfaze : this.interfaces) {
            for (JavaProperty property : interfaze.getProperties()) {
                String name = property.getName();
                if (iPropertyMap.containsKey(name) || allProperties.containsKey(name)) continue;
                iPropertyMap.put(name, property);
            }
        }
        this.interfacesProperties = this.getSortedUnmodifiableList(iPropertyMap.values());
        JavaProperty tmpUid = null;
        for (JavaProperty property : this.properties.values()) {
            if (!provider.isUid(property)) continue;
            tmpUid = property;
            break;
        }
        this.uid = tmpUid;
        if (this.superclass != null) {
            this.addToImports(provider.getJavaImport(this.superclass.getType()));
        }
        for (JavaInterface interfaze : this.interfaces) {
            this.addToImports(provider.getJavaImport(interfaze.getType()));
        }
        for (JavaProperty property : this.properties.values()) {
            this.addToImports(provider.getJavaImport(property.getType()));
        }
    }

    public Set<JavaImport> getImports() {
        return this.imports;
    }

    protected void addToImports(JavaImport javaImport) {
        if (javaImport != null) {
            this.imports.add(javaImport);
        }
    }

    public boolean hasSuperclass() {
        return this.superclass != null;
    }

    public JavaType getSuperclass() {
        return this.superclass;
    }

    public As3Type getAs3Superclass() {
        return this.as3Superclass;
    }

    public boolean hasInterfaces() {
        return this.interfaces != null && !this.interfaces.isEmpty();
    }

    public List<JavaInterface> getInterfaces() {
        return this.interfaces;
    }

    public boolean hasInterfacesProperties() {
        return this.interfacesProperties != null && !this.interfacesProperties.isEmpty();
    }

    public List<JavaProperty> getInterfacesProperties() {
        return this.interfacesProperties;
    }

    public Collection<JavaProperty> getProperties() {
        return this.properties.values();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.type.isAnnotationPresent(annotation);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public JavaProperty getUid() {
        return this.uid;
    }

    public boolean hasEnumProperty() {
        for (JavaProperty property : this.properties.values()) {
            if (!property.isEnum()) continue;
            return true;
        }
        return false;
    }

    protected SortedMap<String, JavaProperty> initProperties() {
        PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors(this.type);
        TreeMap<String, JavaProperty> propertyMap = new TreeMap<String, JavaProperty>();
        Object[] objectArray = this.type.getDeclaredFields();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = objectArray[n2];
            if (!(Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || "jdoDetachedState".equals(field.getName()) || field.isAnnotationPresent(IgnoredProperty.class))) {
                String name = field.getName();
                JavaMethod readMethod = null;
                JavaMethod writeMethod = null;
                if (field.getType().isMemberClass() && !field.getType().isEnum()) {
                    throw new UnsupportedOperationException("Inner classes are not supported (except enums): " + field.getType());
                }
                if (propertyDescriptors != null) {
                    PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
                    int n3 = propertyDescriptors.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n4];
                        if (name.equals(propertyDescriptor.getName())) {
                            if (propertyDescriptor.getReadMethod() != null) {
                                readMethod = new JavaMethod(propertyDescriptor.getReadMethod(), JavaMethod.MethodType.GETTER);
                            }
                            if (propertyDescriptor.getWriteMethod() == null) break;
                            writeMethod = new JavaMethod(propertyDescriptor.getWriteMethod(), JavaMethod.MethodType.SETTER);
                            break;
                        }
                        ++n4;
                    }
                }
                JavaFieldProperty property = new JavaFieldProperty(this.provider, field, readMethod, writeMethod);
                propertyMap.put(name, property);
            }
            ++n2;
        }
        if (propertyDescriptors != null) {
            objectArray = propertyDescriptors;
            n = propertyDescriptors.length;
            n2 = 0;
            while (n2 < n) {
                Object propertyDescriptor = objectArray[n2];
                if (((PropertyDescriptor)propertyDescriptor).getReadMethod() != null && ((PropertyDescriptor)propertyDescriptor).getReadMethod().getDeclaringClass().equals(this.type) && ((PropertyDescriptor)propertyDescriptor).getReadMethod().isAnnotationPresent(ExternalizedProperty.class) && !propertyMap.containsKey(((FeatureDescriptor)propertyDescriptor).getName())) {
                    JavaMethod readMethod = new JavaMethod(((PropertyDescriptor)propertyDescriptor).getReadMethod(), JavaMethod.MethodType.GETTER);
                    JavaMethodProperty property = new JavaMethodProperty(this.provider, ((FeatureDescriptor)propertyDescriptor).getName(), readMethod, null);
                    propertyMap.put(((FeatureDescriptor)propertyDescriptor).getName(), property);
                }
                ++n2;
            }
        }
        return propertyMap;
    }
}

