/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.ant;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class ClassSelector
extends BaseExtendSelector {
    Class<? extends Annotation>[] annotations = null;
    Class<?>[] superclasses = null;
    Class<?>[] classes = null;

    private void initializeParameters() throws BuildException {
        this.log("init...");
        if (this.annotations == null) {
            ArrayList annotationsList = new ArrayList();
            ArrayList superclassesList = new ArrayList();
            ArrayList classesList = new ArrayList();
            Parameter[] parameterArray = this.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                if ("annotatedwith".equalsIgnoreCase(parameter.getName())) {
                    try {
                        Class<?> annotation = Thread.currentThread().getContextClassLoader().loadClass(parameter.getValue());
                        annotationsList.add(annotation);
                    }
                    catch (Exception e) {
                        throw new BuildException("Could not load annotation: " + parameter.getValue());
                    }
                } else if ("instanceof".equalsIgnoreCase(parameter.getName())) {
                    try {
                        Class<?> superclass = Thread.currentThread().getContextClassLoader().loadClass(parameter.getValue());
                        superclassesList.add(superclass);
                    }
                    catch (Exception e) {
                        throw new BuildException("Could not load superclass: " + parameter.getValue());
                    }
                } else if ("type".equalsIgnoreCase(parameter.getName())) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(parameter.getValue());
                        classesList.add(clazz);
                    }
                    catch (Exception e) {
                        throw new BuildException("Could not load type: " + parameter.getValue());
                    }
                } else {
                    throw new BuildException("Illegal param name: " + parameter.getName());
                }
                ++n2;
            }
            this.annotations = annotationsList.toArray(new Class[annotationsList.size()]);
            this.superclasses = superclassesList.toArray(new Class[superclassesList.size()]);
            this.classes = classesList.toArray(new Class[classesList.size()]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelected(File basedir, String fileName, File file) throws BuildException {
        this.initializeParameters();
        this.log(fileName);
        if (!fileName.endsWith(".class")) {
            return false;
        }
        String className = fileName.substring(0, fileName.length() - 6).replace(File.separatorChar, '.');
        try {
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(className);
            Class<Object>[] classArray = this.classes;
            int n = this.classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                if (clazz.equals(type)) {
                    return true;
                }
                ++n2;
            }
            classArray = this.superclasses;
            n = this.superclasses.length;
            n2 = 0;
            while (n2 < n) {
                Class<?> superclass = classArray[n2];
                if (superclass.isAssignableFrom(type)) {
                    return true;
                }
                ++n2;
            }
            classArray = this.annotations;
            n = this.annotations.length;
            n2 = 0;
            while (n2 < n) {
                Class<Object> annotation = classArray[n2];
                if (type.isAnnotationPresent(annotation)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception e) {
            throw new BuildException("Could not load class: " + className, (Throwable)e);
        }
    }
}

