<%--
  GRANITE DATA SERVICES
  Copyright (C) 2011 GRANITE DATA SERVICES S.A.S.

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License
  for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.

  @author Franck WOLFF
--%><%
    Set as3Imports = new TreeSet();

    as3Imports.add("mx.messaging.ChannelSet");
    as3Imports.add("mx.messaging.config.ServerConfig");

    if (!jClass.hasSuperclass())
        as3Imports.add("mx.rpc.remoting.mxml.RemoteObject");
    

    for (jImport in jClass.imports) {
        if (jImport.as3Type.hasPackage() && jImport.as3Type.packageName != jClass.as3Type.packageName)
            as3Imports.add(jImport.as3Type.qualifiedName);
    }

%>/**
 * Generated by Gas3 v${gVersion} (Granite Data Services).
 *
 * WARNING: DO NOT CHANGE THIS FILE. IT MAY BE OVERWRITTEN EACH TIME YOU USE
 * THE GENERATOR. INSTEAD, EDIT THE INHERITED CLASS (${jClass.as3Type.name}.as).
 */

package ${jClass.as3Type.packageName} {
<%
///////////////////////////////////////////////////////////////////////////////
// Write Import Statements.

    for (as3Import in as3Imports) {%>
    import ${as3Import};<%
    }

///////////////////////////////////////////////////////////////////////////////
// Write Class Declaration.%>

    public class ${jClass.as3Type.name}Base<%

        if (jClass.hasSuperclass()) {
            %> extends ${jClass.superclass.as3Type.name}<%
        } else {
            %> extends RemoteObject<%
        }

    %> {<%

///////////////////////////////////////////////////////////////////////////
// Write private "initialized?" flag declaration.%>

        private var _initRemote:Boolean = false;<%

///////////////////////////////////////////////////////////////////////////
// Initializator. (was: C'tor.)%>

        private function initRemote():void {
            destination = "${jClass.destinationName}";
            channelSet = new ChannelSet();
            channelSet.addChannel(ServerConfig.getChannel("${jClass.channelId}"));
            _initRemote = true;    
        }<%

///////////////////////////////////////////////////////////////////////////
// Write Methods.
    
    for (jMethod in jClass.methods) {%>

        public function ${jMethod.name}(<%
            String[] names = jMethod.getAs3ParameterNames();
            int count = 0;
            for (pType in jMethod.getAs3ParameterTypes()) {
                if (count > 0) {
                    %>, <%
                }
                %>${names[count]}:${pType.name}<%
                count++;
            }
            count = 0;
            %>):void {
            if (!_initRemote)
                initRemote();
            getOperation("${jMethod.name}").send(<%
                for (pType in jMethod.getAs3ParameterTypes()) {
                    if (count > 0) {
                        %>, <%
                    }
                    %>${names[count]}<%
                    count += 1;
                }
            %>);
        }<%
    }

///////////////////////////////////////////////////////////////////////////
// Write Result/Fail event managers.%>

        public function addOperationListener(op:Function, type:String, handler:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false):void {<%
        
        for (jMethod in jClass.methods) {%>
            if (op == this.${jMethod.name}) 
                this.getOperation("${jMethod.name}").addEventListener(type, handler, useCapture, priority, useWeakReference);<%
        }%>
        }

        public function removeOperationListener(op:Function, event:String, handler:Function):void {<% 
        for (jMethod in jClass.methods) {%>
            if (op == this.${jMethod.name}) 
                this.getOperation("${jMethod.name}").removeEventListener(event, handler);<%
        }%>
        }
    }
}