/*
  GRANITE DATA SERVICES
  Copyright (C) 2011 GRANITE DATA SERVICES S.A.S.

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License
  for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

package org.granite.generator.gsp;

import java.net.URI;

import org.granite.generator.Input;
import org.granite.generator.Listener;
import org.granite.generator.Output;
import org.granite.generator.TemplateUri;
import org.granite.generator.Transformer;
import org.granite.generator.exception.TemplateUriException;
import org.granite.util.URIUtil;

/**
 * @author Franck WOLFF
 */
public abstract class AbstractGroovyTransformer<I extends Input<?>, O extends Output<?>, C extends GroovyConfiguration>
	extends Transformer<I, O, C> {

	public AbstractGroovyTransformer() {
		super();
	}

	public AbstractGroovyTransformer(GroovyConfiguration config, Listener listener) {
		super(config, listener);
	}

	protected GroovyTemplateFactory getTemplateFactory() {
		return getConfig().getGroovyTemplateFactory();
	}

    protected GroovyTemplate getTemplate(TemplateUri templateUri) throws TemplateUriException {
    	return getTemplate(templateUri.getUri(), templateUri.isBase());
    }

    protected GroovyTemplate getTemplate(String uri, boolean base) throws TemplateUriException {
    	GroovyTemplateFactory factory = getTemplateFactory();
        try {
        	uri = URIUtil.normalize(uri);
            return factory.getTemplate(new URI(uri), base);
        } catch (Exception e) {
            throw new TemplateUriException(uri, e);
        }
    }
}
