/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaMember;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.service.annotations.Param;
import org.granite.tide.data.Lazy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod
extends JavaMember<Method> {
    private final String name;
    private final boolean override;
    private final MethodType type;
    private final String options;
    private final Class<?>[] parameterTypes;
    private final As3Type[] as3ParameterTypes;
    private final String[] as3ParameterNames;
    private final String[] as3ParameterOptions;

    public JavaMethod(Method method, MethodType type) {
        this(method, type, null);
    }

    public JavaMethod(Method method, MethodType type, JavaTypeFactory provider) {
        boolean override;
        block15: {
            super(method);
            Class objectClass = Object.class;
            try {
                objectClass = method.getDeclaringClass().getClassLoader().loadClass(Object.class.getCanonicalName());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.name = method.getName();
            Class<?> superclass = method.getDeclaringClass().getSuperclass();
            override = false;
            if (superclass != null && superclass != objectClass) {
                try {
                    Method superMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                    if (superMethod.getDeclaringClass().isInterface()) {
                        override = superMethod.getDeclaringClass().isAssignableFrom(superclass);
                        break block15;
                    }
                    for (Class<?> sc = superMethod.getDeclaringClass(); sc != null; sc = sc.getSuperclass()) {
                        for (Class<?> interfaze : sc.getInterfaces()) {
                            try {
                                interfaze.getMethod(method.getName(), method.getParameterTypes());
                                override = true;
                                break;
                            }
                            catch (NoSuchMethodException e) {
                            }
                        }
                        if (!override) {
                            continue;
                        }
                        break;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        this.override = override;
        this.type = type;
        this.options = method.isAnnotationPresent(Lazy.class) ? "Lazy" : null;
        if (type == MethodType.OTHER && provider != null) {
            this.parameterTypes = method.getParameterTypes();
            this.as3ParameterTypes = new As3Type[this.parameterTypes.length];
            this.as3ParameterNames = new String[this.parameterTypes.length];
            this.as3ParameterOptions = new String[this.parameterTypes.length];
            block8: for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.as3ParameterNames[i] = this.getParamName(method, i);
                this.as3ParameterTypes[i] = Map.class.isAssignableFrom(this.parameterTypes[i]) ? As3Type.OBJECT : provider.getAs3Type(this.parameterTypes[i]);
                Annotation[] annotations = method.getParameterAnnotations()[i];
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(Lazy.class)) continue;
                    this.as3ParameterOptions[i] = "Lazy";
                    continue block8;
                }
            }
        } else {
            this.parameterTypes = null;
            this.as3ParameterTypes = null;
            this.as3ParameterNames = null;
            this.as3ParameterOptions = null;
        }
    }

    private String getParamName(Method method, int paramIndex) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations != null && annotations.length > paramIndex && annotations[paramIndex] != null) {
            for (Annotation annotation : annotations[paramIndex]) {
                if (!annotation.annotationType().equals(Param.class)) continue;
                return ((Param)annotation).value();
            }
        }
        return "arg" + paramIndex;
    }

    public boolean isOverride() {
        return this.override;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getOptions() {
        return this.options;
    }

    public String getTypeName() {
        return this.type.name();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public As3Type[] getAs3ParameterTypes() {
        return this.as3ParameterTypes;
    }

    public String[] getAs3ParameterNames() {
        return this.as3ParameterNames;
    }

    public String[] getAs3ParameterOptions() {
        return this.as3ParameterOptions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        GETTER,
        SETTER,
        OTHER;

    }
}

