/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.ant;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class ClassSelector
extends BaseExtendSelector {
    Class<? extends Annotation>[] annotations = null;
    Class<?>[] superclasses = null;
    Class<?>[] classes = null;

    private void initializeParameters() throws BuildException {
        this.log("init...");
        if (this.annotations == null) {
            ArrayList annotationsList = new ArrayList();
            ArrayList superclassesList = new ArrayList();
            ArrayList classesList = new ArrayList();
            for (Parameter parameter : this.getParameters()) {
                if ("annotatedwith".equalsIgnoreCase(parameter.getName())) {
                    try {
                        Class<?> annotation = Thread.currentThread().getContextClassLoader().loadClass(parameter.getValue());
                        annotationsList.add(annotation);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BuildException("Could not load annotation: " + parameter.getValue());
                    }
                }
                if ("instanceof".equalsIgnoreCase(parameter.getName())) {
                    try {
                        Class<?> superclass = Thread.currentThread().getContextClassLoader().loadClass(parameter.getValue());
                        superclassesList.add(superclass);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BuildException("Could not load superclass: " + parameter.getValue());
                    }
                }
                if ("type".equalsIgnoreCase(parameter.getName())) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(parameter.getValue());
                        classesList.add(clazz);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BuildException("Could not load type: " + parameter.getValue());
                    }
                }
                throw new BuildException("Illegal param name: " + parameter.getName());
            }
            this.annotations = annotationsList.toArray(new Class[annotationsList.size()]);
            this.superclasses = superclassesList.toArray(new Class[superclassesList.size()]);
            this.classes = classesList.toArray(new Class[classesList.size()]);
        }
    }

    public boolean isSelected(File basedir, String fileName, File file) throws BuildException {
        this.initializeParameters();
        this.log(fileName);
        if (!fileName.endsWith(".class")) {
            return false;
        }
        String className = fileName.substring(0, fileName.length() - 6).replace(File.separatorChar, '.');
        try {
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(className);
            for (Class<?> clazz : this.classes) {
                if (!clazz.equals(type)) continue;
                return true;
            }
            for (Class<?> clazz : this.superclasses) {
                if (!clazz.isAssignableFrom(type)) continue;
                return true;
            }
            for (Class<Object> clazz : this.annotations) {
                if (!type.isAnnotationPresent(clazz)) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new BuildException("Could not load class: " + className, (Throwable)e);
        }
        return false;
    }
}

