/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.gsp;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.granite.generator.Template;
import org.granite.generator.exception.TemplateCompilationException;
import org.granite.generator.exception.TemplateExecutionException;
import org.granite.generator.exception.TemplateParsingException;
import org.granite.generator.gsp.GroovyRenderer;
import org.granite.generator.gsp.ParseException;
import org.granite.generator.gsp.Parser;
import org.granite.generator.gsp.token.Token;
import org.granite.util.URIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyTemplate
implements Template {
    private final URI uri;
    private final boolean base;
    private final Charset charset;
    private String source = null;
    private Script script = null;
    private long lastModified = -1L;

    GroovyTemplate(URI uri, boolean base, Charset charset) {
        if (uri == null || charset == null) {
            throw new IllegalArgumentException("uri and charset cannot be null");
        }
        this.uri = uri;
        this.base = base;
        this.charset = charset;
    }

    protected void reset(boolean cleanSource) {
        if (cleanSource) {
            this.source = null;
        }
        this.script = null;
        this.lastModified = -1L;
    }

    protected void reset() {
        this.reset(true);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected long readLastModified() {
        long readLastModified = -1L;
        if ("file".equals(this.uri.getScheme())) {
            readLastModified = new File(this.uri).lastModified();
            if (readLastModified == 0L) {
                readLastModified = -1L;
            }
        } else {
            readLastModified = Long.MAX_VALUE;
        }
        return readLastModified;
    }

    public boolean isOutdated() {
        long newLastModified = this.readLastModified();
        return this.script != null && (newLastModified == -1L || this.lastModified < newLastModified);
    }

    @Override
    public boolean isBase() {
        return this.base;
    }

    @Override
    public String getMarkup() {
        try {
            return URIUtil.getContentAsString((URI)this.uri);
        }
        catch (Exception e) {
            return "Could not load uri content: " + this.uri + " (" + e.toString() + ")";
        }
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void compile() throws IOException, TemplateParsingException, TemplateCompilationException {
        this.reset();
        InputStream is = null;
        try {
            is = URIUtil.getInputStream((URI)this.uri, (ClassLoader)this.getClass().getClassLoader());
            this.lastModified = this.readLastModified();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, this.charset));
            Parser parser = new Parser();
            List<Token> tokens = parser.parse(reader);
            GroovyRenderer renderer = new GroovyRenderer();
            this.source = renderer.renderSource(tokens);
            GroovyShell shell = new GroovyShell(Thread.currentThread().getContextClassLoader());
            this.script = shell.parse(this.source);
        }
        catch (ParseException e) {
            throw new TemplateParsingException(this, "Could not parse template: " + this.uri, e);
        }
        catch (CompilationFailedException e) {
            throw new TemplateCompilationException(this, "Could not compile template: " + this.uri, e);
        }
        finally {
            if (this.script == null) {
                this.reset(false);
            }
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void execute(Map<String, Object> bindings, Writer out) throws IOException, TemplateParsingException, TemplateCompilationException, TemplateExecutionException {
        if (this.script == null) {
            this.compile();
        }
        try {
            Binding binding = bindings == null ? new Binding() : new Binding(bindings);
            Script scriptInstance = InvokerHelper.createScript(this.script.getClass(), (Binding)binding);
            scriptInstance.setProperty("out", (Object)out);
            scriptInstance.run();
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateExecutionException(this, "Could not execute template: " + this.uri, e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroovyTemplate)) {
            return false;
        }
        return this.uri.equals(((GroovyTemplate)obj).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

