/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3;

import java.util.Collections;
import java.util.Set;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PackageTranslator;

public class As3Type
implements ClientType {
    public static final As3Type INT = new As3Type(null, "int", 0);
    public static final As3Type UINT = new As3Type(null, "uint", 0);
    public static final As3Type BOOLEAN = new As3Type(null, "Boolean", false);
    public static final As3Type NUMBER = new As3Type(null, "Number", "Number.NaN");
    public static final As3Type LONG = new As3Type("org.granite.math", "Long");
    public static final As3Type BIG_INTEGER = new As3Type("org.granite.math", "BigInteger");
    public static final As3Type BIG_DECIMAL = new As3Type("org.granite.math", "BigDecimal");
    public static final As3Type MATH_CONTEXT = new As3Type("org.granite.math", "MathContext");
    public static final As3Type ROUNDING_MODE = new As3Type("org.granite.math", "RoundingMode");
    public static final As3Type OBJECT = new As3Type(null, "Object");
    public static final As3Type STRING = new As3Type(null, "String");
    public static final As3Type ARRAY = new As3Type(null, "Array");
    public static final As3Type DATE = new As3Type(null, "Date");
    public static final As3Type XML = new As3Type(null, "XML");
    public static final As3Type BYTE_ARRAY = new As3Type("flash.utils", "ByteArray");
    public static final As3Type DICTIONARY = new As3Type("flash.utils", "Dictionary");
    public static final As3Type LIST_COLLECTION_VIEW = new As3Type("mx.collections", "ListCollectionView");
    public static final As3Type ARRAY_COLLECTION = new As3Type("mx.collections", "ArrayCollection");
    public static final As3Type ILIST = new As3Type("mx.collections", "IList");
    public static final As3Type IMAP = new As3Type("org.granite.collections", "IMap");
    public static final As3Type ENUM = new As3Type("org.granite.util", "Enum");
    public static final As3Type PAGE = new As3Type("org.granite.tide.data.model", "Page");
    public static final As3Type PAGE_INFO = new As3Type("org.granite.tide.data.model", "PageInfo");
    public static final As3Type SORT_INFO = new As3Type("org.granite.tide.data.model", "SortInfo");
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final Object nullValue;

    public As3Type(String packageName, String simpleName) {
        this(packageName, simpleName, null);
    }

    public As3Type(String packageName, String name, Object nullValue) {
        this.packageName = packageName != null ? packageName : "";
        this.name = name;
        this.qualifiedName = this.hasPackage() ? packageName + '.' + name : name;
        this.nullValue = nullValue;
    }

    @Override
    public boolean hasPackage() {
        return this.packageName.length() > 0;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Object getNullValue() {
        return this.nullValue;
    }

    public boolean isNumber() {
        return NUMBER.equals(this);
    }

    @Override
    public Set<String> getImports() {
        if (this.hasPackage()) {
            return Collections.singleton(this.qualifiedName);
        }
        return Collections.emptySet();
    }

    @Override
    public As3Type toArrayType() {
        return ARRAY;
    }

    @Override
    public As3Type translatePackage(PackageTranslator translator) {
        return new As3Type(translator.translate(this.packageName), this.getName());
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof As3Type)) {
            return false;
        }
        return this.qualifiedName.equals(((As3Type)obj).qualifiedName);
    }

    public String toString() {
        return this.qualifiedName;
    }
}

