/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3;

import java.util.List;

public class PackageTranslator {
    private String java = null;
    private String as3 = null;
    private int weight = -1;

    public PackageTranslator() {
    }

    public PackageTranslator(String java, String as3) {
        this.setJava(java);
        this.setAs3(as3);
    }

    public String getJava() {
        return this.java;
    }

    public void setJava(String java) {
        this.java = java;
        this.weight = java != null ? java.split("\\Q.\\E", -1).length : -1;
    }

    public String getAs3() {
        return this.as3;
    }

    public void setAs3(String as3) {
        this.as3 = as3;
    }

    public String getClient() {
        return this.as3;
    }

    public void setClient(String client) {
        this.as3 = client;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isValid() {
        return this.java != null && this.java.length() > 0 && this.as3 != null && this.as3.length() > 0;
    }

    public int match(String pkg) {
        if (!pkg.startsWith(this.java)) {
            return 0;
        }
        if (pkg.equals(this.java)) {
            return Integer.MAX_VALUE;
        }
        return this.weight;
    }

    public String translate(String pkg) {
        return this.as3 + pkg.substring(this.java.length());
    }

    public static PackageTranslator forPackage(List<PackageTranslator> translators, String packageName) {
        PackageTranslator translator = null;
        int weight = 0;
        for (PackageTranslator t : translators) {
            int w = t.match(packageName);
            if (w <= weight) continue;
            weight = w;
            translator = t;
        }
        return translator;
    }

    public int hashCode() {
        return this.java != null ? this.java.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageTranslator)) {
            return false;
        }
        return this.java == null ? ((PackageTranslator)o).java == null : this.java.equals(((PackageTranslator)o).java);
    }

    public String toString() {
        return this.getClass().getName() + "{java=\"" + this.java + "\", as=\"" + this.as3 + "\"}";
    }
}

