/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.reflect.JavaMember;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.generator.util.GenericTypeUtil;
import org.granite.messaging.service.annotations.Param;
import org.granite.tide.data.Lazy;
import org.granite.util.ClassUtil;

public class JavaMethod
extends JavaMember<Method> {
    private final String name;
    private final boolean override;
    private final MethodType type;
    private final String options;
    private final Class<?> returnType;
    private final Class<?>[] parameterTypes;
    private final ClientType clientReturnType;
    private final ClientType[] clientParameterTypes;
    private final String[] clientParameterNames;
    private final String[] clientParameterOptions;

    public JavaMethod(Method method, MethodType type) {
        this(method, type, null, null);
    }

    public JavaMethod(Method method, MethodType type, JavaTypeFactory provider) {
        this(method, type, provider, null);
    }

    public JavaMethod(Method method, MethodType type, JavaTypeFactory provider, ParameterizedType[] declaringTypes) {
        boolean override;
        block21: {
            super(method);
            Class objectClass = Object.class;
            try {
                objectClass = method.getDeclaringClass().getClassLoader().loadClass(Object.class.getCanonicalName());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.name = method.getName();
            Class<?> superclass = method.getDeclaringClass().getSuperclass();
            override = false;
            if (superclass != null && superclass != objectClass) {
                try {
                    Method superMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                    if (superMethod.getDeclaringClass().isInterface()) {
                        override = superMethod.getDeclaringClass().isAssignableFrom(superclass);
                        break block21;
                    }
                    for (Class<?> sc = superMethod.getDeclaringClass(); sc != null; sc = sc.getSuperclass()) {
                        for (Class<?> interfaze : sc.getInterfaces()) {
                            try {
                                interfaze.getMethod(method.getName(), method.getParameterTypes());
                                override = true;
                                break;
                            }
                            catch (NoSuchMethodException e) {
                            }
                        }
                        if (!override) {
                            continue;
                        }
                        break;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        this.override = override;
        this.type = type;
        this.options = method.isAnnotationPresent(Lazy.class) ? "Lazy" : null;
        if (type == MethodType.OTHER && provider != null) {
            if (method.getReturnType() == Void.TYPE) {
                this.returnType = Void.class;
                this.clientReturnType = provider.getClientType((Type)((Object)Void.class), null, null, false);
            } else {
                Type genericType = GenericTypeUtil.resolveTypeVariable(method.getGenericReturnType(), method.getDeclaringClass(), declaringTypes);
                genericType = GenericTypeUtil.primitiveToWrapperType(genericType);
                this.returnType = ClassUtil.classOfType(genericType);
                ClientType returnType = provider.getClientType(genericType, method.getDeclaringClass(), declaringTypes, false);
                if (returnType == null) {
                    returnType = provider.getAs3Type(this.returnType);
                }
                this.clientReturnType = returnType;
            }
            this.parameterTypes = method.getParameterTypes();
            this.clientParameterTypes = new ClientType[this.parameterTypes.length];
            this.clientParameterNames = new String[this.parameterTypes.length];
            this.clientParameterOptions = new String[this.parameterTypes.length];
            block8: for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.clientParameterNames[i] = this.getParamName(method, i);
                if (Map.class.isAssignableFrom(this.parameterTypes[i])) {
                    this.clientParameterTypes[i] = provider.getClientType((Type)((Object)Object.class), null, null, false);
                } else {
                    Type genericType = GenericTypeUtil.resolveTypeVariable(method.getGenericParameterTypes()[i], method.getDeclaringClass(), declaringTypes);
                    this.parameterTypes[i] = ClassUtil.classOfType(genericType);
                    ClientType paramType = provider.getClientType(genericType, method.getDeclaringClass(), declaringTypes, false);
                    if (paramType == null) {
                        paramType = provider.getAs3Type(this.parameterTypes[i]);
                    }
                    this.clientParameterTypes[i] = paramType;
                }
                Annotation[] annotations = method.getParameterAnnotations()[i];
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(Lazy.class)) continue;
                    this.clientParameterOptions[i] = "Lazy";
                    continue block8;
                }
            }
        } else {
            this.returnType = null;
            this.parameterTypes = null;
            this.clientReturnType = null;
            this.clientParameterTypes = null;
            this.clientParameterNames = null;
            this.clientParameterOptions = null;
        }
    }

    private String getParamName(Method method, int paramIndex) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations != null && annotations.length > paramIndex && annotations[paramIndex] != null) {
            for (Annotation annotation : annotations[paramIndex]) {
                if (!annotation.annotationType().equals(Param.class)) continue;
                return ((Param)annotation).value();
            }
        }
        return "arg" + paramIndex;
    }

    public boolean isOverride() {
        return this.override;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getOptions() {
        return this.options;
    }

    public String getTypeName() {
        return this.type.name();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ClientType[] getAs3ParameterTypes() {
        return this.clientParameterTypes;
    }

    public String[] getAs3ParameterNames() {
        return this.clientParameterNames;
    }

    public String[] getAs3ParameterOptions() {
        return this.clientParameterOptions;
    }

    public ClientType getClientReturnType() {
        return this.clientReturnType;
    }

    public ClientType[] getClientParameterTypes() {
        return this.clientParameterTypes;
    }

    public String[] getClientParameterNames() {
        return this.clientParameterNames;
    }

    public String[] getClientParameterOptions() {
        return this.clientParameterOptions;
    }

    public static enum MethodType {
        GETTER,
        SETTER,
        OTHER;

    }
}

