/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.granite.util.ClassUtil;

public class JavaMethodProperty
implements JavaProperty {
    private final String name;
    private final JavaMethod readMethod;
    private final JavaMethod writeMethod;
    private final Class<?> type;
    private final Type genericType;
    private final ClientType clientType;
    private final boolean externalizedProperty;

    public JavaMethodProperty(JavaTypeFactory provider, String name, JavaMethod readMethod, JavaMethod writeMethod) {
        this(provider, name, readMethod, writeMethod, null);
    }

    public JavaMethodProperty(JavaTypeFactory provider, String name, JavaMethod readMethod, JavaMethod writeMethod, ParameterizedType declaringType) {
        Class<?> declaringClass;
        if (name == null || readMethod == null && writeMethod == null) {
            throw new NullPointerException("Invalid parameters");
        }
        this.name = name;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        Type genericType = readMethod != null ? ((Method)readMethod.getMember()).getGenericReturnType() : ((Method)writeMethod.getMember()).getGenericParameterTypes()[0];
        Class<?> clazz = declaringClass = readMethod != null ? ((Method)readMethod.getMember()).getDeclaringClass() : ((Method)writeMethod.getMember()).getDeclaringClass();
        if (genericType instanceof TypeVariable && declaringType != null) {
            int index = -1;
            for (int i = 0; i < declaringClass.getTypeParameters().length; ++i) {
                if (declaringClass.getTypeParameters()[i] != genericType) continue;
                index = i;
                break;
            }
            if (index >= 0 && index < declaringType.getActualTypeArguments().length) {
                genericType = declaringType.getActualTypeArguments()[index];
            }
        }
        this.type = ClassUtil.classOfType(genericType);
        this.genericType = genericType;
        ClientType clientType = provider.getClientType(genericType, null, null, true);
        if (clientType == null) {
            clientType = provider.getAs3Type(this.type);
        }
        this.clientType = clientType;
        this.externalizedProperty = readMethod != null && ClassUtil.isAnnotationPresent((AnnotatedElement)readMethod.getMember(), ExternalizedProperty.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCapitalizedName() {
        return this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public Type[] getGenericTypes() {
        Type type;
        Type type2 = type = this.readMethod != null ? ((Method)this.readMethod.getMember()).getGenericReturnType() : ((Method)this.writeMethod.getMember()).getGenericParameterTypes()[0];
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    @Override
    public boolean isReadable() {
        return this.readMethod != null;
    }

    @Override
    public boolean isWritable() {
        return this.writeMethod != null;
    }

    @Override
    public boolean isExternalizedProperty() {
        return this.externalizedProperty;
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum() || Enum.class.getName().equals(this.type.getName());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.readMethod != null && ((Method)this.readMethod.getMember()).isAnnotationPresent(annotationClass) || this.writeMethod != null && ((Method)this.writeMethod.getMember()).isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = null;
        if (this.readMethod != null && (annotation = (T)((Method)this.readMethod.getMember()).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        if (this.writeMethod != null && (annotation = (T)((Method)this.writeMethod.getMember()).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        ArrayList<Annotation> annos = new ArrayList<Annotation>();
        if (this.readMethod != null) {
            annos.addAll(Arrays.asList(((Method)this.readMethod.getMember()).getDeclaredAnnotations()));
        }
        if (this.writeMethod != null) {
            annos.addAll(Arrays.asList(((Method)this.writeMethod.getMember()).getDeclaredAnnotations()));
        }
        return annos.toArray(new Annotation[0]);
    }

    @Override
    public boolean isReadOverride() {
        return this.readMethod != null && this.readMethod.isOverride();
    }

    @Override
    public boolean isWriteOverride() {
        return this.writeMethod != null && this.writeMethod.isOverride();
    }

    @Override
    public JavaMethod getReadMethod() {
        return this.readMethod;
    }

    @Override
    public JavaMethod getWriteMethod() {
        return this.writeMethod;
    }

    public ClientType getAs3Type() {
        return this.clientType;
    }

    @Override
    public ClientType getClientType() {
        return this.clientType;
    }

    @Override
    public int compareTo(JavaProperty o) {
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JavaMethodProperty) {
            return ((JavaMethodProperty)obj).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

