/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.javafx;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.ClientType;
import org.granite.generator.javafx.JavaFXType;
import org.granite.generator.util.GenericTypeUtil;
import org.granite.util.ClassUtil;

public class DefaultJavaFXTypeFactory
implements As3TypeFactory {
    private final Map<Type, ClientType> simpleJava2JavaFXType = new HashMap<Type, ClientType>();
    private final Map<Type, ClientType> propertyJava2JavaFXType = new HashMap<Type, ClientType>();

    public DefaultJavaFXTypeFactory() {
        this.simpleJava2JavaFXType.put(Boolean.TYPE, JavaFXType.BOOLEAN);
        this.simpleJava2JavaFXType.put(Integer.TYPE, JavaFXType.INT);
        this.simpleJava2JavaFXType.put(Long.TYPE, JavaFXType.LONG);
        this.simpleJava2JavaFXType.put(Float.TYPE, JavaFXType.FLOAT);
        this.simpleJava2JavaFXType.put(Double.TYPE, JavaFXType.DOUBLE);
        this.simpleJava2JavaFXType.put((Type)((Object)String.class), JavaFXType.STRING);
        this.propertyJava2JavaFXType.put(Boolean.TYPE, JavaFXType.BOOLEAN_PROPERTY);
        this.propertyJava2JavaFXType.put(Double.TYPE, JavaFXType.DOUBLE_PROPERTY);
        this.propertyJava2JavaFXType.put(Float.TYPE, JavaFXType.FLOAT_PROPERTY);
        this.propertyJava2JavaFXType.put(Long.TYPE, JavaFXType.LONG_PROPERTY);
        this.propertyJava2JavaFXType.put(Integer.TYPE, JavaFXType.INT_PROPERTY);
        this.propertyJava2JavaFXType.put((Type)((Object)String.class), JavaFXType.STRING_PROPERTY);
    }

    @Override
    public void configure(boolean externalizeLong, boolean externalizeBigInteger, boolean externalizeBigDecimal) {
    }

    @Override
    public ClientType getClientType(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes, boolean property) {
        ClientType javafxType = this.getFromCache(jType, property);
        if (javafxType == null) {
            if (jType instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)jType).getGenericComponentType();
                javafxType = this.getClientType(componentType, declaringClass, declaringTypes, false).toArrayType();
            } else if (jType instanceof Class && ((Class)jType).isArray()) {
                javafxType = this.getClientType(((Class)jType).getComponentType(), declaringClass, declaringTypes, false).toArrayType();
            } else {
                Class<?> jClass = ClassUtil.classOfType(jType);
                String genericType = "";
                if (jType instanceof ParameterizedType) {
                    for (Type t : ((ParameterizedType)jType).getActualTypeArguments()) {
                        if (genericType.length() > 0) {
                            genericType = genericType + ", ";
                        }
                        genericType = genericType + ClassUtil.classOfType(t).getSimpleName();
                    }
                    genericType = "<" + genericType + ">";
                }
                javafxType = property && List.class.isAssignableFrom(jClass) ? new JavaFXType("javafx.collections", "ObservableList" + genericType, null, "org.granite.client.persistence.javafx.PersistentList" + genericType, null) : (property && Set.class.isAssignableFrom(jClass) ? new JavaFXType("javafx.collections", "ObservableList" + genericType, null, "org.granite.client.persistence.javafx.PersistentSet" + genericType, null) : (property && Map.class.isAssignableFrom(jClass) ? new JavaFXType("javafx.collections", "ObservableMap" + genericType, null, "org.granite.client.persistence.javafx.PersistentMap" + genericType, null) : (jClass.getName().equals("com.google.appengine.api.datastore.Key") ? JavaFXType.STRING : (jClass.getName().equals("org.springframework.data.domain.Page") ? new JavaFXType("org.granite.tide.data.model", "Page" + genericType, null) : (jClass.getName().equals("org.springframework.data.domain.Pageable") ? JavaFXType.PAGE_INFO : (jClass.getName().equals("org.springframework.data.domain.Sort") ? JavaFXType.SORT_INFO : this.createJavaFXType(jType, declaringClass, declaringTypes, property)))))));
            }
            this.putInCache(jType, property, javafxType);
        }
        return javafxType;
    }

    @Override
    public ClientType getAs3Type(Class<?> jType) {
        return this.getClientType(jType, null, null, false);
    }

    protected JavaFXType createJavaFXType(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes, boolean property) {
        Class<?> jClass = ClassUtil.classOfType(jType);
        String name = jClass.getSimpleName();
        if (jClass.isMemberClass()) {
            name = jClass.getEnclosingClass().getSimpleName() + '$' + jClass.getSimpleName();
        } else if (jType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)jType;
            name = name + "<";
            boolean first = true;
            for (Type ata : type.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    name = name + ", ";
                }
                if (ata instanceof TypeVariable) {
                    Type resolved = GenericTypeUtil.resolveTypeVariable(ata, declaringClass, declaringTypes);
                    if (resolved instanceof TypeVariable) {
                        name = name + "?";
                        continue;
                    }
                    name = name + ClassUtil.classOfType(resolved).getSimpleName();
                    continue;
                }
                if (ata instanceof WildcardType) {
                    Type resolved;
                    String bounds;
                    name = name + "?";
                    if (((WildcardType)ata).getLowerBounds().length > 0) {
                        bounds = "";
                        for (Type t : ((WildcardType)ata).getLowerBounds()) {
                            resolved = GenericTypeUtil.resolveTypeVariable(t, declaringClass, declaringTypes);
                            if (resolved instanceof TypeVariable) {
                                bounds = "";
                                break;
                            }
                            if (bounds.length() > 0) {
                                bounds = bounds + ", ";
                            }
                            bounds = bounds + ClassUtil.classOfType(resolved).getSimpleName();
                        }
                        if (bounds.length() > 0) {
                            name = name + " super " + bounds;
                        }
                    }
                    if (((WildcardType)ata).getUpperBounds().length <= 0) continue;
                    bounds = "";
                    for (Type t : ((WildcardType)ata).getUpperBounds()) {
                        resolved = GenericTypeUtil.resolveTypeVariable(t, declaringClass, declaringTypes);
                        if (resolved instanceof TypeVariable) {
                            bounds = "";
                            break;
                        }
                        if (bounds.length() > 0) {
                            bounds = bounds + ", ";
                        }
                        bounds = bounds + ClassUtil.classOfType(resolved).getSimpleName();
                    }
                    if (bounds.length() <= 0) continue;
                    name = name + " extends " + bounds;
                    continue;
                }
                name = name + ClassUtil.classOfType(ata).getSimpleName();
            }
            name = name + ">";
        }
        if (property) {
            return new JavaFXType(ClassUtil.getPackageName(jClass), name, "javafx.beans.property.ObjectProperty<" + name + ">", "javafx.beans.property.SimpleObjectProperty<" + name + ">", null);
        }
        return new JavaFXType(ClassUtil.getPackageName(jClass), name, null);
    }

    protected ClientType getFromCache(Type jType, boolean property) {
        if (jType == null) {
            throw new NullPointerException("jType must be non null");
        }
        if (property) {
            return this.propertyJava2JavaFXType.get(jType);
        }
        return this.simpleJava2JavaFXType.get(jType);
    }

    protected void putInCache(Type jType, boolean property, ClientType javafxType) {
        if (jType == null || javafxType == null) {
            throw new NullPointerException("jType and JavaFXType must be non null");
        }
        if (property) {
            this.propertyJava2JavaFXType.put(jType, javafxType);
        } else {
            this.simpleJava2JavaFXType.put(jType, javafxType);
        }
    }
}

