/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.javafx;

import java.util.HashSet;
import java.util.Set;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PackageTranslator;

public class JavaFXType
implements ClientType {
    public static final JavaFXType BOOLEAN = new JavaFXType(null, "boolean", false);
    public static final JavaFXType INT = new JavaFXType(null, "int", 0);
    public static final JavaFXType LONG = new JavaFXType(null, "long", 0L);
    public static final JavaFXType FLOAT = new JavaFXType(null, "float", Float.valueOf(0.0f));
    public static final JavaFXType DOUBLE = new JavaFXType(null, "double", 0.0);
    public static final JavaFXType STRING = new JavaFXType(null, "String", null);
    public static final JavaFXType PAGE_INFO = new JavaFXType("org.granite.tide.data.model", "PageInfo", null);
    public static final JavaFXType SORT_INFO = new JavaFXType("org.granite.tide.data.model", "SortInfo", null);
    public static final JavaFXType BOOLEAN_PROPERTY = new JavaFXType(null, "boolean", "javafx.beans.property.BooleanProperty", "javafx.beans.property.SimpleBooleanProperty", Boolean.FALSE);
    public static final JavaFXType INT_PROPERTY = new JavaFXType(null, "int", "javafx.beans.property.IntegerProperty", "javafx.beans.property.SimpleIntegerProperty", 0);
    public static final JavaFXType LONG_PROPERTY = new JavaFXType(null, "long", "javafx.beans.property.LongProperty", "javafx.beans.property.SimpleLongProperty", 0L);
    public static final JavaFXType FLOAT_PROPERTY = new JavaFXType(null, "float", "javafx.beans.property.FloatProperty", "javafx.beans.property.SimpleFloatProperty", Float.valueOf(0.0f));
    public static final JavaFXType DOUBLE_PROPERTY = new JavaFXType(null, "double", "javafx.beans.property.DoubleProperty", "javafx.beans.property.SimpleDoubleProperty", 0.0);
    public static final JavaFXType STRING_PROPERTY = new JavaFXType(null, "String", "javafx.beans.property.StringProperty", "javafx.beans.property.SimpleStringProperty", null);
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final String propertyTypeName;
    private final String propertyImplTypeName;
    private final Object nullValue;

    public JavaFXType(String packageName, String simpleName) {
        this(packageName, simpleName, null);
    }

    public JavaFXType(String packageName, String name, Object nullValue) {
        this(packageName, name, null, null, nullValue);
    }

    public JavaFXType(String packageName, String name, String propertyTypeName, String propertyImplTypeName, Object nullValue) {
        this.packageName = packageName != null ? packageName : "";
        this.name = name;
        this.qualifiedName = this.hasPackage() ? packageName + '.' + name : name;
        this.nullValue = nullValue;
        this.propertyTypeName = propertyTypeName;
        this.propertyImplTypeName = propertyImplTypeName;
    }

    @Override
    public boolean hasPackage() {
        return this.packageName.length() > 0;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getPropertyTypeName() {
        return this.propertyTypeName;
    }

    public String getSimplePropertyTypeName() {
        return this.propertyTypeName != null && this.propertyTypeName.indexOf(".") >= 0 ? this.propertyTypeName.substring(this.propertyTypeName.lastIndexOf(".") + 1) : this.propertyTypeName;
    }

    public String getPropertyImplTypeName() {
        return this.propertyImplTypeName;
    }

    public String getSimplePropertyImplTypeName() {
        return this.propertyImplTypeName != null && this.propertyImplTypeName.indexOf(".") >= 0 ? this.propertyImplTypeName.substring(this.propertyImplTypeName.lastIndexOf(".") + 1) : this.propertyImplTypeName;
    }

    @Override
    public Object getNullValue() {
        return this.nullValue;
    }

    public boolean isNumber() {
        return false;
    }

    @Override
    public Set<String> getImports() {
        HashSet<String> imports = new HashSet<String>();
        if (this.hasPackage()) {
            imports.add(this.ungenerify(this.qualifiedName));
        }
        if (this.propertyTypeName != null) {
            imports.add(this.ungenerify(this.propertyTypeName));
        }
        if (this.propertyImplTypeName != null) {
            imports.add(this.ungenerify(this.propertyImplTypeName));
        }
        return imports;
    }

    private String ungenerify(String className) {
        if (className.indexOf("<") >= 0) {
            return className.substring(0, className.indexOf("<"));
        }
        return className;
    }

    @Override
    public JavaFXType toArrayType() {
        return new JavaFXType(this.packageName, this.name + "[]", null);
    }

    @Override
    public JavaFXType translatePackage(PackageTranslator translator) {
        return new JavaFXType(translator.translate(this.packageName), this.getName(), this.getPropertyTypeName(), this.getPropertyImplTypeName(), this.getNullValue());
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JavaFXType)) {
            return false;
        }
        return this.qualifiedName.equals(((JavaFXType)obj).qualifiedName);
    }

    public String toString() {
        return this.qualifiedName;
    }
}

