/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PropertyType;
import org.granite.util.ClassUtil;
import org.w3c.dom.Document;

public class DefaultAs3TypeFactory
implements As3TypeFactory {
    private final Map<Class<?>, As3Type> java2As3Type = new HashMap();

    public DefaultAs3TypeFactory() {
        this.java2As3Type.put(Double.class, As3Type.NUMBER);
        this.java2As3Type.put(Double.TYPE, As3Type.NUMBER);
        this.java2As3Type.put(Float.class, As3Type.NUMBER);
        this.java2As3Type.put(Float.TYPE, As3Type.NUMBER);
        this.java2As3Type.put(Long.class, As3Type.NUMBER);
        this.java2As3Type.put(Long.TYPE, As3Type.NUMBER);
        this.java2As3Type.put(Integer.class, As3Type.NUMBER);
        this.java2As3Type.put(Integer.TYPE, As3Type.INT);
        this.java2As3Type.put(Short.class, As3Type.NUMBER);
        this.java2As3Type.put(Short.TYPE, As3Type.INT);
        this.java2As3Type.put(Byte.class, As3Type.NUMBER);
        this.java2As3Type.put(Byte.TYPE, As3Type.INT);
        this.java2As3Type.put(MathContext.class, As3Type.MATH_CONTEXT);
        this.java2As3Type.put(RoundingMode.class, As3Type.ROUNDING_MODE);
        this.java2As3Type.put(Boolean.class, As3Type.BOOLEAN);
        this.java2As3Type.put(Boolean.TYPE, As3Type.BOOLEAN);
        this.java2As3Type.put(String.class, As3Type.STRING);
        this.java2As3Type.put(Character.class, As3Type.STRING);
        this.java2As3Type.put(Character.TYPE, As3Type.STRING);
        this.java2As3Type.put(Locale.class, As3Type.STRING);
        this.java2As3Type.put(URL.class, As3Type.STRING);
        this.java2As3Type.put(URI.class, As3Type.STRING);
        this.java2As3Type.put(Object.class, As3Type.OBJECT);
        this.java2As3Type.put(Serializable.class, As3Type.OBJECT);
        this.java2As3Type.put(Enum.class, As3Type.ENUM);
    }

    @Override
    public void configure(boolean externalizeLong, boolean externalizeBigInteger, boolean externalizeBigDecimal) {
        if (externalizeLong) {
            this.java2As3Type.put(Long.class, As3Type.LONG);
            this.java2As3Type.put(Long.TYPE, As3Type.LONG);
        }
        if (externalizeBigInteger) {
            this.java2As3Type.put(BigInteger.class, As3Type.BIG_INTEGER);
        }
        if (externalizeBigDecimal) {
            this.java2As3Type.put(BigDecimal.class, As3Type.BIG_DECIMAL);
        }
    }

    @Override
    public ClientType getClientType(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes, PropertyType propertyType) {
        return null;
    }

    @Override
    public ClientType getAs3Type(Class<?> jType) {
        As3Type as3Type = this.getFromCache(jType);
        if (as3Type == null) {
            Class<?> componentType;
            as3Type = Date.class.isAssignableFrom(jType) || Calendar.class.isAssignableFrom(jType) ? As3Type.DATE : (Number.class.isAssignableFrom(jType) ? As3Type.NUMBER : (Document.class.isAssignableFrom(jType) ? As3Type.XML : (jType.isArray() ? (Byte.class.equals(componentType = jType.getComponentType()) || Byte.TYPE.equals(componentType) ? As3Type.BYTE_ARRAY : (Character.class.equals(componentType) || Character.TYPE.equals(componentType) ? As3Type.STRING : As3Type.ARRAY)) : (Collection.class.isAssignableFrom(jType) ? As3Type.LIST_COLLECTION_VIEW : (Iterable.class.isAssignableFrom(jType) ? As3Type.ILIST : (Map.class.isAssignableFrom(jType) ? As3Type.IMAP : (jType.getName().equals("com.google.appengine.api.datastore.Key") ? As3Type.STRING : (jType.getName().equals("org.springframework.data.domain.Page") ? As3Type.PAGE : (jType.getName().equals("org.springframework.data.domain.Pageable") ? As3Type.PAGE_INFO : (jType.getName().equals("org.springframework.data.domain.Sort") ? As3Type.SORT_INFO : this.createAs3Type(jType)))))))))));
            this.putInCache(jType, as3Type);
        }
        return as3Type;
    }

    protected As3Type createAs3Type(Class<?> jType) {
        String name = jType.getSimpleName();
        if (jType.isMemberClass()) {
            name = jType.getEnclosingClass().getSimpleName() + '$' + jType.getSimpleName();
        }
        return new As3Type(ClassUtil.getPackageName(jType), name);
    }

    protected As3Type getFromCache(Class<?> jType) {
        if (jType == null) {
            throw new NullPointerException("jType must be non null");
        }
        return this.java2As3Type.get(jType);
    }

    protected void putInCache(Class<?> jType, As3Type as3Type) {
        if (jType == null || as3Type == null) {
            throw new NullPointerException("jType and as3Type must be non null");
        }
        this.java2As3Type.put(jType, as3Type);
    }
}

