/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.gsp;

import java.util.List;
import org.granite.generator.gsp.Renderer;
import org.granite.generator.gsp.token.Comment;
import org.granite.generator.gsp.token.Expression;
import org.granite.generator.gsp.token.Scriplet;
import org.granite.generator.gsp.token.TemplateText;
import org.granite.generator.gsp.token.Token;

public class GroovyRenderer
implements Renderer {
    private String source = null;

    @Override
    public String renderSource(List<Token> tokens) {
        return this.renderSource(tokens, null);
    }

    @Override
    public String renderSource(List<Token> tokens, String out) {
        StringBuilder sb = new StringBuilder(1024);
        for (Token token : tokens) {
            if (token instanceof TemplateText) {
                String content = token.getContent();
                if (content.length() <= 0) continue;
                int iLast = content.length() - 1;
                sb.append("print(\"");
                block7: for (int i = 0; i < content.length(); ++i) {
                    char c = content.charAt(i);
                    switch (c) {
                        case '\\': {
                            sb.append("\\\\");
                            continue block7;
                        }
                        case '\"': {
                            sb.append("\\\"");
                            continue block7;
                        }
                        case '\n': {
                            sb.append("\\n\");\n");
                            if (i >= iLast) continue block7;
                            sb.append("print(\"");
                            continue block7;
                        }
                        case '\f': {
                            sb.append("\\f");
                            continue block7;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                if (content.charAt(iLast) == '\n') continue;
                sb.append("\");\n");
                continue;
            }
            if (token instanceof Expression) {
                sb.append("print(").append(token.getContent()).append(");\n");
                continue;
            }
            if (token instanceof Scriplet) {
                sb.append(token.getContent()).append('\n');
                continue;
            }
            if (token instanceof Comment) continue;
            throw new UnsupportedOperationException("Unsupported token (not implemented): " + token);
        }
        this.source = sb.toString();
        return this.source;
    }

    @Override
    public String getSource() {
        return this.source;
    }
}

