/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.javafx;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PropertyType;
import org.granite.generator.javafx.JavaFXType;
import org.granite.generator.util.GenericTypeUtil;
import org.granite.util.ClassUtil;

public class DefaultJavaFXTypeFactory
implements As3TypeFactory {
    private final Map<String, ClientType> simpleJava2JavaFXType = new HashMap<String, ClientType>();
    private final Map<String, ClientType> propertyJava2JavaFXType = new HashMap<String, ClientType>();
    private final Map<String, ClientType> readOnlyPropertyJava2JavaFXType = new HashMap<String, ClientType>();

    public DefaultJavaFXTypeFactory() {
        this.simpleJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Boolean.TYPE), JavaFXType.BOOLEAN);
        this.simpleJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Integer.TYPE), JavaFXType.INT);
        this.simpleJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Long.TYPE), JavaFXType.LONG);
        this.simpleJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Float.TYPE), JavaFXType.FLOAT);
        this.simpleJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Double.TYPE), JavaFXType.DOUBLE);
        this.simpleJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(String.class), JavaFXType.STRING);
        this.propertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Boolean.TYPE), JavaFXType.BOOLEAN_PROPERTY);
        this.propertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Double.TYPE), JavaFXType.DOUBLE_PROPERTY);
        this.propertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Float.TYPE), JavaFXType.FLOAT_PROPERTY);
        this.propertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Long.TYPE), JavaFXType.LONG_PROPERTY);
        this.propertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Integer.TYPE), JavaFXType.INT_PROPERTY);
        this.propertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(String.class), JavaFXType.STRING_PROPERTY);
        this.readOnlyPropertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Boolean.TYPE), JavaFXType.BOOLEAN_READONLY_PROPERTY);
        this.readOnlyPropertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Double.TYPE), JavaFXType.DOUBLE_READONLY_PROPERTY);
        this.readOnlyPropertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Float.TYPE), JavaFXType.FLOAT_READONLY_PROPERTY);
        this.readOnlyPropertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Long.TYPE), JavaFXType.LONG_READONLY_PROPERTY);
        this.readOnlyPropertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(Integer.TYPE), JavaFXType.INT_READONLY_PROPERTY);
        this.readOnlyPropertyJava2JavaFXType.put(DefaultJavaFXTypeFactory.buildCacheKey(String.class), JavaFXType.STRING_READONLY_PROPERTY);
    }

    @Override
    public void configure(boolean externalizeLong, boolean externalizeBigInteger, boolean externalizeBigDecimal) {
    }

    private static final String buildCacheKey(Type jType) {
        return DefaultJavaFXTypeFactory.buildCacheKey(jType, null, null);
    }

    private static final String buildCacheKey(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes) {
        String key = jType.toString();
        if (declaringClass != null) {
            key = key + "::" + declaringClass.toString();
        }
        if (declaringTypes != null) {
            for (ParameterizedType dt : declaringTypes) {
                key = key + "::" + dt.toString();
            }
        }
        return key;
    }

    @Override
    public ClientType getClientType(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes, PropertyType propertyType) {
        String key = DefaultJavaFXTypeFactory.buildCacheKey(jType, declaringClass, declaringTypes);
        ClientType javafxType = this.getFromCache(key, propertyType);
        if (javafxType == null) {
            if (jType instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)jType).getGenericComponentType();
                javafxType = this.getClientType(componentType, declaringClass, declaringTypes, PropertyType.SIMPLE).toArrayType();
            } else if (jType instanceof Class && ((Class)jType).isArray()) {
                javafxType = this.getClientType(((Class)jType).getComponentType(), declaringClass, declaringTypes, PropertyType.SIMPLE).toArrayType();
            } else {
                HashSet<String> imports = new HashSet<String>();
                Class<?> jClass = ClassUtil.classOfType(jType);
                String genericType = "";
                if (jType instanceof ParameterizedType) {
                    genericType = this.buildGenericTypeName((ParameterizedType)jType, declaringClass, declaringTypes, propertyType, imports);
                }
                if (propertyType.isProperty() && List.class.isAssignableFrom(jClass)) {
                    imports.add("org.granite.client.javafx.persistence.collection.FXPersistentCollections");
                    javafxType = new JavaFXType("javafx.collections", "ObservableList" + genericType, "javafx.beans.property.ReadOnlyListProperty" + genericType, "javafx.beans.property.ReadOnlyListWrapper" + genericType, "FXPersistentCollections.readOnlyObservablePersistentList", null, true);
                } else if (propertyType.isProperty() && SortedSet.class.isAssignableFrom(jClass)) {
                    imports.add("org.granite.client.javafx.persistence.collection.FXPersistentCollections");
                    javafxType = new JavaFXType("javafx.collections", "ObservableSet" + genericType, "javafx.beans.property.ReadOnlySetProperty" + genericType, "javafx.beans.property.ReadOnlySetWrapper" + genericType, "FXPersistentCollections.readOnlyObservablePersistentSortedSet", null, true);
                } else if (propertyType.isProperty() && Set.class.isAssignableFrom(jClass)) {
                    imports.add("org.granite.client.javafx.persistence.collection.FXPersistentCollections");
                    javafxType = new JavaFXType("javafx.collections", "ObservableSet" + genericType, "javafx.beans.property.ReadOnlySetProperty" + genericType, "javafx.beans.property.ReadOnlySetWrapper" + genericType, "FXPersistentCollections.readOnlyObservablePersistentSet", null, true);
                } else if (propertyType.isProperty() && SortedMap.class.isAssignableFrom(jClass)) {
                    imports.add("org.granite.client.javafx.persistence.collection.FXPersistentCollections");
                    javafxType = new JavaFXType("javafx.collections", "ObservableMap" + genericType, "javafx.beans.property.ReadOnlyMapProperty" + genericType, "javafx.beans.property.ReadOnlyMapWrapper" + genericType, "FXPersistentCollections.readOnlyObservablePersistentSortedMap", null, true);
                } else if (propertyType.isProperty() && Map.class.isAssignableFrom(jClass)) {
                    imports.add("org.granite.client.javafx.persistence.collection.FXPersistentCollections");
                    javafxType = new JavaFXType("javafx.collections", "ObservableMap" + genericType, "javafx.beans.property.ReadOnlyMapProperty" + genericType, "javafx.beans.property.ReadOnlyMapWrapper" + genericType, "FXPersistentCollections.readOnlyObservablePersistentMap", null, true);
                } else {
                    javafxType = jClass.getName().equals("com.google.appengine.api.datastore.Key") ? JavaFXType.STRING : (jClass.getName().equals("org.springframework.data.domain.Page") ? new JavaFXType("org.granite.tide.data.model", "Page" + genericType, null) : (jClass.getName().equals("org.springframework.data.domain.Pageable") ? JavaFXType.PAGE_INFO : (jClass.getName().equals("org.springframework.data.domain.Sort") ? JavaFXType.SORT_INFO : this.createJavaFXType(jType, declaringClass, declaringTypes, propertyType))));
                }
                if (!imports.isEmpty()) {
                    javafxType.addImports(imports);
                }
            }
            this.putInCache(key, propertyType, javafxType);
        }
        return javafxType;
    }

    @Override
    public ClientType getAs3Type(Class<?> jType) {
        return this.getClientType(jType, null, null, PropertyType.SIMPLE);
    }

    protected JavaFXType createJavaFXType(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes, PropertyType propertyType) {
        HashSet<String> imports = new HashSet<String>();
        Class<?> jClass = ClassUtil.classOfType(jType);
        String name = jClass.getSimpleName();
        if (jClass.isMemberClass()) {
            name = jClass.getEnclosingClass().getSimpleName() + '$' + jClass.getSimpleName();
        } else if (jType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)jType;
            name = name + this.buildGenericTypeName(type, declaringClass, declaringTypes, propertyType, imports);
        }
        JavaFXType javaFXType = null;
        javaFXType = propertyType == PropertyType.PROPERTY ? new JavaFXType(ClassUtil.getPackageName(jClass), name, "javafx.beans.property.ObjectProperty<" + name + ">", "javafx.beans.property.SimpleObjectProperty<" + name + ">", null) : (propertyType == PropertyType.READONLY_PROPERTY ? new JavaFXType(ClassUtil.getPackageName(jClass), name, "javafx.beans.property.ReadOnlyObjectProperty<" + name + ">", "javafx.beans.property.ReadOnlyObjectWrapper<" + name + ">", null, null, true) : new JavaFXType(ClassUtil.getPackageName(jClass), name, null));
        javaFXType.addImports(imports);
        return javaFXType;
    }

    protected ClientType getFromCache(String key, PropertyType propertyType) {
        if (key == null) {
            throw new NullPointerException("jType must be non null");
        }
        if (propertyType == PropertyType.PROPERTY) {
            return this.propertyJava2JavaFXType.get(key);
        }
        if (propertyType == PropertyType.READONLY_PROPERTY) {
            return this.readOnlyPropertyJava2JavaFXType.get(key);
        }
        return this.simpleJava2JavaFXType.get(key);
    }

    protected void putInCache(String key, PropertyType propertyType, ClientType javafxType) {
        if (key == null || javafxType == null) {
            throw new NullPointerException("jType and JavaFXType must be non null");
        }
        if (propertyType == PropertyType.PROPERTY) {
            this.propertyJava2JavaFXType.put(key, javafxType);
        } else if (propertyType == PropertyType.READONLY_PROPERTY) {
            this.readOnlyPropertyJava2JavaFXType.put(key, javafxType);
        } else {
            this.simpleJava2JavaFXType.put(key, javafxType);
        }
    }

    private String buildGenericTypeName(ParameterizedType type, Class<?> declaringClass, ParameterizedType[] declaringTypes, PropertyType propertyType, Set<String> imports) {
        StringBuilder sb = new StringBuilder("<");
        boolean first = true;
        for (Type ata : type.getActualTypeArguments()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (ata instanceof TypeVariable) {
                Type resolved = GenericTypeUtil.resolveTypeVariable(ata, declaringClass, declaringTypes);
                if (resolved instanceof TypeVariable) {
                    sb.append("?");
                    continue;
                }
                sb.append(ClassUtil.classOfType(resolved).getSimpleName());
                imports.add(this.getClientType(resolved, declaringClass, declaringTypes, propertyType).getQualifiedName());
                continue;
            }
            if (ata instanceof WildcardType) {
                Type resolved;
                String bounds;
                sb.append("?");
                if (((WildcardType)ata).getLowerBounds().length > 0) {
                    bounds = "";
                    for (Type t : ((WildcardType)ata).getLowerBounds()) {
                        resolved = GenericTypeUtil.resolveTypeVariable(t, declaringClass, declaringTypes);
                        if (resolved instanceof TypeVariable) {
                            bounds = "";
                            break;
                        }
                        if (bounds.length() > 0) {
                            bounds = bounds + ", ";
                        }
                        bounds = bounds + ClassUtil.classOfType(resolved).getSimpleName();
                        imports.add(this.getClientType(resolved, declaringClass, declaringTypes, propertyType).getQualifiedName());
                    }
                    if (bounds.length() > 0) {
                        sb.append(" super ").append(bounds);
                    }
                }
                if (((WildcardType)ata).getUpperBounds().length <= 0) continue;
                bounds = "";
                for (Type t : ((WildcardType)ata).getUpperBounds()) {
                    resolved = GenericTypeUtil.resolveTypeVariable(t, declaringClass, declaringTypes);
                    if (resolved instanceof TypeVariable) {
                        bounds = "";
                        break;
                    }
                    if (bounds.length() > 0) {
                        bounds = bounds + ", ";
                    }
                    bounds = bounds + ClassUtil.classOfType(resolved).getSimpleName();
                    imports.add(this.getClientType(resolved, declaringClass, declaringTypes, propertyType).getQualifiedName());
                }
                if (bounds.length() <= 0) continue;
                sb.append(" extends ").append(bounds);
                continue;
            }
            sb.append(ClassUtil.classOfType(ata).getSimpleName());
            imports.add(this.getClientType(ata, declaringClass, declaringTypes, propertyType).getQualifiedName());
        }
        sb.append(">");
        return sb.toString();
    }
}

