/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.granite.util.ClassUtil;

public abstract class GenericTypeUtil {
    public static ParameterizedType[] getDeclaringTypes(Class<?> type) {
        ArrayList<ParameterizedType> supertypes = new ArrayList<ParameterizedType>();
        Type stype = type.getGenericSuperclass();
        for (Class<?> sclass = type.getSuperclass(); sclass != null && sclass != Object.class; sclass = sclass.getSuperclass()) {
            if (stype instanceof ParameterizedType) {
                supertypes.add((ParameterizedType)stype);
            }
            stype = sclass.getGenericSuperclass();
        }
        GenericTypeUtil.collectGenericInterfaces(type.getGenericInterfaces(), supertypes);
        return supertypes.isEmpty() ? null : supertypes.toArray(new ParameterizedType[supertypes.size()]);
    }

    private static void collectGenericInterfaces(Type[] types, List<ParameterizedType> supertypes) {
        if (types == null) {
            return;
        }
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                supertypes.add((ParameterizedType)t);
                continue;
            }
            GenericTypeUtil.collectGenericInterfaces(((Class)t).getGenericInterfaces(), supertypes);
        }
    }

    public static Type primitiveToWrapperType(Type type) {
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return type;
    }

    public static Type resolveTypeVariable(Type genericType, Class<?> declaringClass, ParameterizedType[] declaringTypes) {
        if (genericType instanceof TypeVariable && declaringTypes != null) {
            int index = -1;
            TypeVariable typeVariable = (TypeVariable)genericType;
            Type declaringType = null;
            block0: for (int j = 0; j < declaringClass.getTypeParameters().length; ++j) {
                TypeVariable<Class<?>> typeParameter = declaringClass.getTypeParameters()[j];
                if (typeParameter == typeVariable) {
                    index = j;
                } else if (typeVariable.getBounds() != null) {
                    for (Type type : typeVariable.getBounds()) {
                        if (typeParameter != type) continue;
                        index = j;
                        break;
                    }
                }
                if (index < 0) continue;
                for (Type type : declaringTypes) {
                    if (!declaringClass.isAssignableFrom(ClassUtil.classOfType(type))) continue;
                    declaringType = type;
                    break block0;
                }
                break;
            }
            if (declaringType != null && index >= 0 && index < declaringType.getActualTypeArguments().length) {
                return declaringType.getActualTypeArguments()[index];
            }
        }
        return genericType;
    }
}

