/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.util.PropertyDescriptor;

public abstract class ClassUtil {
    public static Object newInstance(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.forName(type).newInstance();
    }

    public static <T> T newInstance(String type, Class<T> cast) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.forName(type, cast).newInstance();
    }

    public static Object newInstance(String type, Class<?>[] argsClass, Object[] argsValues) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ClassUtil.newInstance(ClassUtil.forName(type), argsClass, argsValues);
    }

    public static <T> T newInstance(Class<?> type, Class<T> cast) throws InstantiationException, IllegalAccessException {
        return (T)type.newInstance();
    }

    public static <T> T newInstance(Class<T> type, Class<?>[] argsClass, Object[] argsValues) throws InstantiationException, IllegalAccessException {
        T instance = null;
        try {
            Constructor<T> constructorDef = type.getConstructor(argsClass);
            instance = constructorDef.newInstance(argsValues);
        }
        catch (SecurityException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException(e.getMessage());
        }
        return instance;
    }

    public static Class<?> forName(String type) throws ClassNotFoundException {
        try {
            return ClassUtil.class.getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader().loadClass(type);
        }
    }

    public static <T> Class<T> forName(String type, Class<T> cast) throws ClassNotFoundException {
        try {
            return ClassUtil.class.getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader().loadClass(type);
        }
    }

    public static Constructor<?> getConstructor(String type, Class<?>[] paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        return ClassUtil.getConstructor(ClassUtil.forName(type), paramTypes);
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?>[] paramTypes) throws NoSuchMethodException {
        return type.getConstructor(paramTypes);
    }

    public static <T> List<T> emptyList(Class<T> type) {
        return Collections.emptyList();
    }

    public static <T> Set<T> emptySet(Class<T> type) {
        return Collections.emptySet();
    }

    public static <T, U> Map<T, U> emptyMap(Class<T> keyType, Class<U> valueType) {
        return Collections.emptyMap();
    }

    public static boolean isPrimitive(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    public static Class<?> classOfType(Type type) {
        Type[] ubs;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof WildcardType && (ubs = ((WildcardType)type).getUpperBounds()).length > 0) {
            return ClassUtil.classOfType(ubs[0]);
        }
        if (type instanceof GenericArrayType) {
            Class<?> ct = ClassUtil.classOfType(((GenericArrayType)type).getGenericComponentType());
            return ct != null ? Array.newInstance(ct, 0).getClass() : Object[].class;
        }
        if (type instanceof TypeVariable && (ubs = ((TypeVariable)type).getBounds()).length > 0) {
            return ClassUtil.classOfType(ubs[0]);
        }
        return Object.class;
    }

    public static Type getBoundType(TypeVariable<?> typeVariable) {
        Type[] ubs = typeVariable.getBounds();
        if (ubs.length > 0) {
            return ubs[0];
        }
        if (typeVariable.getGenericDeclaration() instanceof Type) {
            return (Type)typeVariable.getGenericDeclaration();
        }
        return typeVariable;
    }

    public static String getPackageName(Class<?> clazz) {
        return clazz.getPackage() != null ? clazz.getPackage().getName() : "";
    }

    public static PropertyDescriptor[] getProperties(Class<?> clazz) {
        try {
            Field[] fields;
            PropertyDescriptor[] properties = new BeanInfo(clazz).getPropertyDescriptors();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!Boolean.class.equals(field.getType())) continue;
                boolean found = false;
                for (PropertyDescriptor property : properties) {
                    if (!property.getName().equals(field.getName())) continue;
                    found = true;
                    if (property.getReadMethod() != null) break;
                    try {
                        Method readMethod = clazz.getDeclaredMethod(ClassUtil.getIsMethodName(field.getName()), new Class[0]);
                        if (!Modifier.isPublic(readMethod.getModifiers()) || Modifier.isStatic(readMethod.getModifiers())) break;
                        property.setReadMethod(readMethod);
                    }
                    catch (NoSuchMethodException e) {}
                    break;
                }
                if (found) continue;
                try {
                    Method readMethod = clazz.getDeclaredMethod(ClassUtil.getIsMethodName(field.getName()), new Class[0]);
                    if (!Modifier.isPublic(readMethod.getModifiers()) || Modifier.isStatic(readMethod.getModifiers())) continue;
                    PropertyDescriptor[] propertiesTmp = new PropertyDescriptor[properties.length + 1];
                    System.arraycopy(properties, 0, propertiesTmp, 0, properties.length);
                    propertiesTmp[properties.length] = new PropertyDescriptor(field.getName(), readMethod, null);
                    properties = propertiesTmp;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not introspect properties of class: " + clazz, e);
        }
    }

    private static String getIsMethodName(String name) {
        return "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return clazz.getClassLoader() != null ? clazz.getClassLoader() : ClassLoader.getSystemClassLoader();
    }

    public static URL findResource(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return null;
        }
        URL url = ClassUtil.getClassLoader(clazz).getResource(ClassUtil.toResourceName(clazz));
        String path = url.toString();
        if (path.indexOf(32) != -1) {
            try {
                url = new URL(path.replace(" ", "%20"));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static String toResourceName(Class<?> clazz) {
        return clazz.getName().replace('.', '/').concat(".class");
    }

    public static String getMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName()).append('(');
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ClassUtil.getTypeSignature(params[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getTypeSignature(Class<?> type) {
        if (type.isArray()) {
            try {
                int dimensions = 1;
                Class<?> clazz = type.getComponentType();
                while (clazz.isArray()) {
                    ++dimensions;
                    clazz = clazz.getComponentType();
                }
                StringBuffer sb = new StringBuffer(clazz.getName());
                while (dimensions-- > 0) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static Method getMethod(Class<?> clazz, String signature) throws NoSuchMethodException {
        if (!(signature = ClassUtil.removeSpaces(signature)).endsWith(")")) {
            signature = signature + "()";
        }
        for (Method method : clazz.getMethods()) {
            if (!signature.equals(ClassUtil.getMethodSignature(method))) continue;
            return method;
        }
        throw new NoSuchMethodException("Could not find method: " + signature + " in class: " + clazz);
    }

    public static String removeSpaces(String s) {
        if (s == null) {
            return null;
        }
        String[] tokens = s.split("\\s", -1);
        if (tokens.length == 0) {
            return "";
        }
        if (tokens.length == 1) {
            return tokens[0];
        }
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            sb.append(token);
        }
        return sb.toString();
    }

    public static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean isAnnotationPresent(AnnotatedElement elmt, Class<? extends Annotation> annotationClass) {
        return ClassUtil.getAnnotation(elmt, annotationClass) != null;
    }

    public static <T extends Annotation> DeclaredAnnotation<T> getAnnotation(AnnotatedElement elmt, Class<T> annotationClass) {
        T annotation = elmt.getAnnotation(annotationClass);
        if (annotation != null) {
            Class<?> declaringClass = elmt instanceof Member ? ((Member)((Object)elmt)).getDeclaringClass() : (Class<?>)elmt;
            return new DeclaredAnnotation<T>(annotation, elmt, declaringClass);
        }
        if (elmt instanceof Field) {
            return null;
        }
        if (elmt instanceof Method) {
            Method m = (Method)elmt;
            return ClassUtil.getMethodAnnotation(m.getDeclaringClass(), m.getName(), m.getParameterTypes(), annotationClass);
        }
        if (elmt instanceof Constructor) {
            Constructor c = (Constructor)elmt;
            return ClassUtil.getConstructorAnnotation(c.getDeclaringClass(), annotationClass);
        }
        if (elmt instanceof Class) {
            Class c = (Class)elmt;
            return ClassUtil.getClassAnnotation(c.getDeclaringClass(), annotationClass);
        }
        throw new RuntimeException("Unsupported annotated element: " + elmt);
    }

    public static <T extends Annotation> DeclaredAnnotation<T> getMethodAnnotation(Class<?> clazz, String name, Class<?>[] parameterTypes, Class<T> annotationClass) {
        DeclaredAnnotation<T> declaredAnnotation = null;
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            T annotation = clazz.getDeclaredMethod(name, parameterTypes).getAnnotation(annotationClass);
            if (annotation != null) {
                declaredAnnotation = new DeclaredAnnotation<T>(annotation, method, clazz);
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (declaredAnnotation == null && clazz.getSuperclass() != null) {
            declaredAnnotation = ClassUtil.getMethodAnnotation(clazz.getSuperclass(), name, parameterTypes, annotationClass);
        }
        if (declaredAnnotation == null) {
            Class<?> interfaze;
            Class<?>[] arr$ = clazz.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (declaredAnnotation = ClassUtil.getMethodAnnotation(interfaze = arr$[i$], name, parameterTypes, annotationClass)) == null; ++i$) {
            }
        }
        return declaredAnnotation;
    }

    public static <T extends Annotation> DeclaredAnnotation<T> getConstructorAnnotation(Class<?> clazz, Class<T> annotationClass) {
        DeclaredAnnotation<Object> declaredAnnotation = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Object annotation = constructor.getAnnotation(annotationClass);
            if (annotation == null) continue;
            declaredAnnotation = new DeclaredAnnotation(annotation, constructor, clazz);
            break;
        }
        if (declaredAnnotation == null && clazz.getSuperclass() != null) {
            declaredAnnotation = ClassUtil.getConstructorAnnotation(clazz.getSuperclass(), annotationClass);
        }
        return declaredAnnotation;
    }

    public static <T extends Annotation> DeclaredAnnotation<T> getClassAnnotation(Class<?> clazz, Class<T> annotationClass) {
        DeclaredAnnotation<T> declaredAnnotation = null;
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            declaredAnnotation = new DeclaredAnnotation<T>(annotation, clazz, clazz);
        } else {
            if (clazz.getSuperclass() != null) {
                declaredAnnotation = ClassUtil.getClassAnnotation(clazz.getSuperclass(), annotationClass);
            }
            if (declaredAnnotation == null) {
                Class<?> interfaze;
                Class<?>[] arr$ = clazz.getInterfaces();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (declaredAnnotation = ClassUtil.getClassAnnotation(interfaze = arr$[i$], annotationClass)) == null; ++i$) {
                }
            }
        }
        return declaredAnnotation;
    }

    private static class BeanInfo {
        private Class<?> beanClass;
        private PropertyDescriptor[] properties = null;

        public BeanInfo(Class<?> beanClass) {
            this.beanClass = beanClass;
            if (this.properties == null) {
                this.properties = this.introspectProperties();
            }
        }

        public PropertyDescriptor[] getPropertyDescriptors() {
            return this.properties;
        }

        private PropertyDescriptor[] introspectProperties() {
            Method[] methods = this.beanClass.getMethods();
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (Method method : methods) {
                if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                methodList.add(method);
            }
            HashMap<String, Map<String, Object>> propertyMap = new HashMap<String, Map<String, Object>>(methodList.size());
            for (Method method : methodList) {
                BeanInfo.introspectGet(method, propertyMap);
                BeanInfo.introspectSet(method, propertyMap);
            }
            this.fixGetSet(propertyMap);
            ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
            for (Map.Entry entry : propertyMap.entrySet()) {
                String propertyName = (String)entry.getKey();
                Map table = (Map)entry.getValue();
                if (table == null) continue;
                Method getter = (Method)table.get("getter");
                Method setter = (Method)table.get("setter");
                PropertyDescriptor propertyDesc = new PropertyDescriptor(propertyName, getter, setter);
                propertyList.add(propertyDesc);
            }
            PropertyDescriptor[] properties = new PropertyDescriptor[propertyList.size()];
            propertyList.toArray(properties);
            return properties;
        }

        private static void introspectGet(Method method, Map<String, Map<String, Object>> propertyMap) {
            ArrayList<Method> getters;
            String methodName = method.getName();
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                return;
            }
            if (method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE) {
                return;
            }
            if (method.getName().startsWith("is") && method.getReturnType() != Boolean.TYPE) {
                return;
            }
            String propertyName = method.getName().startsWith("get") ? methodName.substring(3) : methodName.substring(2);
            Map<String, Object> table = propertyMap.get(propertyName = ClassUtil.decapitalize(propertyName));
            if (table == null) {
                table = new HashMap<String, Object>();
                propertyMap.put(propertyName, table);
            }
            if ((getters = (ArrayList<Method>)table.get("getters")) == null) {
                getters = new ArrayList<Method>();
                table.put("getters", getters);
            }
            getters.add(method);
        }

        private static void introspectSet(Method method, Map<String, Map<String, Object>> propertyMap) {
            ArrayList<Method> setters;
            String methodName = method.getName();
            if (!method.getName().startsWith("set")) {
                return;
            }
            if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) {
                return;
            }
            String propertyName = ClassUtil.decapitalize(methodName.substring(3));
            Map<String, Object> table = propertyMap.get(propertyName);
            if (table == null) {
                table = new HashMap<String, Object>();
                propertyMap.put(propertyName, table);
            }
            if ((setters = (ArrayList<Method>)table.get("setters")) == null) {
                setters = new ArrayList<Method>();
                table.put("setters", setters);
            }
            setters.add(method);
        }

        private void fixGetSet(Map<String, Map<String, Object>> propertyMap) {
            if (propertyMap == null) {
                return;
            }
            for (Map.Entry<String, Map<String, Object>> entry : propertyMap.entrySet()) {
                Map<String, Object> table = entry.getValue();
                ArrayList getters = (ArrayList)table.get("getters");
                ArrayList setters = (ArrayList)table.get("setters");
                if (getters == null) {
                    getters = new ArrayList();
                }
                if (setters == null) {
                    setters = new ArrayList();
                }
                Method definedGetter = getters.isEmpty() ? null : (Method)getters.get(0);
                Method definedSetter = null;
                if (definedGetter != null) {
                    Class<?> propertyType = definedGetter.getReturnType();
                    for (Method setter : setters) {
                        if (setter.getParameterTypes().length != 1 || !propertyType.equals(setter.getParameterTypes()[0])) continue;
                        definedSetter = setter;
                        break;
                    }
                    if (definedSetter != null && !setters.isEmpty()) {
                        definedSetter = (Method)setters.get(0);
                    }
                } else if (!setters.isEmpty()) {
                    definedSetter = (Method)setters.get(0);
                }
                table.put("getter", definedGetter);
                table.put("setter", definedSetter);
            }
        }
    }

    public static class DeclaredAnnotation<T extends Annotation> {
        public final T annotation;
        public final AnnotatedElement annotatedElement;
        public final Class<?> declaringClass;

        public DeclaredAnnotation(T annotation, AnnotatedElement annotatedElement, Class<?> declaringClass) {
            this.annotation = annotation;
            this.annotatedElement = annotatedElement;
            this.declaringClass = declaringClass;
        }

        public String toString() {
            return this.getClass().getName() + "{annotation=" + this.annotation + ", annotatedElement=" + this.annotatedElement + ", declaringClass=" + this.declaringClass + "}";
        }
    }
}

