/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.Method;

public class PropertyDescriptor {
    private String name;
    private Method getter;
    private Method setter;

    public PropertyDescriptor(String propertyName, Method getter, Method setter) {
        this.name = propertyName;
        this.setReadMethod(getter);
        this.setWriteMethod(setter);
    }

    public String getName() {
        return this.name;
    }

    public void setWriteMethod(Method setter) {
        this.setter = setter;
    }

    public void setReadMethod(Method getter) {
        this.getter = getter;
    }

    public Method getWriteMethod() {
        return this.setter;
    }

    public Method getReadMethod() {
        return this.getter;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor pd = (PropertyDescriptor)object;
        if (!(this.getter == null && pd.getter == null || this.getter != null && this.getter.equals(pd.getter))) {
            return false;
        }
        if (!(this.setter == null && pd.setter == null || this.setter != null && this.setter.equals(pd.setter))) {
            return false;
        }
        return this.getPropertyType() == pd.getPropertyType();
    }

    public int hashCode() {
        int hashCode;
        int n = hashCode = this.getter != null ? this.getter.hashCode() : 0;
        if (this.setter != null) {
            hashCode = hashCode * 31 + this.setter.hashCode();
        }
        if (this.getPropertyType() != null) {
            hashCode = hashCode * 31 + this.getPropertyType().hashCode();
        }
        return hashCode;
    }

    public Class<?> getPropertyType() {
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        if (this.setter != null) {
            Class<?>[] parameterTypes = this.setter.getParameterTypes();
            return parameterTypes[0];
        }
        return null;
    }
}

